# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.26
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ContentV1PresetDataSourceListItemsInner(BaseModel):
    """
    ContentV1PresetDataSourceListItemsInner
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="The internal name of the preset.")
    source: Optional[StrictStr] = Field(default=None, description="The source (cloud provider, etc.) of the data.")
    source_type: Optional[StrictStr] = Field(default=None, description="The type of data (e.g. Route53, etc.). This can also be viewed as the service provided by the source.", alias="sourceType")
    description: Optional[StrictStr] = Field(default=None, description="A brief description of the preset including intended use, expectations, etc. that a user may want to be aware of.")
    title: Optional[StrictStr] = Field(default=None, description="A formatted, human-readable title for the preset.")
    author: Optional[StrictStr] = Field(default=None, description="The organization or individual that authored the preset.")
    icon_url: Optional[StrictStr] = Field(default=None, description="A URL to an icon representing the preset. This icon will be displayed in the UI.", alias="iconURL")
    target_medallion: Optional[StrictStr] = Field(default=None, description="The final medallion layer this preset writes to (bronze, silver, or gold). Note, a null value is returned if no stages materialize a table.", alias="targetMedallion")
    __properties: ClassVar[List[str]] = ["name", "source", "sourceType", "description", "title", "author", "iconURL", "targetMedallion"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ContentV1PresetDataSourceListItemsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if source (nullable) is None
        # and model_fields_set contains the field
        if self.source is None and "source" in self.model_fields_set:
            _dict['source'] = None

        # set to None if source_type (nullable) is None
        # and model_fields_set contains the field
        if self.source_type is None and "source_type" in self.model_fields_set:
            _dict['sourceType'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if title (nullable) is None
        # and model_fields_set contains the field
        if self.title is None and "title" in self.model_fields_set:
            _dict['title'] = None

        # set to None if author (nullable) is None
        # and model_fields_set contains the field
        if self.author is None and "author" in self.model_fields_set:
            _dict['author'] = None

        # set to None if icon_url (nullable) is None
        # and model_fields_set contains the field
        if self.icon_url is None and "icon_url" in self.model_fields_set:
            _dict['iconURL'] = None

        # set to None if target_medallion (nullable) is None
        # and model_fields_set contains the field
        if self.target_medallion is None and "target_medallion" in self.model_fields_set:
            _dict['targetMedallion'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ContentV1PresetDataSourceListItemsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "source": obj.get("source"),
            "sourceType": obj.get("sourceType"),
            "description": obj.get("description"),
            "title": obj.get("title"),
            "author": obj.get("author"),
            "iconURL": obj.get("iconURL"),
            "targetMedallion": obj.get("targetMedallion")
        })
        return _obj


