# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.26
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from dasl_api.models.core_v1_data_source_autoloader_spec import CoreV1DataSourceAutoloaderSpec
from dasl_api.models.core_v1_data_source_primary_key_spec import CoreV1DataSourcePrimaryKeySpec
from dasl_api.models.core_v1_data_source_spec_bronze import CoreV1DataSourceSpecBronze
from dasl_api.models.core_v1_data_source_spec_custom import CoreV1DataSourceSpecCustom
from dasl_api.models.core_v1_data_source_spec_gold import CoreV1DataSourceSpecGold
from dasl_api.models.core_v1_data_source_spec_silver import CoreV1DataSourceSpecSilver
from dasl_api.models.core_v1_schedule import CoreV1Schedule
from typing import Optional, Set
from typing_extensions import Self

class CoreV1DataSourceSpec(BaseModel):
    """
    CoreV1DataSourceSpec
    """ # noqa: E501
    target_medallion: Optional[StrictStr] = Field(default=None, description="GET the color of the final medallion table materialized.", alias="targetMedallion")
    source: Optional[StrictStr] = Field(default=None, description="The name of originator of the data we will import (GCP, AWS, Okta, etc).")
    source_type: Optional[StrictStr] = Field(default=None, description="The type of data we are importing from the source (e.g. S3, LB, etc).", alias="sourceType")
    schedule: CoreV1Schedule
    custom: Optional[CoreV1DataSourceSpecCustom] = None
    epoch: Optional[StrictInt] = Field(default=0, description="Epochs let you reload data from the source, which is useful when  applying new transformation logic to historical records. Increasing  this value starts a new processing cycle, ignoring previous  checkpoints and reading the data again from the source.  You can only increase the value by one. For example, if the current  value is `1`, only `1` or `2` will be accepted. Additionally, when  reprocessing historical data, spark will use the `mergeInto` feature along with the `DataSourceSpec.primaryKey` values to ensure no  duplicate records are created. ")
    use_preset: Optional[StrictStr] = Field(default=None, description="The name of the preset to use for this datasource. ", alias="usePreset")
    use_preset_version: Optional[StrictInt] = Field(default=None, description="The version number of the preset to use. Defaults to latest if not provided.", alias="usePresetVersion")
    primary_key: Optional[CoreV1DataSourcePrimaryKeySpec] = Field(default=None, description="Configuration used to compute a primary key which will be composed of a timestamp plus hash computed over a set of columns. This primary key will be used for automatic deduplication when re-ingesting raw data and prevents duplicate rows being created. ", alias="primaryKey")
    autoloader: Optional[CoreV1DataSourceAutoloaderSpec] = Field(default=None, description="Describes how to import data into the bronze table(s) overriding the chosen preset autoloader. ")
    compute_mode: Optional[StrictStr] = Field(default='high', description="The default compute mode used by datasource jobs. These are \"standard\" for STANDARD, and \"high\" for PERFORMANCE_OPTIMIZED mode. If not set, \"high\" is used as the default value. ", alias="computeMode")
    bronze: Optional[CoreV1DataSourceSpecBronze] = None
    silver: Optional[CoreV1DataSourceSpecSilver] = None
    gold: Optional[CoreV1DataSourceSpecGold] = None
    __properties: ClassVar[List[str]] = ["targetMedallion", "source", "sourceType", "schedule", "custom", "epoch", "usePreset", "usePresetVersion", "primaryKey", "autoloader", "computeMode", "bronze", "silver", "gold"]

    @field_validator('compute_mode')
    def compute_mode_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['standard', 'high']):
            raise ValueError("must be one of enum values ('standard', 'high')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CoreV1DataSourceSpec from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of schedule
        if self.schedule:
            _dict['schedule'] = self.schedule.to_dict()
        # override the default output from pydantic by calling `to_dict()` of custom
        if self.custom:
            _dict['custom'] = self.custom.to_dict()
        # override the default output from pydantic by calling `to_dict()` of primary_key
        if self.primary_key:
            _dict['primaryKey'] = self.primary_key.to_dict()
        # override the default output from pydantic by calling `to_dict()` of autoloader
        if self.autoloader:
            _dict['autoloader'] = self.autoloader.to_dict()
        # override the default output from pydantic by calling `to_dict()` of bronze
        if self.bronze:
            _dict['bronze'] = self.bronze.to_dict()
        # override the default output from pydantic by calling `to_dict()` of silver
        if self.silver:
            _dict['silver'] = self.silver.to_dict()
        # override the default output from pydantic by calling `to_dict()` of gold
        if self.gold:
            _dict['gold'] = self.gold.to_dict()
        # set to None if target_medallion (nullable) is None
        # and model_fields_set contains the field
        if self.target_medallion is None and "target_medallion" in self.model_fields_set:
            _dict['targetMedallion'] = None

        # set to None if source (nullable) is None
        # and model_fields_set contains the field
        if self.source is None and "source" in self.model_fields_set:
            _dict['source'] = None

        # set to None if source_type (nullable) is None
        # and model_fields_set contains the field
        if self.source_type is None and "source_type" in self.model_fields_set:
            _dict['sourceType'] = None

        # set to None if custom (nullable) is None
        # and model_fields_set contains the field
        if self.custom is None and "custom" in self.model_fields_set:
            _dict['custom'] = None

        # set to None if epoch (nullable) is None
        # and model_fields_set contains the field
        if self.epoch is None and "epoch" in self.model_fields_set:
            _dict['epoch'] = None

        # set to None if use_preset (nullable) is None
        # and model_fields_set contains the field
        if self.use_preset is None and "use_preset" in self.model_fields_set:
            _dict['usePreset'] = None

        # set to None if use_preset_version (nullable) is None
        # and model_fields_set contains the field
        if self.use_preset_version is None and "use_preset_version" in self.model_fields_set:
            _dict['usePresetVersion'] = None

        # set to None if primary_key (nullable) is None
        # and model_fields_set contains the field
        if self.primary_key is None and "primary_key" in self.model_fields_set:
            _dict['primaryKey'] = None

        # set to None if autoloader (nullable) is None
        # and model_fields_set contains the field
        if self.autoloader is None and "autoloader" in self.model_fields_set:
            _dict['autoloader'] = None

        # set to None if compute_mode (nullable) is None
        # and model_fields_set contains the field
        if self.compute_mode is None and "compute_mode" in self.model_fields_set:
            _dict['computeMode'] = None

        # set to None if bronze (nullable) is None
        # and model_fields_set contains the field
        if self.bronze is None and "bronze" in self.model_fields_set:
            _dict['bronze'] = None

        # set to None if silver (nullable) is None
        # and model_fields_set contains the field
        if self.silver is None and "silver" in self.model_fields_set:
            _dict['silver'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CoreV1DataSourceSpec from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "targetMedallion": obj.get("targetMedallion"),
            "source": obj.get("source"),
            "sourceType": obj.get("sourceType"),
            "schedule": CoreV1Schedule.from_dict(obj["schedule"]) if obj.get("schedule") is not None else None,
            "custom": CoreV1DataSourceSpecCustom.from_dict(obj["custom"]) if obj.get("custom") is not None else None,
            "epoch": obj.get("epoch") if obj.get("epoch") is not None else 0,
            "usePreset": obj.get("usePreset"),
            "usePresetVersion": obj.get("usePresetVersion"),
            "primaryKey": CoreV1DataSourcePrimaryKeySpec.from_dict(obj["primaryKey"]) if obj.get("primaryKey") is not None else None,
            "autoloader": CoreV1DataSourceAutoloaderSpec.from_dict(obj["autoloader"]) if obj.get("autoloader") is not None else None,
            "computeMode": obj.get("computeMode") if obj.get("computeMode") is not None else 'high',
            "bronze": CoreV1DataSourceSpecBronze.from_dict(obj["bronze"]) if obj.get("bronze") is not None else None,
            "silver": CoreV1DataSourceSpecSilver.from_dict(obj["silver"]) if obj.get("silver") is not None else None,
            "gold": CoreV1DataSourceSpecGold.from_dict(obj["gold"]) if obj.get("gold") is not None else None
        })
        return _obj


