# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.26
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dasl_api.models.core_v1_data_source_spec_bronze_clustering import CoreV1DataSourceSpecBronzeClustering
from typing import Optional, Set
from typing_extensions import Self

class CoreV1DataSourceSpecBronze(BaseModel):
    """
    Describes what and how to import the data into a single bronze table.
    """ # noqa: E501
    clustering: Optional[CoreV1DataSourceSpecBronzeClustering] = None
    bronze_table: Optional[StrictStr] = Field(default=None, description="The name of the bronze table to create and hold the imported data.", alias="bronzeTable")
    skip_bronze_loading: Optional[StrictBool] = Field(default=None, description="Whether to skip the bronze loading step. This could be useful if data is already in a Unity Catalog table, etc.", alias="skipBronzeLoading")
    load_as_single_variant: Optional[StrictBool] = Field(default=None, description="Whether to ingest the data as a single variant column called `data` (defaults to false if not provided). This will turn off all schema hints and type inference. Use preTransform option to extract individual fields into typed columns before writing to the bronze table. Please note that VARIANT type can only hold records up to 16mb in size. For more details see: http://docs.databricks.com/aws/en/ingestion/variant#ingest-data-from-cloud-object-storage-as-variant ", alias="loadAsSingleVariant")
    pre_transform: Optional[List[List[StrictStr]]] = Field(default=None, description="A set of SQL expressions to apply before writing the data frame ingested by autoloader to the bronze table. Use this to unpack, unwrap or unroll data into individual rows that would otherwise get ingested as a single highly nested row. When `loadAsSingleVariant` is enabled use this to extract individual fields from the `data` VARIANT column. This is a nested array. Each item in the outer array will result in a different, individual selectExpr execution. This allows to chain multiple passes - for example if the data needs to be unpacked multiple levels. The inner array contains the actual expressions to be included for each selectExpr. ", alias="preTransform")
    __properties: ClassVar[List[str]] = ["clustering", "bronzeTable", "skipBronzeLoading", "loadAsSingleVariant", "preTransform"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CoreV1DataSourceSpecBronze from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of clustering
        if self.clustering:
            _dict['clustering'] = self.clustering.to_dict()
        # set to None if clustering (nullable) is None
        # and model_fields_set contains the field
        if self.clustering is None and "clustering" in self.model_fields_set:
            _dict['clustering'] = None

        # set to None if bronze_table (nullable) is None
        # and model_fields_set contains the field
        if self.bronze_table is None and "bronze_table" in self.model_fields_set:
            _dict['bronzeTable'] = None

        # set to None if skip_bronze_loading (nullable) is None
        # and model_fields_set contains the field
        if self.skip_bronze_loading is None and "skip_bronze_loading" in self.model_fields_set:
            _dict['skipBronzeLoading'] = None

        # set to None if load_as_single_variant (nullable) is None
        # and model_fields_set contains the field
        if self.load_as_single_variant is None and "load_as_single_variant" in self.model_fields_set:
            _dict['loadAsSingleVariant'] = None

        # set to None if pre_transform (nullable) is None
        # and model_fields_set contains the field
        if self.pre_transform is None and "pre_transform" in self.model_fields_set:
            _dict['preTransform'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CoreV1DataSourceSpecBronze from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "clustering": CoreV1DataSourceSpecBronzeClustering.from_dict(obj["clustering"]) if obj.get("clustering") is not None else None,
            "bronzeTable": obj.get("bronzeTable"),
            "skipBronzeLoading": obj.get("skipBronzeLoading"),
            "loadAsSingleVariant": obj.get("loadAsSingleVariant"),
            "preTransform": obj.get("preTransform")
        })
        return _obj


