# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.26
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from dasl_api.models.core_v1_data_source_spec_silver_bronze_tables_inner import CoreV1DataSourceSpecSilverBronzeTablesInner
from dasl_api.models.core_v1_data_source_spec_silver_pre_transform import CoreV1DataSourceSpecSilverPreTransform
from dasl_api.models.core_v1_data_source_spec_silver_transform import CoreV1DataSourceSpecSilverTransform
from typing import Optional, Set
from typing_extensions import Self

class CoreV1DataSourceSpecSilver(BaseModel):
    """
    CoreV1DataSourceSpecSilver
    """ # noqa: E501
    bronze_tables: Optional[List[CoreV1DataSourceSpecSilverBronzeTablesInner]] = Field(default=None, description="A list of bronze tables to be joined together for use by the silver transformation. Note: if a bronzeTable is defined and bronze.skipBronzeLoading is false: The first entry in this list will be ignored. If you want to join 2 additional tables to the autoloader bronzeTable. This list needs 3 entries where the first entry needs to match the name of bronze.bronzeTable ", alias="bronzeTables")
    pre_transform: Optional[CoreV1DataSourceSpecSilverPreTransform] = Field(default=None, alias="preTransform")
    transform: Optional[CoreV1DataSourceSpecSilverTransform] = None
    __properties: ClassVar[List[str]] = ["bronzeTables", "preTransform", "transform"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CoreV1DataSourceSpecSilver from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in bronze_tables (list)
        _items = []
        if self.bronze_tables:
            for _item_bronze_tables in self.bronze_tables:
                if _item_bronze_tables:
                    _items.append(_item_bronze_tables.to_dict())
            _dict['bronzeTables'] = _items
        # override the default output from pydantic by calling `to_dict()` of pre_transform
        if self.pre_transform:
            _dict['preTransform'] = self.pre_transform.to_dict()
        # override the default output from pydantic by calling `to_dict()` of transform
        if self.transform:
            _dict['transform'] = self.transform.to_dict()
        # set to None if bronze_tables (nullable) is None
        # and model_fields_set contains the field
        if self.bronze_tables is None and "bronze_tables" in self.model_fields_set:
            _dict['bronzeTables'] = None

        # set to None if pre_transform (nullable) is None
        # and model_fields_set contains the field
        if self.pre_transform is None and "pre_transform" in self.model_fields_set:
            _dict['preTransform'] = None

        # set to None if transform (nullable) is None
        # and model_fields_set contains the field
        if self.transform is None and "transform" in self.model_fields_set:
            _dict['transform'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CoreV1DataSourceSpecSilver from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "bronzeTables": [CoreV1DataSourceSpecSilverBronzeTablesInner.from_dict(_item) for _item in obj["bronzeTables"]] if obj.get("bronzeTables") is not None else None,
            "preTransform": CoreV1DataSourceSpecSilverPreTransform.from_dict(obj["preTransform"]) if obj.get("preTransform") is not None else None,
            "transform": CoreV1DataSourceSpecSilverTransform.from_dict(obj["transform"]) if obj.get("transform") is not None else None
        })
        return _obj


