# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.26
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dasl_api.models.core_v1_data_source_field_spec import CoreV1DataSourceFieldSpec
from dasl_api.models.core_v1_data_source_field_utils import CoreV1DataSourceFieldUtils
from dasl_api.models.core_v1_data_source_spec_silver_transform_preset_overrides_modify_tables_inner_custom import CoreV1DataSourceSpecSilverTransformPresetOverridesModifyTablesInnerCustom
from typing import Optional, Set
from typing_extensions import Self

class CoreV1DataSourceSpecSilverTransformPresetOverridesModifyTablesInner(BaseModel):
    """
    CoreV1DataSourceSpecSilverTransformPresetOverridesModifyTablesInner
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="The table name this object applies to as found in the preset's list of tables it works with. Note that only one entry is allowed per table name, ignoring catalog.schema if specified. ")
    custom: Optional[CoreV1DataSourceSpecSilverTransformPresetOverridesModifyTablesInnerCustom] = None
    omit_fields: Optional[List[StrictStr]] = Field(default=None, description="A list of fields to omit from the chosen preset.", alias="omitFields")
    override_liquid_columns: Optional[List[StrictStr]] = Field(default=None, alias="overrideLiquidColumns")
    add_fields: Optional[List[Optional[CoreV1DataSourceFieldSpec]]] = Field(default=None, description="User defined fields to add to the data transformation. These fields can be derived from  existing fields, an expression, from a literal value, from a join, etc. ", alias="addFields")
    filter: Optional[StrictStr] = None
    post_filter: Optional[StrictStr] = Field(default=None, alias="postFilter")
    utils: Optional[CoreV1DataSourceFieldUtils] = None
    __properties: ClassVar[List[str]] = ["name", "custom", "omitFields", "overrideLiquidColumns", "addFields", "filter", "postFilter", "utils"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CoreV1DataSourceSpecSilverTransformPresetOverridesModifyTablesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of custom
        if self.custom:
            _dict['custom'] = self.custom.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in add_fields (list)
        _items = []
        if self.add_fields:
            for _item_add_fields in self.add_fields:
                if _item_add_fields:
                    _items.append(_item_add_fields.to_dict())
            _dict['addFields'] = _items
        # override the default output from pydantic by calling `to_dict()` of utils
        if self.utils:
            _dict['utils'] = self.utils.to_dict()
        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if custom (nullable) is None
        # and model_fields_set contains the field
        if self.custom is None and "custom" in self.model_fields_set:
            _dict['custom'] = None

        # set to None if omit_fields (nullable) is None
        # and model_fields_set contains the field
        if self.omit_fields is None and "omit_fields" in self.model_fields_set:
            _dict['omitFields'] = None

        # set to None if override_liquid_columns (nullable) is None
        # and model_fields_set contains the field
        if self.override_liquid_columns is None and "override_liquid_columns" in self.model_fields_set:
            _dict['overrideLiquidColumns'] = None

        # set to None if add_fields (nullable) is None
        # and model_fields_set contains the field
        if self.add_fields is None and "add_fields" in self.model_fields_set:
            _dict['addFields'] = None

        # set to None if filter (nullable) is None
        # and model_fields_set contains the field
        if self.filter is None and "filter" in self.model_fields_set:
            _dict['filter'] = None

        # set to None if post_filter (nullable) is None
        # and model_fields_set contains the field
        if self.post_filter is None and "post_filter" in self.model_fields_set:
            _dict['postFilter'] = None

        # set to None if utils (nullable) is None
        # and model_fields_set contains the field
        if self.utils is None and "utils" in self.model_fields_set:
            _dict['utils'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CoreV1DataSourceSpecSilverTransformPresetOverridesModifyTablesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "custom": CoreV1DataSourceSpecSilverTransformPresetOverridesModifyTablesInnerCustom.from_dict(obj["custom"]) if obj.get("custom") is not None else None,
            "omitFields": obj.get("omitFields"),
            "overrideLiquidColumns": obj.get("overrideLiquidColumns"),
            "addFields": [CoreV1DataSourceFieldSpec.from_dict(_item) for _item in obj["addFields"]] if obj.get("addFields") is not None else None,
            "filter": obj.get("filter"),
            "postFilter": obj.get("postFilter"),
            "utils": CoreV1DataSourceFieldUtils.from_dict(obj["utils"]) if obj.get("utils") is not None else None
        })
        return _obj


