# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.26
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from dasl_api.models.core_v1_query_execution_status_context import CoreV1QueryExecutionStatusContext
from typing import Optional, Set
from typing_extensions import Self

class CoreV1QueryExecutionStatus(BaseModel):
    """
    The current status of the query resource.
    """ # noqa: E501
    statement_id: Optional[StrictStr] = Field(default=None, description="The Databricks statement ID", alias="statementID")
    table_name: Optional[StrictStr] = Field(default=None, description="The name of the underlying table storing the query results.", alias="tableName")
    cancel: Optional[StrictBool] = Field(default=None, description="A flag indicating if a cancel request was submitted for this query.")
    status: StrictStr = Field(description="the current state of the query statement.")
    context: Optional[CoreV1QueryExecutionStatusContext] = None
    __properties: ClassVar[List[str]] = ["statementID", "tableName", "cancel", "status", "context"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['pending', 'running', 'succeeded', 'failed']):
            raise ValueError("must be one of enum values ('pending', 'running', 'succeeded', 'failed')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CoreV1QueryExecutionStatus from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of context
        if self.context:
            _dict['context'] = self.context.to_dict()
        # set to None if statement_id (nullable) is None
        # and model_fields_set contains the field
        if self.statement_id is None and "statement_id" in self.model_fields_set:
            _dict['statementID'] = None

        # set to None if table_name (nullable) is None
        # and model_fields_set contains the field
        if self.table_name is None and "table_name" in self.model_fields_set:
            _dict['tableName'] = None

        # set to None if cancel (nullable) is None
        # and model_fields_set contains the field
        if self.cancel is None and "cancel" in self.model_fields_set:
            _dict['cancel'] = None

        # set to None if context (nullable) is None
        # and model_fields_set contains the field
        if self.context is None and "context" in self.model_fields_set:
            _dict['context'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CoreV1QueryExecutionStatus from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "statementID": obj.get("statementID"),
            "tableName": obj.get("tableName"),
            "cancel": obj.get("cancel"),
            "status": obj.get("status"),
            "context": CoreV1QueryExecutionStatusContext.from_dict(obj["context"]) if obj.get("context") is not None else None
        })
        return _obj


