# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.26
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CoreV1QueryExecutionStatusContext(BaseModel):
    """
    Additional details, depending on the value of the status field. If the status field is pending, then the positionInQueue field may be populated. If the status field is running, then the tasks fields may be populated. If the status field is succeeded, then none of the fields will be populated. If the status field is failed, then the errorMessage field will be populated. When the status field is pending or running, the corresponding fields will not necessarily be populated; whether the field is populated or not depends on whether the relevant information can be fetched from the Databricks API. 
    """ # noqa: E501
    error_message: Optional[StrictStr] = Field(default=None, description="A detailed description of the error, as returned by the Databricks API. ", alias="errorMessage")
    position_in_queue: Optional[StrictInt] = Field(default=None, description="The approximate position in the queue, when the query is queued and waiting to be processed by the SQL warehouse. When this value is 1, then the query will be the next task for the SQL warehouse. ", alias="positionInQueue")
    total_tasks: Optional[StrictInt] = Field(default=None, description="The total number of tasks in the plan for the query. ", alias="totalTasks")
    active_tasks: Optional[StrictInt] = Field(default=None, description="The number of currently active tasks in the plan for the query. ", alias="activeTasks")
    complete_tasks: Optional[StrictInt] = Field(default=None, description="The number of completed tasks in the plan for the query. ", alias="completeTasks")
    failed_tasks: Optional[StrictInt] = Field(default=None, description="The number of failed tasks in the plan for the query. ", alias="failedTasks")
    killed_tasks: Optional[StrictInt] = Field(default=None, description="The number of killed tasks in the plan for the query. ", alias="killedTasks")
    __properties: ClassVar[List[str]] = ["errorMessage", "positionInQueue", "totalTasks", "activeTasks", "completeTasks", "failedTasks", "killedTasks"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CoreV1QueryExecutionStatusContext from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if error_message (nullable) is None
        # and model_fields_set contains the field
        if self.error_message is None and "error_message" in self.model_fields_set:
            _dict['errorMessage'] = None

        # set to None if position_in_queue (nullable) is None
        # and model_fields_set contains the field
        if self.position_in_queue is None and "position_in_queue" in self.model_fields_set:
            _dict['positionInQueue'] = None

        # set to None if total_tasks (nullable) is None
        # and model_fields_set contains the field
        if self.total_tasks is None and "total_tasks" in self.model_fields_set:
            _dict['totalTasks'] = None

        # set to None if active_tasks (nullable) is None
        # and model_fields_set contains the field
        if self.active_tasks is None and "active_tasks" in self.model_fields_set:
            _dict['activeTasks'] = None

        # set to None if complete_tasks (nullable) is None
        # and model_fields_set contains the field
        if self.complete_tasks is None and "complete_tasks" in self.model_fields_set:
            _dict['completeTasks'] = None

        # set to None if failed_tasks (nullable) is None
        # and model_fields_set contains the field
        if self.failed_tasks is None and "failed_tasks" in self.model_fields_set:
            _dict['failedTasks'] = None

        # set to None if killed_tasks (nullable) is None
        # and model_fields_set contains the field
        if self.killed_tasks is None and "killed_tasks" in self.model_fields_set:
            _dict['killedTasks'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CoreV1QueryExecutionStatusContext from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "errorMessage": obj.get("errorMessage"),
            "positionInQueue": obj.get("positionInQueue"),
            "totalTasks": obj.get("totalTasks"),
            "activeTasks": obj.get("activeTasks"),
            "completeTasks": obj.get("completeTasks"),
            "failedTasks": obj.get("failedTasks"),
            "killedTasks": obj.get("killedTasks")
        })
        return _obj


