# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.26
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dasl_api.models.core_v1_query_extend_request_date_range import CoreV1QueryExtendRequestDateRange
from typing import Optional, Set
from typing_extensions import Self

class CoreV1QueryExtendRequest(BaseModel):
    """
    An Extend request containing the updated start and end times for the query. 
    """ # noqa: E501
    warehouse: Optional[StrictStr] = Field(default=None, description="The SQL warehouse ID to use.")
    date_range: Optional[CoreV1QueryExtendRequestDateRange] = Field(alias="dateRange")
    __properties: ClassVar[List[str]] = ["warehouse", "dateRange"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CoreV1QueryExtendRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of date_range
        if self.date_range:
            _dict['dateRange'] = self.date_range.to_dict()
        # set to None if warehouse (nullable) is None
        # and model_fields_set contains the field
        if self.warehouse is None and "warehouse" in self.model_fields_set:
            _dict['warehouse'] = None

        # set to None if date_range (nullable) is None
        # and model_fields_set contains the field
        if self.date_range is None and "date_range" in self.model_fields_set:
            _dict['dateRange'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CoreV1QueryExtendRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "warehouse": obj.get("warehouse"),
            "dateRange": CoreV1QueryExtendRequestDateRange.from_dict(obj["dateRange"]) if obj.get("dateRange") is not None else None
        })
        return _obj


