# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.26
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from dasl_api.models.core_v1_query_lookup_request_pagination import CoreV1QueryLookupRequestPagination
from typing import Optional, Set
from typing_extensions import Self

class CoreV1QueryLookupRequest(BaseModel):
    """
    Request a subset of query data.
    """ # noqa: E501
    warehouse: Optional[StrictStr] = Field(default=None, description="The SQL warehouse ID to use for this request.")
    version: Optional[StrictInt] = Field(default=None, description="The specific version to the query to run a lookup against. Will target the latest version if not provided. ")
    start_value: Optional[StrictStr] = Field(default=None, description="An optional start value to constrain the data being returned. This will be applied to the primary ordering column before any refinements. Note, this is not compatible with pagination. ", alias="startValue")
    row_count: Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]] = Field(default=None, description="The number of rows to return, defaults to 1000 if not defined.", alias="rowCount")
    refinements: Optional[List[StrictStr]] = Field(default=None, description="A list of optional refinements to apply to the lookup.")
    pagination: Optional[CoreV1QueryLookupRequestPagination] = None
    __properties: ClassVar[List[str]] = ["warehouse", "version", "startValue", "rowCount", "refinements", "pagination"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CoreV1QueryLookupRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of pagination
        if self.pagination:
            _dict['pagination'] = self.pagination.to_dict()
        # set to None if warehouse (nullable) is None
        # and model_fields_set contains the field
        if self.warehouse is None and "warehouse" in self.model_fields_set:
            _dict['warehouse'] = None

        # set to None if version (nullable) is None
        # and model_fields_set contains the field
        if self.version is None and "version" in self.model_fields_set:
            _dict['version'] = None

        # set to None if start_value (nullable) is None
        # and model_fields_set contains the field
        if self.start_value is None and "start_value" in self.model_fields_set:
            _dict['startValue'] = None

        # set to None if row_count (nullable) is None
        # and model_fields_set contains the field
        if self.row_count is None and "row_count" in self.model_fields_set:
            _dict['rowCount'] = None

        # set to None if refinements (nullable) is None
        # and model_fields_set contains the field
        if self.refinements is None and "refinements" in self.model_fields_set:
            _dict['refinements'] = None

        # set to None if pagination (nullable) is None
        # and model_fields_set contains the field
        if self.pagination is None and "pagination" in self.model_fields_set:
            _dict['pagination'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CoreV1QueryLookupRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "warehouse": obj.get("warehouse"),
            "version": obj.get("version"),
            "startValue": obj.get("startValue"),
            "rowCount": obj.get("rowCount"),
            "refinements": obj.get("refinements"),
            "pagination": CoreV1QueryLookupRequestPagination.from_dict(obj["pagination"]) if obj.get("pagination") is not None else None
        })
        return _obj


