# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.26
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List
from typing import Optional, Set
from typing_extensions import Self

class CoreV1RenderedRuleTables(BaseModel):
    """
    This field contains the names of various temporary tables created just for this instance of the rendered rule. In particular, the notables and observable events tables are where such events must be found when validating results for a Rule. Note that it is up to the caller to delete these tables when no longer needed, and all tables must be deleted (not just the ones accessed by the user). 
    """ # noqa: E501
    notables: StrictStr = Field(description="The name of the temporary table where notables will be stored. ")
    observables: StrictStr = Field(description="The name of the temporary table where observables will be stored. ")
    operational_alerts: StrictStr = Field(description="The name of the temporary table where operational alerts will be stored. ", alias="operationalAlerts")
    data_metrics: StrictStr = Field(description="The name of the temporary table where data-related metrics will be stored. ", alias="dataMetrics")
    stream_metrics: StrictStr = Field(description="The name of the temporary table where stream-related metrics will be stored. ", alias="streamMetrics")
    observables_accumulation: StrictStr = Field(description="The name of the temporary table used internally for collating observables. ", alias="observablesAccumulation")
    __properties: ClassVar[List[str]] = ["notables", "observables", "operationalAlerts", "dataMetrics", "streamMetrics", "observablesAccumulation"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CoreV1RenderedRuleTables from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CoreV1RenderedRuleTables from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "notables": obj.get("notables"),
            "observables": obj.get("observables"),
            "operationalAlerts": obj.get("operationalAlerts"),
            "dataMetrics": obj.get("dataMetrics"),
            "streamMetrics": obj.get("streamMetrics"),
            "observablesAccumulation": obj.get("observablesAccumulation")
        })
        return _obj


