# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.26
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CoreV1RuleSpecOutput(BaseModel):
    """
    The information to record for each notable event identified by this rule. 
    """ # noqa: E501
    summary: Optional[StrictStr] = Field(default=None, description="The notable summary is the title of the notable. It can contain SQL expressions in braces that will be substituted, e.g. “Password reset for: {user_column}“. ")
    context: Optional[Dict[str, StrictStr]] = Field(default=None, description="The context is a map of key value pairs that can be used to record pertinent information from the input data record that resulted in the notable being generated. The value can contain SQL expressions in braces that will be substituted, e.g. “key\":\"{value_from column}“. Note, this field has no effect if `defaultContext` is set as true. ")
    default_context: Optional[StrictBool] = Field(default=None, description="An optional flag that can be set in place of populating the context field. If set, all data in the input row that triggered the notable will be recorded. Note, this flag takes precedence over the context field. If set, the context field will be ignored. ", alias="defaultContext")
    __properties: ClassVar[List[str]] = ["summary", "context", "defaultContext"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CoreV1RuleSpecOutput from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if summary (nullable) is None
        # and model_fields_set contains the field
        if self.summary is None and "summary" in self.model_fields_set:
            _dict['summary'] = None

        # set to None if context (nullable) is None
        # and model_fields_set contains the field
        if self.context is None and "context" in self.model_fields_set:
            _dict['context'] = None

        # set to None if default_context (nullable) is None
        # and model_fields_set contains the field
        if self.default_context is None and "default_context" in self.model_fields_set:
            _dict['defaultContext'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CoreV1RuleSpecOutput from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "summary": obj.get("summary"),
            "context": obj.get("context"),
            "defaultContext": obj.get("defaultContext")
        })
        return _obj


