# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.26
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CoreV1Schedule(BaseModel):
    """
    CoreV1Schedule
    """ # noqa: E501
    at_least_every: Optional[StrictStr] = Field(default=None, description="A duration string defining the schedule for data ingestion. The string may contain components for days, hours, minutes and seconds. Examples include '5d', '5d3h', '3d2h5m12s', and '12m16s'. ", alias="atLeastEvery")
    exactly: Optional[StrictStr] = Field(default=None, description="A quartz cron expression defining the schedule for data ingestion. ")
    continuous: Optional[StrictBool] = None
    compute_group: Optional[StrictStr] = Field(default=None, description="'dedicated', 'inherited', 'automatic' or a custom group name.", alias="computeGroup")
    enabled: Optional[StrictBool] = True
    __properties: ClassVar[List[str]] = ["atLeastEvery", "exactly", "continuous", "computeGroup", "enabled"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CoreV1Schedule from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if at_least_every (nullable) is None
        # and model_fields_set contains the field
        if self.at_least_every is None and "at_least_every" in self.model_fields_set:
            _dict['atLeastEvery'] = None

        # set to None if exactly (nullable) is None
        # and model_fields_set contains the field
        if self.exactly is None and "exactly" in self.model_fields_set:
            _dict['exactly'] = None

        # set to None if continuous (nullable) is None
        # and model_fields_set contains the field
        if self.continuous is None and "continuous" in self.model_fields_set:
            _dict['continuous'] = None

        # set to None if compute_group (nullable) is None
        # and model_fields_set contains the field
        if self.compute_group is None and "compute_group" in self.model_fields_set:
            _dict['computeGroup'] = None

        # set to None if enabled (nullable) is None
        # and model_fields_set contains the field
        if self.enabled is None and "enabled" in self.model_fields_set:
            _dict['enabled'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CoreV1Schedule from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "atLeastEvery": obj.get("atLeastEvery"),
            "exactly": obj.get("exactly"),
            "continuous": obj.get("continuous"),
            "computeGroup": obj.get("computeGroup"),
            "enabled": obj.get("enabled") if obj.get("enabled") is not None else True
        })
        return _obj


