# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.26
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dasl_api.models.dbui_v1_data_source_summary_list_data_sources_inner_alerts import DbuiV1DataSourceSummaryListDataSourcesInnerAlerts
from dasl_api.models.dbui_v1_data_source_summary_list_rollup_metrics import DbuiV1DataSourceSummaryListRollupMetrics
from typing import Optional, Set
from typing_extensions import Self

class DbuiV1DataSourceSummaryListDataSourcesInner(BaseModel):
    """
    DbuiV1DataSourceSummaryListDataSourcesInner
    """ # noqa: E501
    name: StrictStr
    source: StrictStr
    source_type: StrictStr = Field(alias="sourceType")
    description: StrictStr
    title: StrictStr
    author: StrictStr
    icon_url: StrictStr = Field(alias="iconURL")
    enabled: StrictBool
    alerts: Optional[DbuiV1DataSourceSummaryListDataSourcesInnerAlerts] = None
    metrics: Optional[DbuiV1DataSourceSummaryListRollupMetrics] = None
    __properties: ClassVar[List[str]] = ["name", "source", "sourceType", "description", "title", "author", "iconURL", "enabled", "alerts", "metrics"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DbuiV1DataSourceSummaryListDataSourcesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of alerts
        if self.alerts:
            _dict['alerts'] = self.alerts.to_dict()
        # override the default output from pydantic by calling `to_dict()` of metrics
        if self.metrics:
            _dict['metrics'] = self.metrics.to_dict()
        # set to None if alerts (nullable) is None
        # and model_fields_set contains the field
        if self.alerts is None and "alerts" in self.model_fields_set:
            _dict['alerts'] = None

        # set to None if metrics (nullable) is None
        # and model_fields_set contains the field
        if self.metrics is None and "metrics" in self.model_fields_set:
            _dict['metrics'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DbuiV1DataSourceSummaryListDataSourcesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "source": obj.get("source"),
            "sourceType": obj.get("sourceType"),
            "description": obj.get("description"),
            "title": obj.get("title"),
            "author": obj.get("author"),
            "iconURL": obj.get("iconURL"),
            "enabled": obj.get("enabled"),
            "alerts": DbuiV1DataSourceSummaryListDataSourcesInnerAlerts.from_dict(obj["alerts"]) if obj.get("alerts") is not None else None,
            "metrics": DbuiV1DataSourceSummaryListRollupMetrics.from_dict(obj["metrics"]) if obj.get("metrics") is not None else None
        })
        return _obj


