# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.26
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dasl_api.models.dbui_v1_observable_top10_list_items_inner_top10_inner import DbuiV1ObservableTop10ListItemsInnerTop10Inner
from typing import Optional, Set
from typing_extensions import Self

class DbuiV1ObservableTop10ListItemsInner(BaseModel):
    """
    DbuiV1ObservableTop10ListItemsInner
    """ # noqa: E501
    kind: Optional[StrictStr] = None
    top10: Optional[List[DbuiV1ObservableTop10ListItemsInnerTop10Inner]] = None
    __properties: ClassVar[List[str]] = ["kind", "top10"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DbuiV1ObservableTop10ListItemsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in top10 (list)
        _items = []
        if self.top10:
            for _item_top10 in self.top10:
                if _item_top10:
                    _items.append(_item_top10.to_dict())
            _dict['top10'] = _items
        # set to None if kind (nullable) is None
        # and model_fields_set contains the field
        if self.kind is None and "kind" in self.model_fields_set:
            _dict['kind'] = None

        # set to None if top10 (nullable) is None
        # and model_fields_set contains the field
        if self.top10 is None and "top10" in self.model_fields_set:
            _dict['top10'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DbuiV1ObservableTop10ListItemsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "kind": obj.get("kind"),
            "top10": [DbuiV1ObservableTop10ListItemsInnerTop10Inner.from_dict(_item) for _item in obj["top10"]] if obj.get("top10") is not None else None
        })
        return _obj


