# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.26
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dasl_api.models.dbui_v1_query_generate_request_time_range import DbuiV1QueryGenerateRequestTimeRange
from typing import Optional, Set
from typing_extensions import Self

class DbuiV1QueryGenerateRequest(BaseModel):
    """
    A Query request that includes the user-defined query to execute as well as an optional date range. The query will be executed and stored in a dedicated delta table that future queries can be executed against. 
    """ # noqa: E501
    warehouse: Optional[StrictStr] = Field(default=None, description="The SQL warehouse ID to use.")
    sql: StrictStr = Field(description="The SQL to execute. The results will be written to a temporary delta table so that it can be accessed in subsequent lookups. The SQL can include an optional date range placeholder function `inRange`. If a date range is provided, a range statement will be generated and replace all placeholders in this statement. An example use of the placeholder would be: `SELECT * FROM table WHERE inRange(time)`. ")
    time_range: Optional[DbuiV1QueryGenerateRequestTimeRange] = Field(default=None, alias="timeRange")
    __properties: ClassVar[List[str]] = ["warehouse", "sql", "timeRange"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DbuiV1QueryGenerateRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of time_range
        if self.time_range:
            _dict['timeRange'] = self.time_range.to_dict()
        # set to None if warehouse (nullable) is None
        # and model_fields_set contains the field
        if self.warehouse is None and "warehouse" in self.model_fields_set:
            _dict['warehouse'] = None

        # set to None if time_range (nullable) is None
        # and model_fields_set contains the field
        if self.time_range is None and "time_range" in self.model_fields_set:
            _dict['timeRange'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DbuiV1QueryGenerateRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "warehouse": obj.get("warehouse"),
            "sql": obj.get("sql"),
            "timeRange": DbuiV1QueryGenerateRequestTimeRange.from_dict(obj["timeRange"]) if obj.get("timeRange") is not None else None
        })
        return _obj


