# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.26
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class DbuiV1QueryHistogramRequest(BaseModel):
    """
    A request to generate a histogram over a time range with optional refinements. 
    """ # noqa: E501
    warehouse: Optional[StrictStr] = Field(default=None, description="The SQL warehouse ID to use. Will use the default warehouse if not provided. ")
    version: Optional[StrictInt] = Field(default=None, description="The specific version to the query to run a histogram against. Will target the latest version if not provided. ")
    start_date: StrictStr = Field(description="The start date for the histogram range. ", alias="startDate")
    end_date: Optional[StrictStr] = Field(default=None, description="An optional end date for the histogram range. Will default to now() if not provided. ", alias="endDate")
    interval: StrictStr = Field(description="The duration of each interval in the histogram. This must be an interval string in the format, eg: '1 day', '3 minutes 2 seconds', '2 weeks'. ")
    refinements: Optional[List[StrictStr]] = Field(default=None, description="A list of optional refinements to run on the results before generating the histogram. ")
    __properties: ClassVar[List[str]] = ["warehouse", "version", "startDate", "endDate", "interval", "refinements"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DbuiV1QueryHistogramRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if warehouse (nullable) is None
        # and model_fields_set contains the field
        if self.warehouse is None and "warehouse" in self.model_fields_set:
            _dict['warehouse'] = None

        # set to None if version (nullable) is None
        # and model_fields_set contains the field
        if self.version is None and "version" in self.model_fields_set:
            _dict['version'] = None

        # set to None if end_date (nullable) is None
        # and model_fields_set contains the field
        if self.end_date is None and "end_date" in self.model_fields_set:
            _dict['endDate'] = None

        # set to None if refinements (nullable) is None
        # and model_fields_set contains the field
        if self.refinements is None and "refinements" in self.model_fields_set:
            _dict['refinements'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DbuiV1QueryHistogramRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "warehouse": obj.get("warehouse"),
            "version": obj.get("version"),
            "startDate": obj.get("startDate"),
            "endDate": obj.get("endDate"),
            "interval": obj.get("interval"),
            "refinements": obj.get("refinements")
        })
        return _obj


