# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.26
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class DbuiV1QueryLookupRequestPagination(BaseModel):
    """
    A sequence of fields and and a direction that can be applied to a lookup request. If 'fetchPreceding' is true, the prior n rows up to the first row that matches the provided fields will be returned. Otherwise, the n rows following the first row that matches the provided fields will be returned. Note, this is not compatible with 'startValue'. 
    """ # noqa: E501
    fields: Dict[str, StrictStr] = Field(description="A set of constrains to apply to the query after including refinements and before collecting results. The fields in this constraint list can only include those listed in 'paginationColumns' from a previous lookup request. The order in which they are applied will match the order of pagination columns.")
    fetch_preceding: Optional[StrictBool] = Field(default=None, description="A flag indicating if the page to return should preceded the row identified by the fields. If not provided, it defaults to false and the page following the identified rows is returned instead. ", alias="fetchPreceding")
    __properties: ClassVar[List[str]] = ["fields", "fetchPreceding"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DbuiV1QueryLookupRequestPagination from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if fetch_preceding (nullable) is None
        # and model_fields_set contains the field
        if self.fetch_preceding is None and "fetch_preceding" in self.model_fields_set:
            _dict['fetchPreceding'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DbuiV1QueryLookupRequestPagination from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "fields": obj.get("fields"),
            "fetchPreceding": obj.get("fetchPreceding")
        })
        return _obj


