# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.26
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dasl_api.models.dbui_v1_transform_request_ingestion import DbuiV1TransformRequestIngestion
from dasl_api.models.dbui_v1_transform_request_transforms_inner import DbuiV1TransformRequestTransformsInner
from typing import Optional, Set
from typing_extensions import Self

class DbuiV1TransformRequest(BaseModel):
    """
    The transform request identifies the starting data (either with an autoloader spec or an input block) and then identifies a chain of transforms to be performed on the data. The return type includes the data at each intermediate stage (e.g. it returns the input or autoloaded data, and the pre-transform, and the silver) 
    """ # noqa: E501
    ingestion: Optional[DbuiV1TransformRequestIngestion] = None
    use_preset: Optional[StrictStr] = Field(default=None, description="indicates which preset to use for the transforms", alias="usePreset")
    use_preset_version: Optional[StrictInt] = Field(default=None, description="The version number of the preset to use. Defaults to latest if not provided.", alias="usePresetVersion")
    transforms: List[DbuiV1TransformRequestTransformsInner]
    __properties: ClassVar[List[str]] = ["ingestion", "usePreset", "usePresetVersion", "transforms"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DbuiV1TransformRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of ingestion
        if self.ingestion:
            _dict['ingestion'] = self.ingestion.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in transforms (list)
        _items = []
        if self.transforms:
            for _item_transforms in self.transforms:
                if _item_transforms:
                    _items.append(_item_transforms.to_dict())
            _dict['transforms'] = _items
        # set to None if ingestion (nullable) is None
        # and model_fields_set contains the field
        if self.ingestion is None and "ingestion" in self.model_fields_set:
            _dict['ingestion'] = None

        # set to None if use_preset (nullable) is None
        # and model_fields_set contains the field
        if self.use_preset is None and "use_preset" in self.model_fields_set:
            _dict['usePreset'] = None

        # set to None if use_preset_version (nullable) is None
        # and model_fields_set contains the field
        if self.use_preset_version is None and "use_preset_version" in self.model_fields_set:
            _dict['usePresetVersion'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DbuiV1TransformRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ingestion": DbuiV1TransformRequestIngestion.from_dict(obj["ingestion"]) if obj.get("ingestion") is not None else None,
            "usePreset": obj.get("usePreset"),
            "usePresetVersion": obj.get("usePresetVersion"),
            "transforms": [DbuiV1TransformRequestTransformsInner.from_dict(_item) for _item in obj["transforms"]] if obj.get("transforms") is not None else None
        })
        return _obj


