# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.26
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dasl_api.models.dbui_v1_transform_request_ingestion_additional_input_tables_inner import DbuiV1TransformRequestIngestionAdditionalInputTablesInner
from dasl_api.models.dbui_v1_transform_request_ingestion_autoloader_input import DbuiV1TransformRequestIngestionAutoloaderInput
from dasl_api.models.dbui_v1_transform_request_ingestion_input import DbuiV1TransformRequestIngestionInput
from typing import Optional, Set
from typing_extensions import Self

class DbuiV1TransformRequestIngestion(BaseModel):
    """
    Ingestion (bronze) layer configuration for acquiring and wrangling data before silver and gold transformations. This captures options analogous to bronze, autoloader, and related properties within a Datasource. 
    """ # noqa: E501
    input: Optional[DbuiV1TransformRequestIngestionInput] = None
    autoloader_input: Optional[DbuiV1TransformRequestIngestionAutoloaderInput] = Field(default=None, alias="autoloaderInput")
    load_as_single_variant: Optional[StrictBool] = Field(default=None, description="Whether to ingest the data as a single variant column called data (defaults to false if not provided). This disables all schema hints and type inference. Use the preTransform option to extract individual fields into typed columns before writing to the bronze table. Please note that the VARIANT type can only hold records up to 16 MB in size. For more details see: http://docs.databricks.com/aws/en/ingestion/variant#ingest-data-from-cloud-object-storage-as-variant This field is ignored if `input` is being used to supply the data. ", alias="loadAsSingleVariant")
    additional_input_tables: Optional[List[DbuiV1TransformRequestIngestionAdditionalInputTablesInner]] = Field(default=None, description="A list of existing tables that are joined with the input data just prior to the silver transformation. These tables are typically used for lookup or enrichment and are similar to `DatasourceSpec.silver.bronzeTables`, but without streaming-specific properties such as watermarking. Unlike `bronzeTables`, the listed tables are always joined to the input data, and the first item is not ignored. ", alias="additionalInputTables")
    pre_transform: Optional[List[List[StrictStr]]] = Field(default=None, description="A set of SQL expressions to apply before writing the Auto Loader data to bronze. This is analogous to `Datasource.bronze.preTransform` and uses `DatasourcePreset.bronze.preTransform` as a fallback when not specified. This option is only used when an `autoloader` configuration is specified and is ignore when `input` is used instead. Use this to unpack, unwrap or unroll data into individual rows. This is a nested array where each outer array item results in a separate selectExpr execution, allowing chained transformations across multiple passes. ", alias="preTransform")
    __properties: ClassVar[List[str]] = ["input", "autoloaderInput", "loadAsSingleVariant", "additionalInputTables", "preTransform"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DbuiV1TransformRequestIngestion from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of input
        if self.input:
            _dict['input'] = self.input.to_dict()
        # override the default output from pydantic by calling `to_dict()` of autoloader_input
        if self.autoloader_input:
            _dict['autoloaderInput'] = self.autoloader_input.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in additional_input_tables (list)
        _items = []
        if self.additional_input_tables:
            for _item_additional_input_tables in self.additional_input_tables:
                if _item_additional_input_tables:
                    _items.append(_item_additional_input_tables.to_dict())
            _dict['additionalInputTables'] = _items
        # set to None if input (nullable) is None
        # and model_fields_set contains the field
        if self.input is None and "input" in self.model_fields_set:
            _dict['input'] = None

        # set to None if autoloader_input (nullable) is None
        # and model_fields_set contains the field
        if self.autoloader_input is None and "autoloader_input" in self.model_fields_set:
            _dict['autoloaderInput'] = None

        # set to None if load_as_single_variant (nullable) is None
        # and model_fields_set contains the field
        if self.load_as_single_variant is None and "load_as_single_variant" in self.model_fields_set:
            _dict['loadAsSingleVariant'] = None

        # set to None if additional_input_tables (nullable) is None
        # and model_fields_set contains the field
        if self.additional_input_tables is None and "additional_input_tables" in self.model_fields_set:
            _dict['additionalInputTables'] = None

        # set to None if pre_transform (nullable) is None
        # and model_fields_set contains the field
        if self.pre_transform is None and "pre_transform" in self.model_fields_set:
            _dict['preTransform'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DbuiV1TransformRequestIngestion from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "input": DbuiV1TransformRequestIngestionInput.from_dict(obj["input"]) if obj.get("input") is not None else None,
            "autoloaderInput": DbuiV1TransformRequestIngestionAutoloaderInput.from_dict(obj["autoloaderInput"]) if obj.get("autoloaderInput") is not None else None,
            "loadAsSingleVariant": obj.get("loadAsSingleVariant"),
            "additionalInputTables": [DbuiV1TransformRequestIngestionAdditionalInputTablesInner.from_dict(_item) for _item in obj["additionalInputTables"]] if obj.get("additionalInputTables") is not None else None,
            "preTransform": obj.get("preTransform")
        })
        return _obj


