# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.26
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from dasl_api.models.core_v1_data_source_field_spec import CoreV1DataSourceFieldSpec
from dasl_api.models.core_v1_data_source_field_utils import CoreV1DataSourceFieldUtils
from dasl_api.models.dbui_v1_transform_request_transforms_inner_preset_overrides import DbuiV1TransformRequestTransformsInnerPresetOverrides
from typing import Optional, Set
from typing_extensions import Self

class DbuiV1TransformRequestTransformsInner(BaseModel):
    """
    DbuiV1TransformRequestTransformsInner
    """ # noqa: E501
    transform_type: StrictStr = Field(alias="transformType")
    use_preset_table: Optional[StrictStr] = Field(default=None, description="Indicates which table to use within the preset's transform type for Silver and Gold.", alias="usePresetTable")
    filter: Optional[StrictStr] = None
    post_filter: Optional[StrictStr] = Field(default=None, alias="postFilter")
    preset_overrides: Optional[DbuiV1TransformRequestTransformsInnerPresetOverrides] = Field(default=None, alias="presetOverrides")
    add_fields: Optional[List[Optional[CoreV1DataSourceFieldSpec]]] = Field(default=None, alias="addFields")
    utils: Optional[CoreV1DataSourceFieldUtils] = None
    __properties: ClassVar[List[str]] = ["transformType", "usePresetTable", "filter", "postFilter", "presetOverrides", "addFields", "utils"]

    @field_validator('transform_type')
    def transform_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['SilverPreTransform', 'SilverTransform', 'Gold']):
            raise ValueError("must be one of enum values ('SilverPreTransform', 'SilverTransform', 'Gold')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DbuiV1TransformRequestTransformsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of preset_overrides
        if self.preset_overrides:
            _dict['presetOverrides'] = self.preset_overrides.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in add_fields (list)
        _items = []
        if self.add_fields:
            for _item_add_fields in self.add_fields:
                if _item_add_fields:
                    _items.append(_item_add_fields.to_dict())
            _dict['addFields'] = _items
        # override the default output from pydantic by calling `to_dict()` of utils
        if self.utils:
            _dict['utils'] = self.utils.to_dict()
        # set to None if use_preset_table (nullable) is None
        # and model_fields_set contains the field
        if self.use_preset_table is None and "use_preset_table" in self.model_fields_set:
            _dict['usePresetTable'] = None

        # set to None if filter (nullable) is None
        # and model_fields_set contains the field
        if self.filter is None and "filter" in self.model_fields_set:
            _dict['filter'] = None

        # set to None if post_filter (nullable) is None
        # and model_fields_set contains the field
        if self.post_filter is None and "post_filter" in self.model_fields_set:
            _dict['postFilter'] = None

        # set to None if preset_overrides (nullable) is None
        # and model_fields_set contains the field
        if self.preset_overrides is None and "preset_overrides" in self.model_fields_set:
            _dict['presetOverrides'] = None

        # set to None if add_fields (nullable) is None
        # and model_fields_set contains the field
        if self.add_fields is None and "add_fields" in self.model_fields_set:
            _dict['addFields'] = None

        # set to None if utils (nullable) is None
        # and model_fields_set contains the field
        if self.utils is None and "utils" in self.model_fields_set:
            _dict['utils'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DbuiV1TransformRequestTransformsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "transformType": obj.get("transformType"),
            "usePresetTable": obj.get("usePresetTable"),
            "filter": obj.get("filter"),
            "postFilter": obj.get("postFilter"),
            "presetOverrides": DbuiV1TransformRequestTransformsInnerPresetOverrides.from_dict(obj["presetOverrides"]) if obj.get("presetOverrides") is not None else None,
            "addFields": [CoreV1DataSourceFieldSpec.from_dict(_item) for _item in obj["addFields"]] if obj.get("addFields") is not None else None,
            "utils": CoreV1DataSourceFieldUtils.from_dict(obj["utils"]) if obj.get("utils") is not None else None
        })
        return _obj


