# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.26
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class DbuiV1UpdateNotablesRequest(BaseModel):
    """
    DbuiV1UpdateNotablesRequest
    """ # noqa: E501
    ids: Optional[List[StrictStr]] = None
    assign_to: Optional[StrictStr] = Field(default=None, alias="assignTo")
    set_state: Optional[StrictStr] = Field(default=None, alias="setState")
    filter: Optional[StrictStr] = None
    before_date: Optional[datetime] = Field(default=None, alias="beforeDate")
    assignee: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["ids", "assignTo", "setState", "filter", "beforeDate", "assignee"]

    @field_validator('set_state')
    def set_state_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Open', 'Assigned', 'ClosedAsFalsePositive', 'ClosedAsBenignPositive', 'ClosedAsTruePositiveResolved', 'ClosedAsExported']):
            raise ValueError("must be one of enum values ('Open', 'Assigned', 'ClosedAsFalsePositive', 'ClosedAsBenignPositive', 'ClosedAsTruePositiveResolved', 'ClosedAsExported')")
        return value

    @field_validator('filter')
    def filter_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['all', 'open']):
            raise ValueError("must be one of enum values ('all', 'open')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DbuiV1UpdateNotablesRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if ids (nullable) is None
        # and model_fields_set contains the field
        if self.ids is None and "ids" in self.model_fields_set:
            _dict['ids'] = None

        # set to None if assign_to (nullable) is None
        # and model_fields_set contains the field
        if self.assign_to is None and "assign_to" in self.model_fields_set:
            _dict['assignTo'] = None

        # set to None if set_state (nullable) is None
        # and model_fields_set contains the field
        if self.set_state is None and "set_state" in self.model_fields_set:
            _dict['setState'] = None

        # set to None if filter (nullable) is None
        # and model_fields_set contains the field
        if self.filter is None and "filter" in self.model_fields_set:
            _dict['filter'] = None

        # set to None if before_date (nullable) is None
        # and model_fields_set contains the field
        if self.before_date is None and "before_date" in self.model_fields_set:
            _dict['beforeDate'] = None

        # set to None if assignee (nullable) is None
        # and model_fields_set contains the field
        if self.assignee is None and "assignee" in self.model_fields_set:
            _dict['assignee'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DbuiV1UpdateNotablesRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ids": obj.get("ids"),
            "assignTo": obj.get("assignTo"),
            "setState": obj.get("setState"),
            "filter": obj.get("filter"),
            "beforeDate": obj.get("beforeDate"),
            "assignee": obj.get("assignee")
        })
        return _obj


