# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.26
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List
from typing import Optional, Set
from typing_extensions import Self

class DbuiV1WarehouseItem(BaseModel):
    """
    DbuiV1WarehouseItem
    """ # noqa: E501
    id: StrictStr = Field(description="Unique identifier for warehouse.")
    name: StrictStr = Field(description="Logical name for the cluster.")
    cluster_size: StrictStr = Field(description="Size of the clusters allocated for this warehouse.")
    auto_stop_mins: StrictInt = Field(description="The amount of time in minutes that a SQL warehouse must be idle before it is automatically stopped.")
    state: StrictStr = Field(description="State of the warehouse.")
    __properties: ClassVar[List[str]] = ["id", "name", "cluster_size", "auto_stop_mins", "state"]

    @field_validator('state')
    def state_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['starting', 'running', 'stopping', 'stopped', 'deleting', 'deleted']):
            raise ValueError("must be one of enum values ('starting', 'running', 'stopping', 'stopped', 'deleting', 'deleted')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DbuiV1WarehouseItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DbuiV1WarehouseItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "cluster_size": obj.get("cluster_size"),
            "auto_stop_mins": obj.get("auto_stop_mins"),
            "state": obj.get("state")
        })
        return _obj


