# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.26
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dasl_api.models.workspace_v1_default_config_compute_group_overrides_value import WorkspaceV1DefaultConfigComputeGroupOverridesValue
from typing import Optional, Set
from typing_extensions import Self

class WorkspaceV1DefaultConfig(BaseModel):
    """
    Default configuration for a specific type 
    """ # noqa: E501
    notebook_location: Optional[StrictStr] = Field(default=None, description="A location for user created/edited/provided notebook.", alias="notebookLocation")
    bronze_schema: Optional[StrictStr] = Field(default=None, description="Name of the bronze schema in the catalog.", alias="bronzeSchema")
    silver_schema: Optional[StrictStr] = Field(default=None, description="Name of the silver schema in the catalog.", alias="silverSchema")
    gold_schema: Optional[StrictStr] = Field(default=None, description="Name of the gold schema in the catalog.", alias="goldSchema")
    catalog_name: Optional[StrictStr] = Field(default=None, description="The catalog name to use as the resource's default.", alias="catalogName")
    default_max_resources_per_job: Optional[StrictInt] = Field(default=None, alias="defaultMaxResourcesPerJob")
    checkpoint_location: Optional[StrictStr] = Field(default=None, description="The location to store checkpoints for streaming writes. If not provided, the daslStoragePath will be used.", alias="checkpointLocation")
    compute_group_overrides: Optional[Dict[str, WorkspaceV1DefaultConfigComputeGroupOverridesValue]] = Field(default=None, alias="computeGroupOverrides")
    __properties: ClassVar[List[str]] = ["notebookLocation", "bronzeSchema", "silverSchema", "goldSchema", "catalogName", "defaultMaxResourcesPerJob", "checkpointLocation", "computeGroupOverrides"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WorkspaceV1DefaultConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in compute_group_overrides (dict)
        _field_dict = {}
        if self.compute_group_overrides:
            for _key_compute_group_overrides in self.compute_group_overrides:
                if self.compute_group_overrides[_key_compute_group_overrides]:
                    _field_dict[_key_compute_group_overrides] = self.compute_group_overrides[_key_compute_group_overrides].to_dict()
            _dict['computeGroupOverrides'] = _field_dict
        # set to None if notebook_location (nullable) is None
        # and model_fields_set contains the field
        if self.notebook_location is None and "notebook_location" in self.model_fields_set:
            _dict['notebookLocation'] = None

        # set to None if bronze_schema (nullable) is None
        # and model_fields_set contains the field
        if self.bronze_schema is None and "bronze_schema" in self.model_fields_set:
            _dict['bronzeSchema'] = None

        # set to None if silver_schema (nullable) is None
        # and model_fields_set contains the field
        if self.silver_schema is None and "silver_schema" in self.model_fields_set:
            _dict['silverSchema'] = None

        # set to None if gold_schema (nullable) is None
        # and model_fields_set contains the field
        if self.gold_schema is None and "gold_schema" in self.model_fields_set:
            _dict['goldSchema'] = None

        # set to None if catalog_name (nullable) is None
        # and model_fields_set contains the field
        if self.catalog_name is None and "catalog_name" in self.model_fields_set:
            _dict['catalogName'] = None

        # set to None if default_max_resources_per_job (nullable) is None
        # and model_fields_set contains the field
        if self.default_max_resources_per_job is None and "default_max_resources_per_job" in self.model_fields_set:
            _dict['defaultMaxResourcesPerJob'] = None

        # set to None if checkpoint_location (nullable) is None
        # and model_fields_set contains the field
        if self.checkpoint_location is None and "checkpoint_location" in self.model_fields_set:
            _dict['checkpointLocation'] = None

        # set to None if compute_group_overrides (nullable) is None
        # and model_fields_set contains the field
        if self.compute_group_overrides is None and "compute_group_overrides" in self.model_fields_set:
            _dict['computeGroupOverrides'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WorkspaceV1DefaultConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "notebookLocation": obj.get("notebookLocation"),
            "bronzeSchema": obj.get("bronzeSchema"),
            "silverSchema": obj.get("silverSchema"),
            "goldSchema": obj.get("goldSchema"),
            "catalogName": obj.get("catalogName"),
            "defaultMaxResourcesPerJob": obj.get("defaultMaxResourcesPerJob"),
            "checkpointLocation": obj.get("checkpointLocation"),
            "computeGroupOverrides": dict(
                (_k, WorkspaceV1DefaultConfigComputeGroupOverridesValue.from_dict(_v))
                for _k, _v in obj["computeGroupOverrides"].items()
            )
            if obj.get("computeGroupOverrides") is not None
            else None
        })
        return _obj


