# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.26
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class WorkspaceV1WorkspaceConfigSpecRules(BaseModel):
    """
    Settings for rules
    """ # noqa: E501
    checkpoint_location: Optional[StrictStr] = Field(default=None, description="The location to store checkpoints for streaming writes. If not provided, the daslStoragePath will be used. ", alias="checkpointLocation")
    default_compute_mode: Optional[StrictStr] = Field(default='high', description="The default compute mode used by rule jobs. These are \"standard\" for STANDARD, and \"high\" for PERFORMANCE_OPTIMIZED mode. If not set, \"high\" is used as the default value. ", alias="defaultComputeMode")
    __properties: ClassVar[List[str]] = ["checkpointLocation", "defaultComputeMode"]

    @field_validator('default_compute_mode')
    def default_compute_mode_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['standard', 'high']):
            raise ValueError("must be one of enum values ('standard', 'high')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WorkspaceV1WorkspaceConfigSpecRules from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if checkpoint_location (nullable) is None
        # and model_fields_set contains the field
        if self.checkpoint_location is None and "checkpoint_location" in self.model_fields_set:
            _dict['checkpointLocation'] = None

        # set to None if default_compute_mode (nullable) is None
        # and model_fields_set contains the field
        if self.default_compute_mode is None and "default_compute_mode" in self.model_fields_set:
            _dict['defaultComputeMode'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WorkspaceV1WorkspaceConfigSpecRules from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "checkpointLocation": obj.get("checkpointLocation"),
            "defaultComputeMode": obj.get("defaultComputeMode") if obj.get("defaultComputeMode") is not None else 'high'
        })
        return _obj


