# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['BillingGroupArgs', 'BillingGroup']

@pulumi.input_type
class BillingGroupArgs:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 address_lines: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 billing_currency: Optional[pulumi.Input[_builtins.str]] = None,
                 billing_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 billing_extra_text: Optional[pulumi.Input[_builtins.str]] = None,
                 card_id: Optional[pulumi.Input[_builtins.str]] = None,
                 city: Optional[pulumi.Input[_builtins.str]] = None,
                 company: Optional[pulumi.Input[_builtins.str]] = None,
                 copy_from_billing_group: Optional[pulumi.Input[_builtins.str]] = None,
                 country_code: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 vat_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zip_code: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a BillingGroup resource.
        :param pulumi.Input[_builtins.str] account_id: Account ID.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] address_lines: Address lines 1 and 2. For example, street, PO box, or building.
        :param pulumi.Input[_builtins.str] billing_currency: Billing currency for the billing group. Supported currencies are: AUD, CAD, CHF, DKK, EUR, GBP, JPY, NOK, NZD, SEK, SGD, and USD.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] billing_emails: Email address of billing contacts. Invoices and other payment notifications are emailed to all billing contacts.
        :param pulumi.Input[_builtins.str] billing_extra_text: Additional information to include on your invoice (for example, a reference number).
        :param pulumi.Input[_builtins.str] card_id: Credit card ID.
        :param pulumi.Input[_builtins.str] city: City, district, suburb, town, or village.
        :param pulumi.Input[_builtins.str] company: Your company name.
        :param pulumi.Input[_builtins.str] copy_from_billing_group: ID of the billing group to copy the company name, address, currency, billing contacts, and extra text from.
        :param pulumi.Input[_builtins.str] country_code: Two-letter country code.
        :param pulumi.Input[_builtins.str] name: Name of the billing group.
        :param pulumi.Input[_builtins.str] parent_id: Link a billing group to an existing organization by using its ID. To set up proper dependencies please refer to this variable as a reference.
        :param pulumi.Input[_builtins.str] state: Address state.
        :param pulumi.Input[_builtins.str] vat_id: The VAT identification number for your company.
        :param pulumi.Input[_builtins.str] zip_code: Zip or postal code.
        """
        if account_id is not None:
            warnings.warn("""Use parent_id instead. This field will be removed in the next major release.""", DeprecationWarning)
            pulumi.log.warn("""account_id is deprecated: Use parent_id instead. This field will be removed in the next major release.""")
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if address_lines is not None:
            pulumi.set(__self__, "address_lines", address_lines)
        if billing_currency is not None:
            pulumi.set(__self__, "billing_currency", billing_currency)
        if billing_emails is not None:
            pulumi.set(__self__, "billing_emails", billing_emails)
        if billing_extra_text is not None:
            pulumi.set(__self__, "billing_extra_text", billing_extra_text)
        if card_id is not None:
            pulumi.set(__self__, "card_id", card_id)
        if city is not None:
            pulumi.set(__self__, "city", city)
        if company is not None:
            pulumi.set(__self__, "company", company)
        if copy_from_billing_group is not None:
            pulumi.set(__self__, "copy_from_billing_group", copy_from_billing_group)
        if country_code is not None:
            pulumi.set(__self__, "country_code", country_code)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent_id is not None:
            pulumi.set(__self__, "parent_id", parent_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if vat_id is not None:
            pulumi.set(__self__, "vat_id", vat_id)
        if zip_code is not None:
            pulumi.set(__self__, "zip_code", zip_code)

    @_builtins.property
    @pulumi.getter(name="accountId")
    @_utilities.deprecated("""Use parent_id instead. This field will be removed in the next major release.""")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Account ID.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="addressLines")
    def address_lines(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Address lines 1 and 2. For example, street, PO box, or building.
        """
        return pulumi.get(self, "address_lines")

    @address_lines.setter
    def address_lines(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "address_lines", value)

    @_builtins.property
    @pulumi.getter(name="billingCurrency")
    def billing_currency(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Billing currency for the billing group. Supported currencies are: AUD, CAD, CHF, DKK, EUR, GBP, JPY, NOK, NZD, SEK, SGD, and USD.
        """
        return pulumi.get(self, "billing_currency")

    @billing_currency.setter
    def billing_currency(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "billing_currency", value)

    @_builtins.property
    @pulumi.getter(name="billingEmails")
    def billing_emails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Email address of billing contacts. Invoices and other payment notifications are emailed to all billing contacts.
        """
        return pulumi.get(self, "billing_emails")

    @billing_emails.setter
    def billing_emails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "billing_emails", value)

    @_builtins.property
    @pulumi.getter(name="billingExtraText")
    def billing_extra_text(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Additional information to include on your invoice (for example, a reference number).
        """
        return pulumi.get(self, "billing_extra_text")

    @billing_extra_text.setter
    def billing_extra_text(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "billing_extra_text", value)

    @_builtins.property
    @pulumi.getter(name="cardId")
    def card_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Credit card ID.
        """
        return pulumi.get(self, "card_id")

    @card_id.setter
    def card_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "card_id", value)

    @_builtins.property
    @pulumi.getter
    def city(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        City, district, suburb, town, or village.
        """
        return pulumi.get(self, "city")

    @city.setter
    def city(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "city", value)

    @_builtins.property
    @pulumi.getter
    def company(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Your company name.
        """
        return pulumi.get(self, "company")

    @company.setter
    def company(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "company", value)

    @_builtins.property
    @pulumi.getter(name="copyFromBillingGroup")
    def copy_from_billing_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the billing group to copy the company name, address, currency, billing contacts, and extra text from.
        """
        return pulumi.get(self, "copy_from_billing_group")

    @copy_from_billing_group.setter
    def copy_from_billing_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "copy_from_billing_group", value)

    @_builtins.property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Two-letter country code.
        """
        return pulumi.get(self, "country_code")

    @country_code.setter
    def country_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "country_code", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the billing group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Link a billing group to an existing organization by using its ID. To set up proper dependencies please refer to this variable as a reference.
        """
        return pulumi.get(self, "parent_id")

    @parent_id.setter
    def parent_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_id", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Address state.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="vatId")
    def vat_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VAT identification number for your company.
        """
        return pulumi.get(self, "vat_id")

    @vat_id.setter
    def vat_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vat_id", value)

    @_builtins.property
    @pulumi.getter(name="zipCode")
    def zip_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Zip or postal code.
        """
        return pulumi.get(self, "zip_code")

    @zip_code.setter
    def zip_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zip_code", value)


@pulumi.input_type
class _BillingGroupState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 address_lines: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 billing_currency: Optional[pulumi.Input[_builtins.str]] = None,
                 billing_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 billing_extra_text: Optional[pulumi.Input[_builtins.str]] = None,
                 card_id: Optional[pulumi.Input[_builtins.str]] = None,
                 city: Optional[pulumi.Input[_builtins.str]] = None,
                 company: Optional[pulumi.Input[_builtins.str]] = None,
                 copy_from_billing_group: Optional[pulumi.Input[_builtins.str]] = None,
                 country_code: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 vat_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zip_code: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering BillingGroup resources.
        :param pulumi.Input[_builtins.str] account_id: Account ID.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] address_lines: Address lines 1 and 2. For example, street, PO box, or building.
        :param pulumi.Input[_builtins.str] billing_currency: Billing currency for the billing group. Supported currencies are: AUD, CAD, CHF, DKK, EUR, GBP, JPY, NOK, NZD, SEK, SGD, and USD.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] billing_emails: Email address of billing contacts. Invoices and other payment notifications are emailed to all billing contacts.
        :param pulumi.Input[_builtins.str] billing_extra_text: Additional information to include on your invoice (for example, a reference number).
        :param pulumi.Input[_builtins.str] card_id: Credit card ID.
        :param pulumi.Input[_builtins.str] city: City, district, suburb, town, or village.
        :param pulumi.Input[_builtins.str] company: Your company name.
        :param pulumi.Input[_builtins.str] copy_from_billing_group: ID of the billing group to copy the company name, address, currency, billing contacts, and extra text from.
        :param pulumi.Input[_builtins.str] country_code: Two-letter country code.
        :param pulumi.Input[_builtins.str] name: Name of the billing group.
        :param pulumi.Input[_builtins.str] parent_id: Link a billing group to an existing organization by using its ID. To set up proper dependencies please refer to this variable as a reference.
        :param pulumi.Input[_builtins.str] state: Address state.
        :param pulumi.Input[_builtins.str] vat_id: The VAT identification number for your company.
        :param pulumi.Input[_builtins.str] zip_code: Zip or postal code.
        """
        if account_id is not None:
            warnings.warn("""Use parent_id instead. This field will be removed in the next major release.""", DeprecationWarning)
            pulumi.log.warn("""account_id is deprecated: Use parent_id instead. This field will be removed in the next major release.""")
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if address_lines is not None:
            pulumi.set(__self__, "address_lines", address_lines)
        if billing_currency is not None:
            pulumi.set(__self__, "billing_currency", billing_currency)
        if billing_emails is not None:
            pulumi.set(__self__, "billing_emails", billing_emails)
        if billing_extra_text is not None:
            pulumi.set(__self__, "billing_extra_text", billing_extra_text)
        if card_id is not None:
            pulumi.set(__self__, "card_id", card_id)
        if city is not None:
            pulumi.set(__self__, "city", city)
        if company is not None:
            pulumi.set(__self__, "company", company)
        if copy_from_billing_group is not None:
            pulumi.set(__self__, "copy_from_billing_group", copy_from_billing_group)
        if country_code is not None:
            pulumi.set(__self__, "country_code", country_code)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent_id is not None:
            pulumi.set(__self__, "parent_id", parent_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if vat_id is not None:
            pulumi.set(__self__, "vat_id", vat_id)
        if zip_code is not None:
            pulumi.set(__self__, "zip_code", zip_code)

    @_builtins.property
    @pulumi.getter(name="accountId")
    @_utilities.deprecated("""Use parent_id instead. This field will be removed in the next major release.""")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Account ID.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="addressLines")
    def address_lines(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Address lines 1 and 2. For example, street, PO box, or building.
        """
        return pulumi.get(self, "address_lines")

    @address_lines.setter
    def address_lines(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "address_lines", value)

    @_builtins.property
    @pulumi.getter(name="billingCurrency")
    def billing_currency(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Billing currency for the billing group. Supported currencies are: AUD, CAD, CHF, DKK, EUR, GBP, JPY, NOK, NZD, SEK, SGD, and USD.
        """
        return pulumi.get(self, "billing_currency")

    @billing_currency.setter
    def billing_currency(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "billing_currency", value)

    @_builtins.property
    @pulumi.getter(name="billingEmails")
    def billing_emails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Email address of billing contacts. Invoices and other payment notifications are emailed to all billing contacts.
        """
        return pulumi.get(self, "billing_emails")

    @billing_emails.setter
    def billing_emails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "billing_emails", value)

    @_builtins.property
    @pulumi.getter(name="billingExtraText")
    def billing_extra_text(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Additional information to include on your invoice (for example, a reference number).
        """
        return pulumi.get(self, "billing_extra_text")

    @billing_extra_text.setter
    def billing_extra_text(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "billing_extra_text", value)

    @_builtins.property
    @pulumi.getter(name="cardId")
    def card_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Credit card ID.
        """
        return pulumi.get(self, "card_id")

    @card_id.setter
    def card_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "card_id", value)

    @_builtins.property
    @pulumi.getter
    def city(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        City, district, suburb, town, or village.
        """
        return pulumi.get(self, "city")

    @city.setter
    def city(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "city", value)

    @_builtins.property
    @pulumi.getter
    def company(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Your company name.
        """
        return pulumi.get(self, "company")

    @company.setter
    def company(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "company", value)

    @_builtins.property
    @pulumi.getter(name="copyFromBillingGroup")
    def copy_from_billing_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the billing group to copy the company name, address, currency, billing contacts, and extra text from.
        """
        return pulumi.get(self, "copy_from_billing_group")

    @copy_from_billing_group.setter
    def copy_from_billing_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "copy_from_billing_group", value)

    @_builtins.property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Two-letter country code.
        """
        return pulumi.get(self, "country_code")

    @country_code.setter
    def country_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "country_code", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the billing group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Link a billing group to an existing organization by using its ID. To set up proper dependencies please refer to this variable as a reference.
        """
        return pulumi.get(self, "parent_id")

    @parent_id.setter
    def parent_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_id", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Address state.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="vatId")
    def vat_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VAT identification number for your company.
        """
        return pulumi.get(self, "vat_id")

    @vat_id.setter
    def vat_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vat_id", value)

    @_builtins.property
    @pulumi.getter(name="zipCode")
    def zip_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Zip or postal code.
        """
        return pulumi.get(self, "zip_code")

    @zip_code.setter
    def zip_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zip_code", value)


@pulumi.type_token("aiven:index/billingGroup:BillingGroup")
class BillingGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 address_lines: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 billing_currency: Optional[pulumi.Input[_builtins.str]] = None,
                 billing_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 billing_extra_text: Optional[pulumi.Input[_builtins.str]] = None,
                 card_id: Optional[pulumi.Input[_builtins.str]] = None,
                 city: Optional[pulumi.Input[_builtins.str]] = None,
                 company: Optional[pulumi.Input[_builtins.str]] = None,
                 copy_from_billing_group: Optional[pulumi.Input[_builtins.str]] = None,
                 country_code: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 vat_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zip_code: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages [billing groups](https://aiven.io/docs/platform/concepts/billing-groups) and assigns them to projects.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        example_billing_group = aiven.BillingGroup("example_billing_group",
            name="example-billing-group",
            billing_currency="USD",
            vat_id="123ABC",
            parent_id=main["id"])
        example_project = aiven.Project("example_project",
            project="example-project",
            billing_group=example_billing_group.id)
        ```

        ## Import

        ```sh
        $ pulumi import aiven:index/billingGroup:BillingGroup example_billing_group ID
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Account ID.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] address_lines: Address lines 1 and 2. For example, street, PO box, or building.
        :param pulumi.Input[_builtins.str] billing_currency: Billing currency for the billing group. Supported currencies are: AUD, CAD, CHF, DKK, EUR, GBP, JPY, NOK, NZD, SEK, SGD, and USD.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] billing_emails: Email address of billing contacts. Invoices and other payment notifications are emailed to all billing contacts.
        :param pulumi.Input[_builtins.str] billing_extra_text: Additional information to include on your invoice (for example, a reference number).
        :param pulumi.Input[_builtins.str] card_id: Credit card ID.
        :param pulumi.Input[_builtins.str] city: City, district, suburb, town, or village.
        :param pulumi.Input[_builtins.str] company: Your company name.
        :param pulumi.Input[_builtins.str] copy_from_billing_group: ID of the billing group to copy the company name, address, currency, billing contacts, and extra text from.
        :param pulumi.Input[_builtins.str] country_code: Two-letter country code.
        :param pulumi.Input[_builtins.str] name: Name of the billing group.
        :param pulumi.Input[_builtins.str] parent_id: Link a billing group to an existing organization by using its ID. To set up proper dependencies please refer to this variable as a reference.
        :param pulumi.Input[_builtins.str] state: Address state.
        :param pulumi.Input[_builtins.str] vat_id: The VAT identification number for your company.
        :param pulumi.Input[_builtins.str] zip_code: Zip or postal code.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[BillingGroupArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages [billing groups](https://aiven.io/docs/platform/concepts/billing-groups) and assigns them to projects.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        example_billing_group = aiven.BillingGroup("example_billing_group",
            name="example-billing-group",
            billing_currency="USD",
            vat_id="123ABC",
            parent_id=main["id"])
        example_project = aiven.Project("example_project",
            project="example-project",
            billing_group=example_billing_group.id)
        ```

        ## Import

        ```sh
        $ pulumi import aiven:index/billingGroup:BillingGroup example_billing_group ID
        ```

        :param str resource_name: The name of the resource.
        :param BillingGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BillingGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 address_lines: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 billing_currency: Optional[pulumi.Input[_builtins.str]] = None,
                 billing_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 billing_extra_text: Optional[pulumi.Input[_builtins.str]] = None,
                 card_id: Optional[pulumi.Input[_builtins.str]] = None,
                 city: Optional[pulumi.Input[_builtins.str]] = None,
                 company: Optional[pulumi.Input[_builtins.str]] = None,
                 copy_from_billing_group: Optional[pulumi.Input[_builtins.str]] = None,
                 country_code: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 vat_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zip_code: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BillingGroupArgs.__new__(BillingGroupArgs)

            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["address_lines"] = address_lines
            __props__.__dict__["billing_currency"] = billing_currency
            __props__.__dict__["billing_emails"] = billing_emails
            __props__.__dict__["billing_extra_text"] = billing_extra_text
            __props__.__dict__["card_id"] = card_id
            __props__.__dict__["city"] = city
            __props__.__dict__["company"] = company
            __props__.__dict__["copy_from_billing_group"] = copy_from_billing_group
            __props__.__dict__["country_code"] = country_code
            __props__.__dict__["name"] = name
            __props__.__dict__["parent_id"] = parent_id
            __props__.__dict__["state"] = state
            __props__.__dict__["vat_id"] = vat_id
            __props__.__dict__["zip_code"] = zip_code
        super(BillingGroup, __self__).__init__(
            'aiven:index/billingGroup:BillingGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            address_lines: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            billing_currency: Optional[pulumi.Input[_builtins.str]] = None,
            billing_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            billing_extra_text: Optional[pulumi.Input[_builtins.str]] = None,
            card_id: Optional[pulumi.Input[_builtins.str]] = None,
            city: Optional[pulumi.Input[_builtins.str]] = None,
            company: Optional[pulumi.Input[_builtins.str]] = None,
            copy_from_billing_group: Optional[pulumi.Input[_builtins.str]] = None,
            country_code: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            parent_id: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            vat_id: Optional[pulumi.Input[_builtins.str]] = None,
            zip_code: Optional[pulumi.Input[_builtins.str]] = None) -> 'BillingGroup':
        """
        Get an existing BillingGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Account ID.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] address_lines: Address lines 1 and 2. For example, street, PO box, or building.
        :param pulumi.Input[_builtins.str] billing_currency: Billing currency for the billing group. Supported currencies are: AUD, CAD, CHF, DKK, EUR, GBP, JPY, NOK, NZD, SEK, SGD, and USD.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] billing_emails: Email address of billing contacts. Invoices and other payment notifications are emailed to all billing contacts.
        :param pulumi.Input[_builtins.str] billing_extra_text: Additional information to include on your invoice (for example, a reference number).
        :param pulumi.Input[_builtins.str] card_id: Credit card ID.
        :param pulumi.Input[_builtins.str] city: City, district, suburb, town, or village.
        :param pulumi.Input[_builtins.str] company: Your company name.
        :param pulumi.Input[_builtins.str] copy_from_billing_group: ID of the billing group to copy the company name, address, currency, billing contacts, and extra text from.
        :param pulumi.Input[_builtins.str] country_code: Two-letter country code.
        :param pulumi.Input[_builtins.str] name: Name of the billing group.
        :param pulumi.Input[_builtins.str] parent_id: Link a billing group to an existing organization by using its ID. To set up proper dependencies please refer to this variable as a reference.
        :param pulumi.Input[_builtins.str] state: Address state.
        :param pulumi.Input[_builtins.str] vat_id: The VAT identification number for your company.
        :param pulumi.Input[_builtins.str] zip_code: Zip or postal code.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BillingGroupState.__new__(_BillingGroupState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["address_lines"] = address_lines
        __props__.__dict__["billing_currency"] = billing_currency
        __props__.__dict__["billing_emails"] = billing_emails
        __props__.__dict__["billing_extra_text"] = billing_extra_text
        __props__.__dict__["card_id"] = card_id
        __props__.__dict__["city"] = city
        __props__.__dict__["company"] = company
        __props__.__dict__["copy_from_billing_group"] = copy_from_billing_group
        __props__.__dict__["country_code"] = country_code
        __props__.__dict__["name"] = name
        __props__.__dict__["parent_id"] = parent_id
        __props__.__dict__["state"] = state
        __props__.__dict__["vat_id"] = vat_id
        __props__.__dict__["zip_code"] = zip_code
        return BillingGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    @_utilities.deprecated("""Use parent_id instead. This field will be removed in the next major release.""")
    def account_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Account ID.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="addressLines")
    def address_lines(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Address lines 1 and 2. For example, street, PO box, or building.
        """
        return pulumi.get(self, "address_lines")

    @_builtins.property
    @pulumi.getter(name="billingCurrency")
    def billing_currency(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Billing currency for the billing group. Supported currencies are: AUD, CAD, CHF, DKK, EUR, GBP, JPY, NOK, NZD, SEK, SGD, and USD.
        """
        return pulumi.get(self, "billing_currency")

    @_builtins.property
    @pulumi.getter(name="billingEmails")
    def billing_emails(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Email address of billing contacts. Invoices and other payment notifications are emailed to all billing contacts.
        """
        return pulumi.get(self, "billing_emails")

    @_builtins.property
    @pulumi.getter(name="billingExtraText")
    def billing_extra_text(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Additional information to include on your invoice (for example, a reference number).
        """
        return pulumi.get(self, "billing_extra_text")

    @_builtins.property
    @pulumi.getter(name="cardId")
    def card_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Credit card ID.
        """
        return pulumi.get(self, "card_id")

    @_builtins.property
    @pulumi.getter
    def city(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        City, district, suburb, town, or village.
        """
        return pulumi.get(self, "city")

    @_builtins.property
    @pulumi.getter
    def company(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Your company name.
        """
        return pulumi.get(self, "company")

    @_builtins.property
    @pulumi.getter(name="copyFromBillingGroup")
    def copy_from_billing_group(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ID of the billing group to copy the company name, address, currency, billing contacts, and extra text from.
        """
        return pulumi.get(self, "copy_from_billing_group")

    @_builtins.property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Two-letter country code.
        """
        return pulumi.get(self, "country_code")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the billing group.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Link a billing group to an existing organization by using its ID. To set up proper dependencies please refer to this variable as a reference.
        """
        return pulumi.get(self, "parent_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Address state.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="vatId")
    def vat_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The VAT identification number for your company.
        """
        return pulumi.get(self, "vat_id")

    @_builtins.property
    @pulumi.getter(name="zipCode")
    def zip_code(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Zip or postal code.
        """
        return pulumi.get(self, "zip_code")

