# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetAlloydbomniDatabaseResult',
    'AwaitableGetAlloydbomniDatabaseResult',
    'get_alloydbomni_database',
    'get_alloydbomni_database_output',
]

@pulumi.output_type
class GetAlloydbomniDatabaseResult:
    """
    A collection of values returned by getAlloydbomniDatabase.
    """
    def __init__(__self__, database_name=None, id=None, lc_collate=None, lc_ctype=None, project=None, service_name=None):
        if database_name and not isinstance(database_name, str):
            raise TypeError("Expected argument 'database_name' to be a str")
        pulumi.set(__self__, "database_name", database_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lc_collate and not isinstance(lc_collate, str):
            raise TypeError("Expected argument 'lc_collate' to be a str")
        pulumi.set(__self__, "lc_collate", lc_collate)
        if lc_ctype and not isinstance(lc_ctype, str):
            raise TypeError("Expected argument 'lc_ctype' to be a str")
        pulumi.set(__self__, "lc_ctype", lc_ctype)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> _builtins.str:
        """
        The name of the service database. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "database_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lcCollate")
    def lc_collate(self) -> _builtins.str:
        """
        Default string sort order (`LC_COLLATE`) of the database. The default value is `en_US.UTF-8`. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "lc_collate")

    @_builtins.property
    @pulumi.getter(name="lcCtype")
    def lc_ctype(self) -> _builtins.str:
        """
        Default character classification (`LC_CTYPE`) of the database. The default value is `en_US.UTF-8`. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "lc_ctype")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        """
        The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> _builtins.str:
        """
        The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")


class AwaitableGetAlloydbomniDatabaseResult(GetAlloydbomniDatabaseResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAlloydbomniDatabaseResult(
            database_name=self.database_name,
            id=self.id,
            lc_collate=self.lc_collate,
            lc_ctype=self.lc_ctype,
            project=self.project,
            service_name=self.service_name)


def get_alloydbomni_database(database_name: Optional[_builtins.str] = None,
                             project: Optional[_builtins.str] = None,
                             service_name: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAlloydbomniDatabaseResult:
    """
    Gets information about a database in an Aiven for AlloyDB Omni service.

    **This resource is in the beta stage and may change without notice.** Set
    the `PROVIDER_AIVEN_ENABLE_BETA` environment variable to use the resource.

    !> **End of life notice**
    Aiven for AlloyDB Omni is entering its [end-of-life cycle](https://aiven.io/docs/platform/reference/end-of-life).
    From **5 September 2025**, you can no longer create new Aiven for AlloyDB Omni services. Existing
    services continue to operate until the end of life (EOL) date but you cannot change plans for these services.
    On **5 December 2025**, all active Aiven for AlloyDB Omni services are powered off and deleted, making data from
    these services inaccessible. The recommended alternatives to Aiven for AlloyDB Omni are:
    Aiven for PostgreSQL®,
    Aiven for ClickHouse®,
    and Aiven for MySQL®.
    To ensure uninterrupted service, complete your migration before December 5, 2025.
    For further assistance, contact the Aiven support team or your
    account team.


    :param _builtins.str database_name: The name of the service database. Changing this property forces recreation of the resource.
    :param _builtins.str project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    :param _builtins.str service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    """
    __args__ = dict()
    __args__['databaseName'] = database_name
    __args__['project'] = project
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aiven:index/getAlloydbomniDatabase:getAlloydbomniDatabase', __args__, opts=opts, typ=GetAlloydbomniDatabaseResult).value

    return AwaitableGetAlloydbomniDatabaseResult(
        database_name=pulumi.get(__ret__, 'database_name'),
        id=pulumi.get(__ret__, 'id'),
        lc_collate=pulumi.get(__ret__, 'lc_collate'),
        lc_ctype=pulumi.get(__ret__, 'lc_ctype'),
        project=pulumi.get(__ret__, 'project'),
        service_name=pulumi.get(__ret__, 'service_name'))
def get_alloydbomni_database_output(database_name: Optional[pulumi.Input[_builtins.str]] = None,
                                    project: Optional[pulumi.Input[_builtins.str]] = None,
                                    service_name: Optional[pulumi.Input[_builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAlloydbomniDatabaseResult]:
    """
    Gets information about a database in an Aiven for AlloyDB Omni service.

    **This resource is in the beta stage and may change without notice.** Set
    the `PROVIDER_AIVEN_ENABLE_BETA` environment variable to use the resource.

    !> **End of life notice**
    Aiven for AlloyDB Omni is entering its [end-of-life cycle](https://aiven.io/docs/platform/reference/end-of-life).
    From **5 September 2025**, you can no longer create new Aiven for AlloyDB Omni services. Existing
    services continue to operate until the end of life (EOL) date but you cannot change plans for these services.
    On **5 December 2025**, all active Aiven for AlloyDB Omni services are powered off and deleted, making data from
    these services inaccessible. The recommended alternatives to Aiven for AlloyDB Omni are:
    Aiven for PostgreSQL®,
    Aiven for ClickHouse®,
    and Aiven for MySQL®.
    To ensure uninterrupted service, complete your migration before December 5, 2025.
    For further assistance, contact the Aiven support team or your
    account team.


    :param _builtins.str database_name: The name of the service database. Changing this property forces recreation of the resource.
    :param _builtins.str project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    :param _builtins.str service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    """
    __args__ = dict()
    __args__['databaseName'] = database_name
    __args__['project'] = project
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aiven:index/getAlloydbomniDatabase:getAlloydbomniDatabase', __args__, opts=opts, typ=GetAlloydbomniDatabaseResult)
    return __ret__.apply(lambda __response__: GetAlloydbomniDatabaseResult(
        database_name=pulumi.get(__response__, 'database_name'),
        id=pulumi.get(__response__, 'id'),
        lc_collate=pulumi.get(__response__, 'lc_collate'),
        lc_ctype=pulumi.get(__response__, 'lc_ctype'),
        project=pulumi.get(__response__, 'project'),
        service_name=pulumi.get(__response__, 'service_name')))
