# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetOpenSearchResult',
    'AwaitableGetOpenSearchResult',
    'get_open_search',
    'get_open_search_output',
]

@pulumi.output_type
class GetOpenSearchResult:
    """
    A collection of values returned by getOpenSearch.
    """
    def __init__(__self__, additional_disk_space=None, cloud_name=None, components=None, disk_space=None, disk_space_cap=None, disk_space_default=None, disk_space_step=None, disk_space_used=None, id=None, maintenance_window_dow=None, maintenance_window_enabled=None, maintenance_window_time=None, opensearch_user_configs=None, opensearches=None, plan=None, project=None, project_vpc_id=None, service_host=None, service_integrations=None, service_name=None, service_password=None, service_port=None, service_type=None, service_uri=None, service_username=None, state=None, static_ips=None, tags=None, tech_emails=None, termination_protection=None):
        if additional_disk_space and not isinstance(additional_disk_space, str):
            raise TypeError("Expected argument 'additional_disk_space' to be a str")
        pulumi.set(__self__, "additional_disk_space", additional_disk_space)
        if cloud_name and not isinstance(cloud_name, str):
            raise TypeError("Expected argument 'cloud_name' to be a str")
        pulumi.set(__self__, "cloud_name", cloud_name)
        if components and not isinstance(components, list):
            raise TypeError("Expected argument 'components' to be a list")
        pulumi.set(__self__, "components", components)
        if disk_space and not isinstance(disk_space, str):
            raise TypeError("Expected argument 'disk_space' to be a str")
        pulumi.set(__self__, "disk_space", disk_space)
        if disk_space_cap and not isinstance(disk_space_cap, str):
            raise TypeError("Expected argument 'disk_space_cap' to be a str")
        pulumi.set(__self__, "disk_space_cap", disk_space_cap)
        if disk_space_default and not isinstance(disk_space_default, str):
            raise TypeError("Expected argument 'disk_space_default' to be a str")
        pulumi.set(__self__, "disk_space_default", disk_space_default)
        if disk_space_step and not isinstance(disk_space_step, str):
            raise TypeError("Expected argument 'disk_space_step' to be a str")
        pulumi.set(__self__, "disk_space_step", disk_space_step)
        if disk_space_used and not isinstance(disk_space_used, str):
            raise TypeError("Expected argument 'disk_space_used' to be a str")
        pulumi.set(__self__, "disk_space_used", disk_space_used)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if maintenance_window_dow and not isinstance(maintenance_window_dow, str):
            raise TypeError("Expected argument 'maintenance_window_dow' to be a str")
        pulumi.set(__self__, "maintenance_window_dow", maintenance_window_dow)
        if maintenance_window_enabled and not isinstance(maintenance_window_enabled, bool):
            raise TypeError("Expected argument 'maintenance_window_enabled' to be a bool")
        pulumi.set(__self__, "maintenance_window_enabled", maintenance_window_enabled)
        if maintenance_window_time and not isinstance(maintenance_window_time, str):
            raise TypeError("Expected argument 'maintenance_window_time' to be a str")
        pulumi.set(__self__, "maintenance_window_time", maintenance_window_time)
        if opensearch_user_configs and not isinstance(opensearch_user_configs, list):
            raise TypeError("Expected argument 'opensearch_user_configs' to be a list")
        pulumi.set(__self__, "opensearch_user_configs", opensearch_user_configs)
        if opensearches and not isinstance(opensearches, list):
            raise TypeError("Expected argument 'opensearches' to be a list")
        pulumi.set(__self__, "opensearches", opensearches)
        if plan and not isinstance(plan, str):
            raise TypeError("Expected argument 'plan' to be a str")
        pulumi.set(__self__, "plan", plan)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if project_vpc_id and not isinstance(project_vpc_id, str):
            raise TypeError("Expected argument 'project_vpc_id' to be a str")
        pulumi.set(__self__, "project_vpc_id", project_vpc_id)
        if service_host and not isinstance(service_host, str):
            raise TypeError("Expected argument 'service_host' to be a str")
        pulumi.set(__self__, "service_host", service_host)
        if service_integrations and not isinstance(service_integrations, list):
            raise TypeError("Expected argument 'service_integrations' to be a list")
        pulumi.set(__self__, "service_integrations", service_integrations)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if service_password and not isinstance(service_password, str):
            raise TypeError("Expected argument 'service_password' to be a str")
        pulumi.set(__self__, "service_password", service_password)
        if service_port and not isinstance(service_port, int):
            raise TypeError("Expected argument 'service_port' to be a int")
        pulumi.set(__self__, "service_port", service_port)
        if service_type and not isinstance(service_type, str):
            raise TypeError("Expected argument 'service_type' to be a str")
        pulumi.set(__self__, "service_type", service_type)
        if service_uri and not isinstance(service_uri, str):
            raise TypeError("Expected argument 'service_uri' to be a str")
        pulumi.set(__self__, "service_uri", service_uri)
        if service_username and not isinstance(service_username, str):
            raise TypeError("Expected argument 'service_username' to be a str")
        pulumi.set(__self__, "service_username", service_username)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if static_ips and not isinstance(static_ips, list):
            raise TypeError("Expected argument 'static_ips' to be a list")
        pulumi.set(__self__, "static_ips", static_ips)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if tech_emails and not isinstance(tech_emails, list):
            raise TypeError("Expected argument 'tech_emails' to be a list")
        pulumi.set(__self__, "tech_emails", tech_emails)
        if termination_protection and not isinstance(termination_protection, bool):
            raise TypeError("Expected argument 'termination_protection' to be a bool")
        pulumi.set(__self__, "termination_protection", termination_protection)

    @_builtins.property
    @pulumi.getter(name="additionalDiskSpace")
    def additional_disk_space(self) -> _builtins.str:
        """
        Add [disk storage](https://aiven.io/docs/platform/howto/add-storage-space) in increments of 30  GiB to scale your service. The maximum value depends on the service type and cloud provider. Removing additional storage causes the service nodes to go through a rolling restart, and there might be a short downtime for services without an autoscaler integration or high availability capabilities. The field can be safely removed when autoscaler is enabled without causing any changes.
        """
        return pulumi.get(self, "additional_disk_space")

    @_builtins.property
    @pulumi.getter(name="cloudName")
    def cloud_name(self) -> _builtins.str:
        """
        The cloud provider and region the service is hosted in. The format is `provider-region`, for example: `google-europe-west1`. The [available cloud regions](https://aiven.io/docs/platform/reference/list_of_clouds) can differ per project and service. Changing this value [migrates the service to another cloud provider or region](https://aiven.io/docs/platform/howto/migrate-services-cloud-region). The migration runs in the background and includes a DNS update to redirect traffic to the new region. Most services experience no downtime, but some databases may have a brief interruption during DNS propagation.
        """
        return pulumi.get(self, "cloud_name")

    @_builtins.property
    @pulumi.getter
    def components(self) -> Sequence['outputs.GetOpenSearchComponentResult']:
        """
        Service component information objects
        """
        return pulumi.get(self, "components")

    @_builtins.property
    @pulumi.getter(name="diskSpace")
    def disk_space(self) -> _builtins.str:
        """
        Service disk space. Possible values depend on the service type, the cloud provider and the project. Therefore, reducing will result in the service rebalancing. Please use `additional_disk_space` to specify the space to be added to the default disk space defined by the plan.
        """
        return pulumi.get(self, "disk_space")

    @_builtins.property
    @pulumi.getter(name="diskSpaceCap")
    def disk_space_cap(self) -> _builtins.str:
        """
        The maximum disk space of the service, possible values depend on the service type, the cloud provider and the project.
        """
        return pulumi.get(self, "disk_space_cap")

    @_builtins.property
    @pulumi.getter(name="diskSpaceDefault")
    def disk_space_default(self) -> _builtins.str:
        """
        The default disk space of the service, possible values depend on the service type, the cloud provider and the project. Its also the minimum value for `disk_space`
        """
        return pulumi.get(self, "disk_space_default")

    @_builtins.property
    @pulumi.getter(name="diskSpaceStep")
    def disk_space_step(self) -> _builtins.str:
        """
        The default disk space step of the service, possible values depend on the service type, the cloud provider and the project. `disk_space` needs to increment from `disk_space_default` by increments of this size.
        """
        return pulumi.get(self, "disk_space_step")

    @_builtins.property
    @pulumi.getter(name="diskSpaceUsed")
    def disk_space_used(self) -> _builtins.str:
        """
        The disk space that the service is currently using. This is the sum of `disk_space` and `additional_disk_space` in human-readable format (for example: `90GiB`).
        """
        return pulumi.get(self, "disk_space_used")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="maintenanceWindowDow")
    def maintenance_window_dow(self) -> _builtins.str:
        """
        Day of week when maintenance operations should be performed. One monday, tuesday, wednesday, etc.
        """
        return pulumi.get(self, "maintenance_window_dow")

    @_builtins.property
    @pulumi.getter(name="maintenanceWindowEnabled")
    def maintenance_window_enabled(self) -> _builtins.bool:
        """
        Indicates whether the maintenance window is currently enabled for this service.
        """
        return pulumi.get(self, "maintenance_window_enabled")

    @_builtins.property
    @pulumi.getter(name="maintenanceWindowTime")
    def maintenance_window_time(self) -> _builtins.str:
        """
        Time of day when maintenance operations should be performed. UTC time in HH:mm:ss format.
        """
        return pulumi.get(self, "maintenance_window_time")

    @_builtins.property
    @pulumi.getter(name="opensearchUserConfigs")
    def opensearch_user_configs(self) -> Sequence['outputs.GetOpenSearchOpensearchUserConfigResult']:
        """
        Opensearch user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "opensearch_user_configs")

    @_builtins.property
    @pulumi.getter
    def opensearches(self) -> Sequence['outputs.GetOpenSearchOpensearchResult']:
        """
        Values provided by the OpenSearch server.
        """
        return pulumi.get(self, "opensearches")

    @_builtins.property
    @pulumi.getter
    def plan(self) -> _builtins.str:
        """
        Defines what kind of computing resources are allocated for the service. It can be changed after creation, though there are some restrictions when going to a smaller plan such as the new plan must have sufficient amount of disk space to store all current data and switching to a plan with fewer nodes might not be supported. The basic plan names are `hobbyist`, `startup-x`, `business-x` and `premium-x` where `x` is (roughly) the amount of memory on each node (also other attributes like number of CPUs and amount of disk space varies but naming is based on memory). The available options can be seen from the [Aiven pricing page](https://aiven.io/pricing).
        """
        return pulumi.get(self, "plan")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        """
        The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="projectVpcId")
    def project_vpc_id(self) -> _builtins.str:
        """
        Specifies the VPC the service should run in. If the value is not set, the service runs on the Public Internet. When set, the value should be given as a reference to set up dependencies correctly, and the VPC must be in the same cloud and region as the service itself. The service can be freely moved to and from VPC after creation, but doing so triggers migration to new servers, so the operation can take a significant amount of time to complete if the service has a lot of data.
        """
        return pulumi.get(self, "project_vpc_id")

    @_builtins.property
    @pulumi.getter(name="serviceHost")
    def service_host(self) -> _builtins.str:
        """
        The hostname of the service.
        """
        return pulumi.get(self, "service_host")

    @_builtins.property
    @pulumi.getter(name="serviceIntegrations")
    def service_integrations(self) -> Sequence['outputs.GetOpenSearchServiceIntegrationResult']:
        """
        Service integrations to specify when creating a service. Not applied after initial service creation
        """
        return pulumi.get(self, "service_integrations")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> _builtins.str:
        """
        Specifies the actual name of the service. The name cannot be changed later without destroying and re-creating the service so name should be picked based on intended service usage rather than current attributes.
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter(name="servicePassword")
    def service_password(self) -> _builtins.str:
        """
        Password used for connecting to the service, if applicable
        """
        return pulumi.get(self, "service_password")

    @_builtins.property
    @pulumi.getter(name="servicePort")
    def service_port(self) -> _builtins.int:
        """
        The port of the service
        """
        return pulumi.get(self, "service_port")

    @_builtins.property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> _builtins.str:
        """
        Aiven internal service type code
        """
        return pulumi.get(self, "service_type")

    @_builtins.property
    @pulumi.getter(name="serviceUri")
    def service_uri(self) -> _builtins.str:
        """
        URI for connecting to the service. Service specific info is under "kafka", "pg", etc.
        """
        return pulumi.get(self, "service_uri")

    @_builtins.property
    @pulumi.getter(name="serviceUsername")
    def service_username(self) -> _builtins.str:
        """
        Username used for connecting to the service, if applicable
        """
        return pulumi.get(self, "service_username")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="staticIps")
    def static_ips(self) -> Sequence[_builtins.str]:
        """
        Static IPs that are going to be associated with this service. Please assign a value using the 'toset' function. Once a static ip resource is in the 'assigned' state it cannot be unbound from the node again
        """
        return pulumi.get(self, "static_ips")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence['outputs.GetOpenSearchTagResult']:
        """
        Tags are key-value pairs that allow you to categorize services.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="techEmails")
    def tech_emails(self) -> Sequence['outputs.GetOpenSearchTechEmailResult']:
        """
        The email addresses for [service contacts](https://aiven.io/docs/platform/howto/technical-emails), who will receive important alerts and updates about this service. You can also set email contacts at the project level.
        """
        return pulumi.get(self, "tech_emails")

    @_builtins.property
    @pulumi.getter(name="terminationProtection")
    def termination_protection(self) -> _builtins.bool:
        """
        Prevents the service from being deleted. It is recommended to set this to `true` for all production services to prevent unintentional service deletion. This does not shield against deleting databases or topics but for services with backups much of the content can at least be restored from backup in case accidental deletion is done.
        """
        return pulumi.get(self, "termination_protection")


class AwaitableGetOpenSearchResult(GetOpenSearchResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOpenSearchResult(
            additional_disk_space=self.additional_disk_space,
            cloud_name=self.cloud_name,
            components=self.components,
            disk_space=self.disk_space,
            disk_space_cap=self.disk_space_cap,
            disk_space_default=self.disk_space_default,
            disk_space_step=self.disk_space_step,
            disk_space_used=self.disk_space_used,
            id=self.id,
            maintenance_window_dow=self.maintenance_window_dow,
            maintenance_window_enabled=self.maintenance_window_enabled,
            maintenance_window_time=self.maintenance_window_time,
            opensearch_user_configs=self.opensearch_user_configs,
            opensearches=self.opensearches,
            plan=self.plan,
            project=self.project,
            project_vpc_id=self.project_vpc_id,
            service_host=self.service_host,
            service_integrations=self.service_integrations,
            service_name=self.service_name,
            service_password=self.service_password,
            service_port=self.service_port,
            service_type=self.service_type,
            service_uri=self.service_uri,
            service_username=self.service_username,
            state=self.state,
            static_ips=self.static_ips,
            tags=self.tags,
            tech_emails=self.tech_emails,
            termination_protection=self.termination_protection)


def get_open_search(project: Optional[_builtins.str] = None,
                    service_name: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOpenSearchResult:
    """
    Gets information about an Aiven for OpenSearch® service.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    example_opensearch = aiven.get_open_search(project=example_project["project"],
        service_name="example-opensearch")
    ```


    :param _builtins.str project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    :param _builtins.str service_name: Specifies the actual name of the service. The name cannot be changed later without destroying and re-creating the service so name should be picked based on intended service usage rather than current attributes.
    """
    __args__ = dict()
    __args__['project'] = project
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aiven:index/getOpenSearch:getOpenSearch', __args__, opts=opts, typ=GetOpenSearchResult).value

    return AwaitableGetOpenSearchResult(
        additional_disk_space=pulumi.get(__ret__, 'additional_disk_space'),
        cloud_name=pulumi.get(__ret__, 'cloud_name'),
        components=pulumi.get(__ret__, 'components'),
        disk_space=pulumi.get(__ret__, 'disk_space'),
        disk_space_cap=pulumi.get(__ret__, 'disk_space_cap'),
        disk_space_default=pulumi.get(__ret__, 'disk_space_default'),
        disk_space_step=pulumi.get(__ret__, 'disk_space_step'),
        disk_space_used=pulumi.get(__ret__, 'disk_space_used'),
        id=pulumi.get(__ret__, 'id'),
        maintenance_window_dow=pulumi.get(__ret__, 'maintenance_window_dow'),
        maintenance_window_enabled=pulumi.get(__ret__, 'maintenance_window_enabled'),
        maintenance_window_time=pulumi.get(__ret__, 'maintenance_window_time'),
        opensearch_user_configs=pulumi.get(__ret__, 'opensearch_user_configs'),
        opensearches=pulumi.get(__ret__, 'opensearches'),
        plan=pulumi.get(__ret__, 'plan'),
        project=pulumi.get(__ret__, 'project'),
        project_vpc_id=pulumi.get(__ret__, 'project_vpc_id'),
        service_host=pulumi.get(__ret__, 'service_host'),
        service_integrations=pulumi.get(__ret__, 'service_integrations'),
        service_name=pulumi.get(__ret__, 'service_name'),
        service_password=pulumi.get(__ret__, 'service_password'),
        service_port=pulumi.get(__ret__, 'service_port'),
        service_type=pulumi.get(__ret__, 'service_type'),
        service_uri=pulumi.get(__ret__, 'service_uri'),
        service_username=pulumi.get(__ret__, 'service_username'),
        state=pulumi.get(__ret__, 'state'),
        static_ips=pulumi.get(__ret__, 'static_ips'),
        tags=pulumi.get(__ret__, 'tags'),
        tech_emails=pulumi.get(__ret__, 'tech_emails'),
        termination_protection=pulumi.get(__ret__, 'termination_protection'))
def get_open_search_output(project: Optional[pulumi.Input[_builtins.str]] = None,
                           service_name: Optional[pulumi.Input[_builtins.str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOpenSearchResult]:
    """
    Gets information about an Aiven for OpenSearch® service.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    example_opensearch = aiven.get_open_search(project=example_project["project"],
        service_name="example-opensearch")
    ```


    :param _builtins.str project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    :param _builtins.str service_name: Specifies the actual name of the service. The name cannot be changed later without destroying and re-creating the service so name should be picked based on intended service usage rather than current attributes.
    """
    __args__ = dict()
    __args__['project'] = project
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aiven:index/getOpenSearch:getOpenSearch', __args__, opts=opts, typ=GetOpenSearchResult)
    return __ret__.apply(lambda __response__: GetOpenSearchResult(
        additional_disk_space=pulumi.get(__response__, 'additional_disk_space'),
        cloud_name=pulumi.get(__response__, 'cloud_name'),
        components=pulumi.get(__response__, 'components'),
        disk_space=pulumi.get(__response__, 'disk_space'),
        disk_space_cap=pulumi.get(__response__, 'disk_space_cap'),
        disk_space_default=pulumi.get(__response__, 'disk_space_default'),
        disk_space_step=pulumi.get(__response__, 'disk_space_step'),
        disk_space_used=pulumi.get(__response__, 'disk_space_used'),
        id=pulumi.get(__response__, 'id'),
        maintenance_window_dow=pulumi.get(__response__, 'maintenance_window_dow'),
        maintenance_window_enabled=pulumi.get(__response__, 'maintenance_window_enabled'),
        maintenance_window_time=pulumi.get(__response__, 'maintenance_window_time'),
        opensearch_user_configs=pulumi.get(__response__, 'opensearch_user_configs'),
        opensearches=pulumi.get(__response__, 'opensearches'),
        plan=pulumi.get(__response__, 'plan'),
        project=pulumi.get(__response__, 'project'),
        project_vpc_id=pulumi.get(__response__, 'project_vpc_id'),
        service_host=pulumi.get(__response__, 'service_host'),
        service_integrations=pulumi.get(__response__, 'service_integrations'),
        service_name=pulumi.get(__response__, 'service_name'),
        service_password=pulumi.get(__response__, 'service_password'),
        service_port=pulumi.get(__response__, 'service_port'),
        service_type=pulumi.get(__response__, 'service_type'),
        service_uri=pulumi.get(__response__, 'service_uri'),
        service_username=pulumi.get(__response__, 'service_username'),
        state=pulumi.get(__response__, 'state'),
        static_ips=pulumi.get(__response__, 'static_ips'),
        tags=pulumi.get(__response__, 'tags'),
        tech_emails=pulumi.get(__response__, 'tech_emails'),
        termination_protection=pulumi.get(__response__, 'termination_protection')))
