# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetOrganizationProjectResult',
    'AwaitableGetOrganizationProjectResult',
    'get_organization_project',
    'get_organization_project_output',
]

@pulumi.output_type
class GetOrganizationProjectResult:
    """
    A collection of values returned by getOrganizationProject.
    """
    def __init__(__self__, base_port=None, billing_group_id=None, ca_cert=None, id=None, organization_id=None, parent_id=None, project_id=None, tags=None, technical_emails=None, timeouts=None):
        if base_port and not isinstance(base_port, int):
            raise TypeError("Expected argument 'base_port' to be a int")
        pulumi.set(__self__, "base_port", base_port)
        if billing_group_id and not isinstance(billing_group_id, str):
            raise TypeError("Expected argument 'billing_group_id' to be a str")
        pulumi.set(__self__, "billing_group_id", billing_group_id)
        if ca_cert and not isinstance(ca_cert, str):
            raise TypeError("Expected argument 'ca_cert' to be a str")
        pulumi.set(__self__, "ca_cert", ca_cert)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if organization_id and not isinstance(organization_id, str):
            raise TypeError("Expected argument 'organization_id' to be a str")
        pulumi.set(__self__, "organization_id", organization_id)
        if parent_id and not isinstance(parent_id, str):
            raise TypeError("Expected argument 'parent_id' to be a str")
        pulumi.set(__self__, "parent_id", parent_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if technical_emails and not isinstance(technical_emails, list):
            raise TypeError("Expected argument 'technical_emails' to be a list")
        pulumi.set(__self__, "technical_emails", technical_emails)
        if timeouts and not isinstance(timeouts, dict):
            raise TypeError("Expected argument 'timeouts' to be a dict")
        pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="basePort")
    def base_port(self) -> _builtins.int:
        """
        Valid port number (1-65535) to use as a base for service port allocation.
        """
        return pulumi.get(self, "base_port")

    @_builtins.property
    @pulumi.getter(name="billingGroupId")
    def billing_group_id(self) -> _builtins.str:
        """
        Billing group ID to assign to the project. It's required when moving projects between organizations.
        """
        return pulumi.get(self, "billing_group_id")

    @_builtins.property
    @pulumi.getter(name="caCert")
    def ca_cert(self) -> _builtins.str:
        """
        PEM encoded certificate.
        """
        return pulumi.get(self, "ca_cert")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Resource ID, a composite of `organization_id` and `project_id` IDs.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> _builtins.str:
        """
        ID of an organization.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> _builtins.str:
        """
        Link a project to an [organization or organizational unit](https://aiven.io/docs/platform/concepts/orgs-units-projects) by using its ID. To set up proper dependencies please refer to this variable as a reference.
        """
        return pulumi.get(self, "parent_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        The name of the project. Names must be globally unique among all Aiven customers. Names must begin with a letter (a-z), and consist of letters, numbers, and dashes. It's recommended to use a random string or your organization name as a prefix or suffix. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.GetOrganizationProjectTagResult']]:
        """
        Tags are key-value pairs that allow you to categorize projects.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="technicalEmails")
    def technical_emails(self) -> Sequence[_builtins.str]:
        """
        The email addresses for [project contacts](https://aiven.io/docs/platform/howto/technical-emails), who will receive important alerts and updates about this project and its services. You can also set email contacts at the service level. It's good practice to keep these up-to-date to be aware of any potential issues with your project.
        """
        return pulumi.get(self, "technical_emails")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional['outputs.GetOrganizationProjectTimeoutsResult']:
        return pulumi.get(self, "timeouts")


class AwaitableGetOrganizationProjectResult(GetOrganizationProjectResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOrganizationProjectResult(
            base_port=self.base_port,
            billing_group_id=self.billing_group_id,
            ca_cert=self.ca_cert,
            id=self.id,
            organization_id=self.organization_id,
            parent_id=self.parent_id,
            project_id=self.project_id,
            tags=self.tags,
            technical_emails=self.technical_emails,
            timeouts=self.timeouts)


def get_organization_project(organization_id: Optional[_builtins.str] = None,
                             project_id: Optional[_builtins.str] = None,
                             tags: Optional[Sequence[Union['GetOrganizationProjectTagArgs', 'GetOrganizationProjectTagArgsDict']]] = None,
                             timeouts: Optional[Union['GetOrganizationProjectTimeoutsArgs', 'GetOrganizationProjectTimeoutsArgsDict']] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOrganizationProjectResult:
    """
    Gets information about an Aiven project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    example = aiven.get_organization_project(project_id=foo["projectId"],
        organization_id=foo["organizationId"])
    ```


    :param _builtins.str organization_id: ID of an organization.
    :param _builtins.str project_id: The name of the project. Names must be globally unique among all Aiven customers. Names must begin with a letter (a-z), and consist of letters, numbers, and dashes. It's recommended to use a random string or your organization name as a prefix or suffix. Changing this property forces recreation of the resource.
    :param Sequence[Union['GetOrganizationProjectTagArgs', 'GetOrganizationProjectTagArgsDict']] tags: Tags are key-value pairs that allow you to categorize projects.
    """
    __args__ = dict()
    __args__['organizationId'] = organization_id
    __args__['projectId'] = project_id
    __args__['tags'] = tags
    __args__['timeouts'] = timeouts
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aiven:index/getOrganizationProject:getOrganizationProject', __args__, opts=opts, typ=GetOrganizationProjectResult).value

    return AwaitableGetOrganizationProjectResult(
        base_port=pulumi.get(__ret__, 'base_port'),
        billing_group_id=pulumi.get(__ret__, 'billing_group_id'),
        ca_cert=pulumi.get(__ret__, 'ca_cert'),
        id=pulumi.get(__ret__, 'id'),
        organization_id=pulumi.get(__ret__, 'organization_id'),
        parent_id=pulumi.get(__ret__, 'parent_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        tags=pulumi.get(__ret__, 'tags'),
        technical_emails=pulumi.get(__ret__, 'technical_emails'),
        timeouts=pulumi.get(__ret__, 'timeouts'))
def get_organization_project_output(organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                                    project_id: Optional[pulumi.Input[_builtins.str]] = None,
                                    tags: Optional[pulumi.Input[Optional[Sequence[Union['GetOrganizationProjectTagArgs', 'GetOrganizationProjectTagArgsDict']]]]] = None,
                                    timeouts: Optional[pulumi.Input[Optional[Union['GetOrganizationProjectTimeoutsArgs', 'GetOrganizationProjectTimeoutsArgsDict']]]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOrganizationProjectResult]:
    """
    Gets information about an Aiven project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    example = aiven.get_organization_project(project_id=foo["projectId"],
        organization_id=foo["organizationId"])
    ```


    :param _builtins.str organization_id: ID of an organization.
    :param _builtins.str project_id: The name of the project. Names must be globally unique among all Aiven customers. Names must begin with a letter (a-z), and consist of letters, numbers, and dashes. It's recommended to use a random string or your organization name as a prefix or suffix. Changing this property forces recreation of the resource.
    :param Sequence[Union['GetOrganizationProjectTagArgs', 'GetOrganizationProjectTagArgsDict']] tags: Tags are key-value pairs that allow you to categorize projects.
    """
    __args__ = dict()
    __args__['organizationId'] = organization_id
    __args__['projectId'] = project_id
    __args__['tags'] = tags
    __args__['timeouts'] = timeouts
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aiven:index/getOrganizationProject:getOrganizationProject', __args__, opts=opts, typ=GetOrganizationProjectResult)
    return __ret__.apply(lambda __response__: GetOrganizationProjectResult(
        base_port=pulumi.get(__response__, 'base_port'),
        billing_group_id=pulumi.get(__response__, 'billing_group_id'),
        ca_cert=pulumi.get(__response__, 'ca_cert'),
        id=pulumi.get(__response__, 'id'),
        organization_id=pulumi.get(__response__, 'organization_id'),
        parent_id=pulumi.get(__response__, 'parent_id'),
        project_id=pulumi.get(__response__, 'project_id'),
        tags=pulumi.get(__response__, 'tags'),
        technical_emails=pulumi.get(__response__, 'technical_emails'),
        timeouts=pulumi.get(__response__, 'timeouts')))
