# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetOrganizationVpcResult',
    'AwaitableGetOrganizationVpcResult',
    'get_organization_vpc',
    'get_organization_vpc_output',
]

@pulumi.output_type
class GetOrganizationVpcResult:
    """
    A collection of values returned by getOrganizationVpc.
    """
    def __init__(__self__, cloud_name=None, create_time=None, id=None, network_cidr=None, organization_id=None, organization_vpc_id=None, state=None, update_time=None):
        if cloud_name and not isinstance(cloud_name, str):
            raise TypeError("Expected argument 'cloud_name' to be a str")
        pulumi.set(__self__, "cloud_name", cloud_name)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if network_cidr and not isinstance(network_cidr, str):
            raise TypeError("Expected argument 'network_cidr' to be a str")
        pulumi.set(__self__, "network_cidr", network_cidr)
        if organization_id and not isinstance(organization_id, str):
            raise TypeError("Expected argument 'organization_id' to be a str")
        pulumi.set(__self__, "organization_id", organization_id)
        if organization_vpc_id and not isinstance(organization_vpc_id, str):
            raise TypeError("Expected argument 'organization_vpc_id' to be a str")
        pulumi.set(__self__, "organization_vpc_id", organization_vpc_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="cloudName")
    def cloud_name(self) -> _builtins.str:
        """
        The cloud provider and region where the service is hosted in the format `CLOUD_PROVIDER-REGION_NAME`. For example, `google-europe-west1` or `aws-us-east-2`. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "cloud_name")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        Time of creation of the VPC.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="networkCidr")
    def network_cidr(self) -> _builtins.str:
        """
        Network address range used by the VPC. For example, `192.168.0.0/24`.
        """
        return pulumi.get(self, "network_cidr")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> _builtins.str:
        """
        The ID of the organization.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter(name="organizationVpcId")
    def organization_vpc_id(self) -> _builtins.str:
        """
        The ID of the Aiven Organization VPC.
        """
        return pulumi.get(self, "organization_vpc_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        State of the VPC. The possible values are `ACTIVE`, `APPROVED`, `DELETED` and `DELETING`.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> _builtins.str:
        """
        Time of the last update of the VPC.
        """
        return pulumi.get(self, "update_time")


class AwaitableGetOrganizationVpcResult(GetOrganizationVpcResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOrganizationVpcResult(
            cloud_name=self.cloud_name,
            create_time=self.create_time,
            id=self.id,
            network_cidr=self.network_cidr,
            organization_id=self.organization_id,
            organization_vpc_id=self.organization_vpc_id,
            state=self.state,
            update_time=self.update_time)


def get_organization_vpc(organization_id: Optional[_builtins.str] = None,
                         organization_vpc_id: Optional[_builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOrganizationVpcResult:
    """
    Gets information about an existing VPC in an Aiven organization.

    **This resource is in the beta stage and may change without notice.** Set
    the `PROVIDER_AIVEN_ENABLE_BETA` environment variable to use the resource.


    :param _builtins.str organization_id: The ID of the organization.
    :param _builtins.str organization_vpc_id: The ID of the Aiven Organization VPC.
    """
    __args__ = dict()
    __args__['organizationId'] = organization_id
    __args__['organizationVpcId'] = organization_vpc_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aiven:index/getOrganizationVpc:getOrganizationVpc', __args__, opts=opts, typ=GetOrganizationVpcResult).value

    return AwaitableGetOrganizationVpcResult(
        cloud_name=pulumi.get(__ret__, 'cloud_name'),
        create_time=pulumi.get(__ret__, 'create_time'),
        id=pulumi.get(__ret__, 'id'),
        network_cidr=pulumi.get(__ret__, 'network_cidr'),
        organization_id=pulumi.get(__ret__, 'organization_id'),
        organization_vpc_id=pulumi.get(__ret__, 'organization_vpc_id'),
        state=pulumi.get(__ret__, 'state'),
        update_time=pulumi.get(__ret__, 'update_time'))
def get_organization_vpc_output(organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                                organization_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOrganizationVpcResult]:
    """
    Gets information about an existing VPC in an Aiven organization.

    **This resource is in the beta stage and may change without notice.** Set
    the `PROVIDER_AIVEN_ENABLE_BETA` environment variable to use the resource.


    :param _builtins.str organization_id: The ID of the organization.
    :param _builtins.str organization_vpc_id: The ID of the Aiven Organization VPC.
    """
    __args__ = dict()
    __args__['organizationId'] = organization_id
    __args__['organizationVpcId'] = organization_vpc_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aiven:index/getOrganizationVpc:getOrganizationVpc', __args__, opts=opts, typ=GetOrganizationVpcResult)
    return __ret__.apply(lambda __response__: GetOrganizationVpcResult(
        cloud_name=pulumi.get(__response__, 'cloud_name'),
        create_time=pulumi.get(__response__, 'create_time'),
        id=pulumi.get(__response__, 'id'),
        network_cidr=pulumi.get(__response__, 'network_cidr'),
        organization_id=pulumi.get(__response__, 'organization_id'),
        organization_vpc_id=pulumi.get(__response__, 'organization_vpc_id'),
        state=pulumi.get(__response__, 'state'),
        update_time=pulumi.get(__response__, 'update_time')))
