# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OrganizationApplicationUserArgs', 'OrganizationApplicationUser']

@pulumi.input_type
class OrganizationApplicationUserArgs:
    def __init__(__self__, *,
                 organization_id: pulumi.Input[_builtins.str],
                 is_super_admin: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['OrganizationApplicationUserTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a OrganizationApplicationUser resource.
        :param pulumi.Input[_builtins.str] organization_id: ID of an organization. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.bool] is_super_admin: Alters super admin state of the organization application user. The default value is `false`.
        :param pulumi.Input[_builtins.str] name: Name.
        """
        pulumi.set(__self__, "organization_id", organization_id)
        if is_super_admin is not None:
            warnings.warn("""This field is no longer accepted by the API. For administrative tasks, assign application users the organization admin role instead using the OrganizationPermission resource.""", DeprecationWarning)
            pulumi.log.warn("""is_super_admin is deprecated: This field is no longer accepted by the API. For administrative tasks, assign application users the organization admin role instead using the OrganizationPermission resource.""")
        if is_super_admin is not None:
            pulumi.set(__self__, "is_super_admin", is_super_admin)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of an organization. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter(name="isSuperAdmin")
    @_utilities.deprecated("""This field is no longer accepted by the API. For administrative tasks, assign application users the organization admin role instead using the OrganizationPermission resource.""")
    def is_super_admin(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Alters super admin state of the organization application user. The default value is `false`.
        """
        return pulumi.get(self, "is_super_admin")

    @is_super_admin.setter
    def is_super_admin(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_super_admin", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['OrganizationApplicationUserTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['OrganizationApplicationUserTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _OrganizationApplicationUserState:
    def __init__(__self__, *,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 is_super_admin: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['OrganizationApplicationUserTimeoutsArgs']] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering OrganizationApplicationUser resources.
        :param pulumi.Input[_builtins.str] email: User Email.
        :param pulumi.Input[_builtins.bool] is_super_admin: Alters super admin state of the organization application user. The default value is `false`.
        :param pulumi.Input[_builtins.str] name: Name.
        :param pulumi.Input[_builtins.str] organization_id: ID of an organization. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] user_id: User ID.
        """
        if email is not None:
            pulumi.set(__self__, "email", email)
        if is_super_admin is not None:
            warnings.warn("""This field is no longer accepted by the API. For administrative tasks, assign application users the organization admin role instead using the OrganizationPermission resource.""", DeprecationWarning)
            pulumi.log.warn("""is_super_admin is deprecated: This field is no longer accepted by the API. For administrative tasks, assign application users the organization admin role instead using the OrganizationPermission resource.""")
        if is_super_admin is not None:
            pulumi.set(__self__, "is_super_admin", is_super_admin)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User Email.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter(name="isSuperAdmin")
    @_utilities.deprecated("""This field is no longer accepted by the API. For administrative tasks, assign application users the organization admin role instead using the OrganizationPermission resource.""")
    def is_super_admin(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Alters super admin state of the organization application user. The default value is `false`.
        """
        return pulumi.get(self, "is_super_admin")

    @is_super_admin.setter
    def is_super_admin(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_super_admin", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of an organization. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['OrganizationApplicationUserTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['OrganizationApplicationUserTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User ID.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_id", value)


@pulumi.type_token("aiven:index/organizationApplicationUser:OrganizationApplicationUser")
class OrganizationApplicationUser(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 is_super_admin: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['OrganizationApplicationUserTimeoutsArgs', 'OrganizationApplicationUserTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Creates and manages an organization application user. [Application users](https://aiven.io/docs/platform/concepts/application-users) can be used for programmatic access to the platform using a token created with the `OrganizationApplicationUserToken` resource. You give application users access to your organization, projects, and services using the `OrganizationPermission` resource. You can also add application users to groups using the `OrganizationUserGroupMember` resource.`.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        tf_user = aiven.OrganizationApplicationUser("tf_user",
            organization_id=main["id"],
            name="app-terraform")
        ```

        ## Import

        ```sh
        $ pulumi import aiven:index/organizationApplicationUser:OrganizationApplicationUser example ORGANIZATION_ID/USER_ID
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] is_super_admin: Alters super admin state of the organization application user. The default value is `false`.
        :param pulumi.Input[_builtins.str] name: Name.
        :param pulumi.Input[_builtins.str] organization_id: ID of an organization. Changing this property forces recreation of the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OrganizationApplicationUserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages an organization application user. [Application users](https://aiven.io/docs/platform/concepts/application-users) can be used for programmatic access to the platform using a token created with the `OrganizationApplicationUserToken` resource. You give application users access to your organization, projects, and services using the `OrganizationPermission` resource. You can also add application users to groups using the `OrganizationUserGroupMember` resource.`.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        tf_user = aiven.OrganizationApplicationUser("tf_user",
            organization_id=main["id"],
            name="app-terraform")
        ```

        ## Import

        ```sh
        $ pulumi import aiven:index/organizationApplicationUser:OrganizationApplicationUser example ORGANIZATION_ID/USER_ID
        ```

        :param str resource_name: The name of the resource.
        :param OrganizationApplicationUserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OrganizationApplicationUserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 is_super_admin: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['OrganizationApplicationUserTimeoutsArgs', 'OrganizationApplicationUserTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OrganizationApplicationUserArgs.__new__(OrganizationApplicationUserArgs)

            __props__.__dict__["is_super_admin"] = is_super_admin
            __props__.__dict__["name"] = name
            if organization_id is None and not opts.urn:
                raise TypeError("Missing required property 'organization_id'")
            __props__.__dict__["organization_id"] = organization_id
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["email"] = None
            __props__.__dict__["user_id"] = None
        super(OrganizationApplicationUser, __self__).__init__(
            'aiven:index/organizationApplicationUser:OrganizationApplicationUser',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            email: Optional[pulumi.Input[_builtins.str]] = None,
            is_super_admin: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            organization_id: Optional[pulumi.Input[_builtins.str]] = None,
            timeouts: Optional[pulumi.Input[Union['OrganizationApplicationUserTimeoutsArgs', 'OrganizationApplicationUserTimeoutsArgsDict']]] = None,
            user_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'OrganizationApplicationUser':
        """
        Get an existing OrganizationApplicationUser resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] email: User Email.
        :param pulumi.Input[_builtins.bool] is_super_admin: Alters super admin state of the organization application user. The default value is `false`.
        :param pulumi.Input[_builtins.str] name: Name.
        :param pulumi.Input[_builtins.str] organization_id: ID of an organization. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] user_id: User ID.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OrganizationApplicationUserState.__new__(_OrganizationApplicationUserState)

        __props__.__dict__["email"] = email
        __props__.__dict__["is_super_admin"] = is_super_admin
        __props__.__dict__["name"] = name
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["user_id"] = user_id
        return OrganizationApplicationUser(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def email(self) -> pulumi.Output[_builtins.str]:
        """
        User Email.
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter(name="isSuperAdmin")
    @_utilities.deprecated("""This field is no longer accepted by the API. For administrative tasks, assign application users the organization admin role instead using the OrganizationPermission resource.""")
    def is_super_admin(self) -> pulumi.Output[_builtins.bool]:
        """
        Alters super admin state of the organization application user. The default value is `false`.
        """
        return pulumi.get(self, "is_super_admin")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of an organization. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.OrganizationApplicationUserTimeouts']]:
        return pulumi.get(self, "timeouts")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[_builtins.str]:
        """
        User ID.
        """
        return pulumi.get(self, "user_id")

