# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OrganizationApplicationUserTokenArgs', 'OrganizationApplicationUserToken']

@pulumi.input_type
class OrganizationApplicationUserTokenArgs:
    def __init__(__self__, *,
                 organization_id: pulumi.Input[_builtins.str],
                 user_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 extend_when_used: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_allowlists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 max_age_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['OrganizationApplicationUserTokenTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a OrganizationApplicationUserToken resource.
        :param pulumi.Input[_builtins.str] organization_id: ID of an organization. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] user_id: User ID. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] description: Description. Maximum length: `1000`. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.bool] extend_when_used: Extend token expiration time when token is used. Only applicable if max*age*seconds is specified. The default value is `false`. Changing this property forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_allowlists: List of allowed IP ranges. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.int] max_age_seconds: Time the token remains valid since creation (or since last use if extend*when*used is true). Changing this property forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] scopes: Scopes this token is restricted to if specified. Changing this property forces recreation of the resource.
        """
        pulumi.set(__self__, "organization_id", organization_id)
        pulumi.set(__self__, "user_id", user_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if extend_when_used is not None:
            pulumi.set(__self__, "extend_when_used", extend_when_used)
        if ip_allowlists is not None:
            pulumi.set(__self__, "ip_allowlists", ip_allowlists)
        if max_age_seconds is not None:
            pulumi.set(__self__, "max_age_seconds", max_age_seconds)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of an organization. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Input[_builtins.str]:
        """
        User ID. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "user_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description. Maximum length: `1000`. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="extendWhenUsed")
    def extend_when_used(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Extend token expiration time when token is used. Only applicable if max*age*seconds is specified. The default value is `false`. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "extend_when_used")

    @extend_when_used.setter
    def extend_when_used(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "extend_when_used", value)

    @_builtins.property
    @pulumi.getter(name="ipAllowlists")
    def ip_allowlists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of allowed IP ranges. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "ip_allowlists")

    @ip_allowlists.setter
    def ip_allowlists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ip_allowlists", value)

    @_builtins.property
    @pulumi.getter(name="maxAgeSeconds")
    def max_age_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time the token remains valid since creation (or since last use if extend*when*used is true). Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "max_age_seconds")

    @max_age_seconds.setter
    def max_age_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_age_seconds", value)

    @_builtins.property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Scopes this token is restricted to if specified. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "scopes", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['OrganizationApplicationUserTokenTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['OrganizationApplicationUserTokenTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _OrganizationApplicationUserTokenState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 created_manually: Optional[pulumi.Input[_builtins.bool]] = None,
                 currently_active: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 expiry_time: Optional[pulumi.Input[_builtins.str]] = None,
                 extend_when_used: Optional[pulumi.Input[_builtins.bool]] = None,
                 full_token: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_allowlists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 last_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 last_used_time: Optional[pulumi.Input[_builtins.str]] = None,
                 last_user_agent: Optional[pulumi.Input[_builtins.str]] = None,
                 last_user_agent_human_readable: Optional[pulumi.Input[_builtins.str]] = None,
                 max_age_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['OrganizationApplicationUserTokenTimeoutsArgs']] = None,
                 token_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering OrganizationApplicationUserToken resources.
        :param pulumi.Input[_builtins.str] create_time: Create Time.
        :param pulumi.Input[_builtins.bool] created_manually: True for tokens explicitly created via the access_tokens API, false for tokens created via login.
        :param pulumi.Input[_builtins.bool] currently_active: true if API request was made with this access token.
        :param pulumi.Input[_builtins.str] description: Description. Maximum length: `1000`. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] expiry_time: Timestamp when the access token will expire unless extended, if ever.
        :param pulumi.Input[_builtins.bool] extend_when_used: Extend token expiration time when token is used. Only applicable if max*age*seconds is specified. The default value is `false`. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] full_token: Full Token.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_allowlists: List of allowed IP ranges. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] last_ip: IP address the access token was last used from in case it has ever been used.
        :param pulumi.Input[_builtins.str] last_used_time: Timestamp when the access token was last used, if ever.
        :param pulumi.Input[_builtins.str] last_user_agent: User agent string of the client that last used the token in case it has ever been used.
        :param pulumi.Input[_builtins.str] last_user_agent_human_readable: Human readable user agent string of the client that last used the token in case user agent is known.
        :param pulumi.Input[_builtins.int] max_age_seconds: Time the token remains valid since creation (or since last use if extend*when*used is true). Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] organization_id: ID of an organization. Changing this property forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] scopes: Scopes this token is restricted to if specified. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] token_prefix: First characters of the actual token value. Full value is only exposed after creation. This value is used when updating or revoking tokens. Note that the value may contain /, + and = characters and must be URL encoded when used (/ =&gt; %2F, + =&gt; %2B, = =&gt; %3D).
        :param pulumi.Input[_builtins.str] user_id: User ID. Changing this property forces recreation of the resource.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if created_manually is not None:
            pulumi.set(__self__, "created_manually", created_manually)
        if currently_active is not None:
            pulumi.set(__self__, "currently_active", currently_active)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expiry_time is not None:
            pulumi.set(__self__, "expiry_time", expiry_time)
        if extend_when_used is not None:
            pulumi.set(__self__, "extend_when_used", extend_when_used)
        if full_token is not None:
            pulumi.set(__self__, "full_token", full_token)
        if ip_allowlists is not None:
            pulumi.set(__self__, "ip_allowlists", ip_allowlists)
        if last_ip is not None:
            pulumi.set(__self__, "last_ip", last_ip)
        if last_used_time is not None:
            pulumi.set(__self__, "last_used_time", last_used_time)
        if last_user_agent is not None:
            pulumi.set(__self__, "last_user_agent", last_user_agent)
        if last_user_agent_human_readable is not None:
            pulumi.set(__self__, "last_user_agent_human_readable", last_user_agent_human_readable)
        if max_age_seconds is not None:
            pulumi.set(__self__, "max_age_seconds", max_age_seconds)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if token_prefix is not None:
            pulumi.set(__self__, "token_prefix", token_prefix)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Create Time.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="createdManually")
    def created_manually(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        True for tokens explicitly created via the access_tokens API, false for tokens created via login.
        """
        return pulumi.get(self, "created_manually")

    @created_manually.setter
    def created_manually(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "created_manually", value)

    @_builtins.property
    @pulumi.getter(name="currentlyActive")
    def currently_active(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        true if API request was made with this access token.
        """
        return pulumi.get(self, "currently_active")

    @currently_active.setter
    def currently_active(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "currently_active", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description. Maximum length: `1000`. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="expiryTime")
    def expiry_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp when the access token will expire unless extended, if ever.
        """
        return pulumi.get(self, "expiry_time")

    @expiry_time.setter
    def expiry_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expiry_time", value)

    @_builtins.property
    @pulumi.getter(name="extendWhenUsed")
    def extend_when_used(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Extend token expiration time when token is used. Only applicable if max*age*seconds is specified. The default value is `false`. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "extend_when_used")

    @extend_when_used.setter
    def extend_when_used(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "extend_when_used", value)

    @_builtins.property
    @pulumi.getter(name="fullToken")
    def full_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Full Token.
        """
        return pulumi.get(self, "full_token")

    @full_token.setter
    def full_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "full_token", value)

    @_builtins.property
    @pulumi.getter(name="ipAllowlists")
    def ip_allowlists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of allowed IP ranges. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "ip_allowlists")

    @ip_allowlists.setter
    def ip_allowlists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ip_allowlists", value)

    @_builtins.property
    @pulumi.getter(name="lastIp")
    def last_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IP address the access token was last used from in case it has ever been used.
        """
        return pulumi.get(self, "last_ip")

    @last_ip.setter
    def last_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_ip", value)

    @_builtins.property
    @pulumi.getter(name="lastUsedTime")
    def last_used_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp when the access token was last used, if ever.
        """
        return pulumi.get(self, "last_used_time")

    @last_used_time.setter
    def last_used_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_used_time", value)

    @_builtins.property
    @pulumi.getter(name="lastUserAgent")
    def last_user_agent(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User agent string of the client that last used the token in case it has ever been used.
        """
        return pulumi.get(self, "last_user_agent")

    @last_user_agent.setter
    def last_user_agent(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_user_agent", value)

    @_builtins.property
    @pulumi.getter(name="lastUserAgentHumanReadable")
    def last_user_agent_human_readable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human readable user agent string of the client that last used the token in case user agent is known.
        """
        return pulumi.get(self, "last_user_agent_human_readable")

    @last_user_agent_human_readable.setter
    def last_user_agent_human_readable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_user_agent_human_readable", value)

    @_builtins.property
    @pulumi.getter(name="maxAgeSeconds")
    def max_age_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time the token remains valid since creation (or since last use if extend*when*used is true). Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "max_age_seconds")

    @max_age_seconds.setter
    def max_age_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_age_seconds", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of an organization. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Scopes this token is restricted to if specified. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "scopes", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['OrganizationApplicationUserTokenTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['OrganizationApplicationUserTokenTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter(name="tokenPrefix")
    def token_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        First characters of the actual token value. Full value is only exposed after creation. This value is used when updating or revoking tokens. Note that the value may contain /, + and = characters and must be URL encoded when used (/ =&gt; %2F, + =&gt; %2B, = =&gt; %3D).
        """
        return pulumi.get(self, "token_prefix")

    @token_prefix.setter
    def token_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token_prefix", value)

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User ID. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_id", value)


@pulumi.type_token("aiven:index/organizationApplicationUserToken:OrganizationApplicationUserToken")
class OrganizationApplicationUserToken(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 extend_when_used: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_allowlists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 max_age_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['OrganizationApplicationUserTokenTimeoutsArgs', 'OrganizationApplicationUserTokenTimeoutsArgsDict']]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages an application user token. Review the [best practices](https://aiven.io/docs/platform/concepts/application-users#security-best-practices) for securing application users and their tokens.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        tf_user = aiven.OrganizationApplicationUser("tf_user",
            organization_id=main["id"],
            name="app-terraform")
        example = aiven.OrganizationApplicationUserToken("example",
            organization_id=main["id"],
            user_id=tf_user.user_id,
            description="Token for TF access to Aiven.")
        ```

        ## Import

        ```sh
        $ pulumi import aiven:index/organizationApplicationUserToken:OrganizationApplicationUserToken example ORGANIZATION_ID/USER_ID/TOKEN_PREFIX
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Description. Maximum length: `1000`. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.bool] extend_when_used: Extend token expiration time when token is used. Only applicable if max*age*seconds is specified. The default value is `false`. Changing this property forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_allowlists: List of allowed IP ranges. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.int] max_age_seconds: Time the token remains valid since creation (or since last use if extend*when*used is true). Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] organization_id: ID of an organization. Changing this property forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] scopes: Scopes this token is restricted to if specified. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] user_id: User ID. Changing this property forces recreation of the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OrganizationApplicationUserTokenArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages an application user token. Review the [best practices](https://aiven.io/docs/platform/concepts/application-users#security-best-practices) for securing application users and their tokens.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        tf_user = aiven.OrganizationApplicationUser("tf_user",
            organization_id=main["id"],
            name="app-terraform")
        example = aiven.OrganizationApplicationUserToken("example",
            organization_id=main["id"],
            user_id=tf_user.user_id,
            description="Token for TF access to Aiven.")
        ```

        ## Import

        ```sh
        $ pulumi import aiven:index/organizationApplicationUserToken:OrganizationApplicationUserToken example ORGANIZATION_ID/USER_ID/TOKEN_PREFIX
        ```

        :param str resource_name: The name of the resource.
        :param OrganizationApplicationUserTokenArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OrganizationApplicationUserTokenArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 extend_when_used: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_allowlists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 max_age_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['OrganizationApplicationUserTokenTimeoutsArgs', 'OrganizationApplicationUserTokenTimeoutsArgsDict']]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OrganizationApplicationUserTokenArgs.__new__(OrganizationApplicationUserTokenArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["extend_when_used"] = extend_when_used
            __props__.__dict__["ip_allowlists"] = ip_allowlists
            __props__.__dict__["max_age_seconds"] = max_age_seconds
            if organization_id is None and not opts.urn:
                raise TypeError("Missing required property 'organization_id'")
            __props__.__dict__["organization_id"] = organization_id
            __props__.__dict__["scopes"] = scopes
            __props__.__dict__["timeouts"] = timeouts
            if user_id is None and not opts.urn:
                raise TypeError("Missing required property 'user_id'")
            __props__.__dict__["user_id"] = user_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["created_manually"] = None
            __props__.__dict__["currently_active"] = None
            __props__.__dict__["expiry_time"] = None
            __props__.__dict__["full_token"] = None
            __props__.__dict__["last_ip"] = None
            __props__.__dict__["last_used_time"] = None
            __props__.__dict__["last_user_agent"] = None
            __props__.__dict__["last_user_agent_human_readable"] = None
            __props__.__dict__["token_prefix"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["fullToken"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(OrganizationApplicationUserToken, __self__).__init__(
            'aiven:index/organizationApplicationUserToken:OrganizationApplicationUserToken',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            created_manually: Optional[pulumi.Input[_builtins.bool]] = None,
            currently_active: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            expiry_time: Optional[pulumi.Input[_builtins.str]] = None,
            extend_when_used: Optional[pulumi.Input[_builtins.bool]] = None,
            full_token: Optional[pulumi.Input[_builtins.str]] = None,
            ip_allowlists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            last_ip: Optional[pulumi.Input[_builtins.str]] = None,
            last_used_time: Optional[pulumi.Input[_builtins.str]] = None,
            last_user_agent: Optional[pulumi.Input[_builtins.str]] = None,
            last_user_agent_human_readable: Optional[pulumi.Input[_builtins.str]] = None,
            max_age_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            organization_id: Optional[pulumi.Input[_builtins.str]] = None,
            scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            timeouts: Optional[pulumi.Input[Union['OrganizationApplicationUserTokenTimeoutsArgs', 'OrganizationApplicationUserTokenTimeoutsArgsDict']]] = None,
            token_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            user_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'OrganizationApplicationUserToken':
        """
        Get an existing OrganizationApplicationUserToken resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: Create Time.
        :param pulumi.Input[_builtins.bool] created_manually: True for tokens explicitly created via the access_tokens API, false for tokens created via login.
        :param pulumi.Input[_builtins.bool] currently_active: true if API request was made with this access token.
        :param pulumi.Input[_builtins.str] description: Description. Maximum length: `1000`. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] expiry_time: Timestamp when the access token will expire unless extended, if ever.
        :param pulumi.Input[_builtins.bool] extend_when_used: Extend token expiration time when token is used. Only applicable if max*age*seconds is specified. The default value is `false`. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] full_token: Full Token.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_allowlists: List of allowed IP ranges. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] last_ip: IP address the access token was last used from in case it has ever been used.
        :param pulumi.Input[_builtins.str] last_used_time: Timestamp when the access token was last used, if ever.
        :param pulumi.Input[_builtins.str] last_user_agent: User agent string of the client that last used the token in case it has ever been used.
        :param pulumi.Input[_builtins.str] last_user_agent_human_readable: Human readable user agent string of the client that last used the token in case user agent is known.
        :param pulumi.Input[_builtins.int] max_age_seconds: Time the token remains valid since creation (or since last use if extend*when*used is true). Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] organization_id: ID of an organization. Changing this property forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] scopes: Scopes this token is restricted to if specified. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] token_prefix: First characters of the actual token value. Full value is only exposed after creation. This value is used when updating or revoking tokens. Note that the value may contain /, + and = characters and must be URL encoded when used (/ =&gt; %2F, + =&gt; %2B, = =&gt; %3D).
        :param pulumi.Input[_builtins.str] user_id: User ID. Changing this property forces recreation of the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OrganizationApplicationUserTokenState.__new__(_OrganizationApplicationUserTokenState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["created_manually"] = created_manually
        __props__.__dict__["currently_active"] = currently_active
        __props__.__dict__["description"] = description
        __props__.__dict__["expiry_time"] = expiry_time
        __props__.__dict__["extend_when_used"] = extend_when_used
        __props__.__dict__["full_token"] = full_token
        __props__.__dict__["ip_allowlists"] = ip_allowlists
        __props__.__dict__["last_ip"] = last_ip
        __props__.__dict__["last_used_time"] = last_used_time
        __props__.__dict__["last_user_agent"] = last_user_agent
        __props__.__dict__["last_user_agent_human_readable"] = last_user_agent_human_readable
        __props__.__dict__["max_age_seconds"] = max_age_seconds
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["scopes"] = scopes
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["token_prefix"] = token_prefix
        __props__.__dict__["user_id"] = user_id
        return OrganizationApplicationUserToken(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Create Time.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="createdManually")
    def created_manually(self) -> pulumi.Output[_builtins.bool]:
        """
        True for tokens explicitly created via the access_tokens API, false for tokens created via login.
        """
        return pulumi.get(self, "created_manually")

    @_builtins.property
    @pulumi.getter(name="currentlyActive")
    def currently_active(self) -> pulumi.Output[_builtins.bool]:
        """
        true if API request was made with this access token.
        """
        return pulumi.get(self, "currently_active")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description. Maximum length: `1000`. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="expiryTime")
    def expiry_time(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp when the access token will expire unless extended, if ever.
        """
        return pulumi.get(self, "expiry_time")

    @_builtins.property
    @pulumi.getter(name="extendWhenUsed")
    def extend_when_used(self) -> pulumi.Output[_builtins.bool]:
        """
        Extend token expiration time when token is used. Only applicable if max*age*seconds is specified. The default value is `false`. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "extend_when_used")

    @_builtins.property
    @pulumi.getter(name="fullToken")
    def full_token(self) -> pulumi.Output[_builtins.str]:
        """
        Full Token.
        """
        return pulumi.get(self, "full_token")

    @_builtins.property
    @pulumi.getter(name="ipAllowlists")
    def ip_allowlists(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of allowed IP ranges. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "ip_allowlists")

    @_builtins.property
    @pulumi.getter(name="lastIp")
    def last_ip(self) -> pulumi.Output[_builtins.str]:
        """
        IP address the access token was last used from in case it has ever been used.
        """
        return pulumi.get(self, "last_ip")

    @_builtins.property
    @pulumi.getter(name="lastUsedTime")
    def last_used_time(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp when the access token was last used, if ever.
        """
        return pulumi.get(self, "last_used_time")

    @_builtins.property
    @pulumi.getter(name="lastUserAgent")
    def last_user_agent(self) -> pulumi.Output[_builtins.str]:
        """
        User agent string of the client that last used the token in case it has ever been used.
        """
        return pulumi.get(self, "last_user_agent")

    @_builtins.property
    @pulumi.getter(name="lastUserAgentHumanReadable")
    def last_user_agent_human_readable(self) -> pulumi.Output[_builtins.str]:
        """
        Human readable user agent string of the client that last used the token in case user agent is known.
        """
        return pulumi.get(self, "last_user_agent_human_readable")

    @_builtins.property
    @pulumi.getter(name="maxAgeSeconds")
    def max_age_seconds(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Time the token remains valid since creation (or since last use if extend*when*used is true). Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "max_age_seconds")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of an organization. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter
    def scopes(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Scopes this token is restricted to if specified. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "scopes")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.OrganizationApplicationUserTokenTimeouts']]:
        return pulumi.get(self, "timeouts")

    @_builtins.property
    @pulumi.getter(name="tokenPrefix")
    def token_prefix(self) -> pulumi.Output[_builtins.str]:
        """
        First characters of the actual token value. Full value is only exposed after creation. This value is used when updating or revoking tokens. Note that the value may contain /, + and = characters and must be URL encoded when used (/ =&gt; %2F, + =&gt; %2B, = =&gt; %3D).
        """
        return pulumi.get(self, "token_prefix")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[_builtins.str]:
        """
        User ID. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "user_id")

