# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ValkeyUserArgs', 'ValkeyUser']

@pulumi.input_type
class ValkeyUserArgs:
    def __init__(__self__, *,
                 project: pulumi.Input[_builtins.str],
                 service_name: pulumi.Input[_builtins.str],
                 username: pulumi.Input[_builtins.str],
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 valkey_acl_categories: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 valkey_acl_channels: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 valkey_acl_commands: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 valkey_acl_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a ValkeyUser resource.
        :param pulumi.Input[_builtins.str] project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] username: Name of the Valkey service user. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] password: The Valkey service user's password.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] valkey_acl_categories: Allow or disallow command categories. To allow a category use the prefix `+@` and to disallow use `-@`. See the [Valkey documentation](https://valkey.io/topics/acl/) for details on the ACL feature. The field is required with `valkey_acl_commands` and `valkey_acl_keys`. Changing this property forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] valkey_acl_channels: Allows and disallows access to pub/sub channels. Entries are defined as standard glob patterns. Changing this property forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] valkey_acl_commands: Defines rules for individual commands. To allow a command use the prefix `+` and to disallow use `-`. The field is required with `valkey_acl_categories` and `valkey_acl_keys`. Changing this property forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] valkey_acl_keys: Key access rules. Entries are defined as standard glob patterns. The field is required with `valkey_acl_categories` and `valkey_acl_keys`. Changing this property forces recreation of the resource.
        """
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "service_name", service_name)
        pulumi.set(__self__, "username", username)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if valkey_acl_categories is not None:
            pulumi.set(__self__, "valkey_acl_categories", valkey_acl_categories)
        if valkey_acl_channels is not None:
            pulumi.set(__self__, "valkey_acl_channels", valkey_acl_channels)
        if valkey_acl_commands is not None:
            pulumi.set(__self__, "valkey_acl_commands", valkey_acl_commands)
        if valkey_acl_keys is not None:
            pulumi.set(__self__, "valkey_acl_keys", valkey_acl_keys)

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the Valkey service user. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "username", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Valkey service user's password.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="valkeyAclCategories")
    def valkey_acl_categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Allow or disallow command categories. To allow a category use the prefix `+@` and to disallow use `-@`. See the [Valkey documentation](https://valkey.io/topics/acl/) for details on the ACL feature. The field is required with `valkey_acl_commands` and `valkey_acl_keys`. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "valkey_acl_categories")

    @valkey_acl_categories.setter
    def valkey_acl_categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "valkey_acl_categories", value)

    @_builtins.property
    @pulumi.getter(name="valkeyAclChannels")
    def valkey_acl_channels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Allows and disallows access to pub/sub channels. Entries are defined as standard glob patterns. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "valkey_acl_channels")

    @valkey_acl_channels.setter
    def valkey_acl_channels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "valkey_acl_channels", value)

    @_builtins.property
    @pulumi.getter(name="valkeyAclCommands")
    def valkey_acl_commands(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Defines rules for individual commands. To allow a command use the prefix `+` and to disallow use `-`. The field is required with `valkey_acl_categories` and `valkey_acl_keys`. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "valkey_acl_commands")

    @valkey_acl_commands.setter
    def valkey_acl_commands(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "valkey_acl_commands", value)

    @_builtins.property
    @pulumi.getter(name="valkeyAclKeys")
    def valkey_acl_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Key access rules. Entries are defined as standard glob patterns. The field is required with `valkey_acl_categories` and `valkey_acl_keys`. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "valkey_acl_keys")

    @valkey_acl_keys.setter
    def valkey_acl_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "valkey_acl_keys", value)


@pulumi.input_type
class _ValkeyUserState:
    def __init__(__self__, *,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 valkey_acl_categories: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 valkey_acl_channels: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 valkey_acl_commands: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 valkey_acl_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ValkeyUser resources.
        :param pulumi.Input[_builtins.str] password: The Valkey service user's password.
        :param pulumi.Input[_builtins.str] project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] type: User account type, such as primary or regular account.
        :param pulumi.Input[_builtins.str] username: Name of the Valkey service user. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] valkey_acl_categories: Allow or disallow command categories. To allow a category use the prefix `+@` and to disallow use `-@`. See the [Valkey documentation](https://valkey.io/topics/acl/) for details on the ACL feature. The field is required with `valkey_acl_commands` and `valkey_acl_keys`. Changing this property forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] valkey_acl_channels: Allows and disallows access to pub/sub channels. Entries are defined as standard glob patterns. Changing this property forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] valkey_acl_commands: Defines rules for individual commands. To allow a command use the prefix `+` and to disallow use `-`. The field is required with `valkey_acl_categories` and `valkey_acl_keys`. Changing this property forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] valkey_acl_keys: Key access rules. Entries are defined as standard glob patterns. The field is required with `valkey_acl_categories` and `valkey_acl_keys`. Changing this property forces recreation of the resource.
        """
        if password is not None:
            pulumi.set(__self__, "password", password)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if valkey_acl_categories is not None:
            pulumi.set(__self__, "valkey_acl_categories", valkey_acl_categories)
        if valkey_acl_channels is not None:
            pulumi.set(__self__, "valkey_acl_channels", valkey_acl_channels)
        if valkey_acl_commands is not None:
            pulumi.set(__self__, "valkey_acl_commands", valkey_acl_commands)
        if valkey_acl_keys is not None:
            pulumi.set(__self__, "valkey_acl_keys", valkey_acl_keys)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Valkey service user's password.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User account type, such as primary or regular account.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Valkey service user. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)

    @_builtins.property
    @pulumi.getter(name="valkeyAclCategories")
    def valkey_acl_categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Allow or disallow command categories. To allow a category use the prefix `+@` and to disallow use `-@`. See the [Valkey documentation](https://valkey.io/topics/acl/) for details on the ACL feature. The field is required with `valkey_acl_commands` and `valkey_acl_keys`. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "valkey_acl_categories")

    @valkey_acl_categories.setter
    def valkey_acl_categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "valkey_acl_categories", value)

    @_builtins.property
    @pulumi.getter(name="valkeyAclChannels")
    def valkey_acl_channels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Allows and disallows access to pub/sub channels. Entries are defined as standard glob patterns. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "valkey_acl_channels")

    @valkey_acl_channels.setter
    def valkey_acl_channels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "valkey_acl_channels", value)

    @_builtins.property
    @pulumi.getter(name="valkeyAclCommands")
    def valkey_acl_commands(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Defines rules for individual commands. To allow a command use the prefix `+` and to disallow use `-`. The field is required with `valkey_acl_categories` and `valkey_acl_keys`. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "valkey_acl_commands")

    @valkey_acl_commands.setter
    def valkey_acl_commands(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "valkey_acl_commands", value)

    @_builtins.property
    @pulumi.getter(name="valkeyAclKeys")
    def valkey_acl_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Key access rules. Entries are defined as standard glob patterns. The field is required with `valkey_acl_categories` and `valkey_acl_keys`. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "valkey_acl_keys")

    @valkey_acl_keys.setter
    def valkey_acl_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "valkey_acl_keys", value)


@pulumi.type_token("aiven:index/valkeyUser:ValkeyUser")
class ValkeyUser(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 valkey_acl_categories: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 valkey_acl_channels: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 valkey_acl_commands: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 valkey_acl_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Creates and manages an [Aiven for Valkey™](https://aiven.io/docs/products/valkey) service user.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        # Example user with read-only access for analytics
        read_analytics = aiven.ValkeyUser("read_analytics",
            project=example_project["project"],
            service_name=example_valkey["serviceName"],
            username="example-analytics-reader",
            password=valkey_user_pw,
            valkey_acl_categories=["+@read"],
            valkey_acl_commands=[
                "+get",
                "+set",
                "+mget",
                "+hget",
                "+zrange",
            ],
            valkey_acl_keys=["analytics:*"])
        # Example user with restricted write access for session management
        manage_sessions = aiven.ValkeyUser("manage_sessions",
            project=example_project["project"],
            service_name=example_valkey["serviceName"],
            username="example-session-manager",
            password=valkey_user_pw,
            valkey_acl_categories=[
                "+@write",
                "+@keyspace",
            ],
            valkey_acl_commands=[
                "+set",
                "+del",
                "+expire",
                "-flushall",
                "-flushdb",
            ],
            valkey_acl_keys=["session:*"])
        ```

        ## Import

        ```sh
        $ pulumi import aiven:index/valkeyUser:ValkeyUser example_valkey PROJECT/SERVICE_NAME/USERNAME
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] password: The Valkey service user's password.
        :param pulumi.Input[_builtins.str] project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] username: Name of the Valkey service user. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] valkey_acl_categories: Allow or disallow command categories. To allow a category use the prefix `+@` and to disallow use `-@`. See the [Valkey documentation](https://valkey.io/topics/acl/) for details on the ACL feature. The field is required with `valkey_acl_commands` and `valkey_acl_keys`. Changing this property forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] valkey_acl_channels: Allows and disallows access to pub/sub channels. Entries are defined as standard glob patterns. Changing this property forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] valkey_acl_commands: Defines rules for individual commands. To allow a command use the prefix `+` and to disallow use `-`. The field is required with `valkey_acl_categories` and `valkey_acl_keys`. Changing this property forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] valkey_acl_keys: Key access rules. Entries are defined as standard glob patterns. The field is required with `valkey_acl_categories` and `valkey_acl_keys`. Changing this property forces recreation of the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ValkeyUserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages an [Aiven for Valkey™](https://aiven.io/docs/products/valkey) service user.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        # Example user with read-only access for analytics
        read_analytics = aiven.ValkeyUser("read_analytics",
            project=example_project["project"],
            service_name=example_valkey["serviceName"],
            username="example-analytics-reader",
            password=valkey_user_pw,
            valkey_acl_categories=["+@read"],
            valkey_acl_commands=[
                "+get",
                "+set",
                "+mget",
                "+hget",
                "+zrange",
            ],
            valkey_acl_keys=["analytics:*"])
        # Example user with restricted write access for session management
        manage_sessions = aiven.ValkeyUser("manage_sessions",
            project=example_project["project"],
            service_name=example_valkey["serviceName"],
            username="example-session-manager",
            password=valkey_user_pw,
            valkey_acl_categories=[
                "+@write",
                "+@keyspace",
            ],
            valkey_acl_commands=[
                "+set",
                "+del",
                "+expire",
                "-flushall",
                "-flushdb",
            ],
            valkey_acl_keys=["session:*"])
        ```

        ## Import

        ```sh
        $ pulumi import aiven:index/valkeyUser:ValkeyUser example_valkey PROJECT/SERVICE_NAME/USERNAME
        ```

        :param str resource_name: The name of the resource.
        :param ValkeyUserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ValkeyUserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 valkey_acl_categories: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 valkey_acl_channels: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 valkey_acl_commands: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 valkey_acl_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ValkeyUserArgs.__new__(ValkeyUserArgs)

            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            if username is None and not opts.urn:
                raise TypeError("Missing required property 'username'")
            __props__.__dict__["username"] = username
            __props__.__dict__["valkey_acl_categories"] = valkey_acl_categories
            __props__.__dict__["valkey_acl_channels"] = valkey_acl_channels
            __props__.__dict__["valkey_acl_commands"] = valkey_acl_commands
            __props__.__dict__["valkey_acl_keys"] = valkey_acl_keys
            __props__.__dict__["type"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ValkeyUser, __self__).__init__(
            'aiven:index/valkeyUser:ValkeyUser',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            service_name: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            username: Optional[pulumi.Input[_builtins.str]] = None,
            valkey_acl_categories: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            valkey_acl_channels: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            valkey_acl_commands: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            valkey_acl_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'ValkeyUser':
        """
        Get an existing ValkeyUser resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] password: The Valkey service user's password.
        :param pulumi.Input[_builtins.str] project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] type: User account type, such as primary or regular account.
        :param pulumi.Input[_builtins.str] username: Name of the Valkey service user. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] valkey_acl_categories: Allow or disallow command categories. To allow a category use the prefix `+@` and to disallow use `-@`. See the [Valkey documentation](https://valkey.io/topics/acl/) for details on the ACL feature. The field is required with `valkey_acl_commands` and `valkey_acl_keys`. Changing this property forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] valkey_acl_channels: Allows and disallows access to pub/sub channels. Entries are defined as standard glob patterns. Changing this property forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] valkey_acl_commands: Defines rules for individual commands. To allow a command use the prefix `+` and to disallow use `-`. The field is required with `valkey_acl_categories` and `valkey_acl_keys`. Changing this property forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] valkey_acl_keys: Key access rules. Entries are defined as standard glob patterns. The field is required with `valkey_acl_categories` and `valkey_acl_keys`. Changing this property forces recreation of the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ValkeyUserState.__new__(_ValkeyUserState)

        __props__.__dict__["password"] = password
        __props__.__dict__["project"] = project
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["type"] = type
        __props__.__dict__["username"] = username
        __props__.__dict__["valkey_acl_categories"] = valkey_acl_categories
        __props__.__dict__["valkey_acl_channels"] = valkey_acl_channels
        __props__.__dict__["valkey_acl_commands"] = valkey_acl_commands
        __props__.__dict__["valkey_acl_keys"] = valkey_acl_keys
        return ValkeyUser(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[_builtins.str]:
        """
        The Valkey service user's password.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        User account type, such as primary or regular account.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the Valkey service user. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="valkeyAclCategories")
    def valkey_acl_categories(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Allow or disallow command categories. To allow a category use the prefix `+@` and to disallow use `-@`. See the [Valkey documentation](https://valkey.io/topics/acl/) for details on the ACL feature. The field is required with `valkey_acl_commands` and `valkey_acl_keys`. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "valkey_acl_categories")

    @_builtins.property
    @pulumi.getter(name="valkeyAclChannels")
    def valkey_acl_channels(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Allows and disallows access to pub/sub channels. Entries are defined as standard glob patterns. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "valkey_acl_channels")

    @_builtins.property
    @pulumi.getter(name="valkeyAclCommands")
    def valkey_acl_commands(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Defines rules for individual commands. To allow a command use the prefix `+` and to disallow use `-`. The field is required with `valkey_acl_categories` and `valkey_acl_keys`. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "valkey_acl_commands")

    @_builtins.property
    @pulumi.getter(name="valkeyAclKeys")
    def valkey_acl_keys(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Key access rules. Entries are defined as standard glob patterns. The field is required with `valkey_acl_categories` and `valkey_acl_keys`. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "valkey_acl_keys")

