from prowler.lib.check.models import Check, Check_Report_AWS
from prowler.providers.aws.services.cloudtrail.cloudtrail_client import (
    cloudtrail_client,
)


class cloudtrail_insights_exist(Check):
    def execute(self):
        findings = []
        if cloudtrail_client.trails is not None:
            for trail in cloudtrail_client.trails.values():
                if trail.is_logging:
                    report = Check_Report_AWS(metadata=self.metadata(), resource=trail)
                    report.region = trail.home_region
                    report.status = "FAIL"
                    report.status_extended = f"Trail {trail.name} does not have insight selectors and it is logging."
                    if trail.has_insight_selectors:
                        report.status = "PASS"
                        report.status_extended = f"Trail {trail.name} has insight selectors and it is logging."
                    findings.append(report)
        return findings
