
<div align="center">
<h1>
    IAToolkit
</h1>

  <p><strong>The Open-Source Framework for Building AI Chatbots on Your Private Data.</strong></p>
<h4>
  <a href="https://www.iatoolkit.com" target="_blank" style="text-decoration: none; color: inherit;">
    www.iatoolkit.com
  </a>
</h4>
</div>

IAToolkit is a comprehensive, Python open-source framework designed for building enterprise-grade 
AI chatbots and conversational applications. It bridges the gap between the power of 
Large Language Models (LLMs) and the valuable, 
private data locked within your organization's databases and documents.

With IAToolkit, you can build production-ready, context-aware chatbots and agents that 
can query relational databases, perform semantic searches on documents, 
and connect to your internal APIs in minutes.

Create secure, branded chat interfaces that can reason over your data, answer questions, and execute custom business logic, 
all powered by leading models from OpenAI, Google Gemini, and more.


## 🚀 Key Features

* **🔗 Unified Data Connection**
    * **Natural Language to SQL**: Let your chatbot query relational databases (PostgreSQL, MySQL, SQLite) using everyday language.
    * **Semantic Document Search**: Automatically chunk, embed, and search across your private documents (PDFs, Word, etc.) to provide contextually accurate answers.

* **🏢 Enterprise-Ready Multi-Tenancy**
    * Deploy isolated "Company" modules, each with its own data, tools, and context. 
    * Perfect for SaaS products or internal departmental agents.

* **🎨 Fully Brandable UI**
    * Customize the look and feel for each "Company" with its own logos, colors, and even language settings (i18n).
    * Provides a white-labeled experience for your users.

* **🧠 LLM Agnostic**
    * Switch between **OpenAI (GPT-*)** and **Google (Gemini-*)** with a single line change in your configuration. 
    * No code refactoring needed.

* **🛠️ Developer-First Experience**
    * Built with a clean **Dependency Injection** architecture.  
    * High-quality code base with **90%+ test coverage**.

* **🔒 Security & Observability Built-In**
    * Comes with integrated user authentication, API keys, and secure session handling out of the box.  
    * Full traceability with detailed logging of all queries, function calls, token usage, and costs.
## ⚡ Quick Start: Try our 'hello world' example

Ready to see it in action? Our Quickstart Guide will walk you through downloading, configuring, and launching your first AI assistant in just a few minutes. 
It's the best way to experience the toolkit's capabilities firsthand.

## 🤝 Contributing

We welcome contributions! Whether it's adding a new feature, improving documentation, or fixing a bug, 
please feel free to open a pull request.

## 📄 License

IAToolkit is open-source and licensed under the [MIT License](LICENSE).