# Generated by Django 4.2.16 on 2024-11-09 21:23

# Django
import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("afat", "0023_the_big_rename"),
    ]

    operations = [
        migrations.CreateModel(
            name="Doctrine",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="Short name to identify this doctrine",
                        max_length=255,
                        unique=True,
                        verbose_name="Name",
                    ),
                ),
                (
                    "notes",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="You can add notes about this doctrine here if you want. (optional)",
                        verbose_name="Notes",
                    ),
                ),
                (
                    "is_enabled",
                    models.BooleanField(
                        db_index=True,
                        default=True,
                        help_text="Whether this doctrine is enabled or not.",
                        verbose_name="Is enabled",
                    ),
                ),
            ],
            options={
                "verbose_name": "Doctrine",
                "verbose_name_plural": "Doctrines",
                "default_permissions": (),
            },
        ),
        migrations.CreateModel(
            name="Setting",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "default_fatlink_expiry_time",
                    models.PositiveIntegerField(
                        default=60,
                        help_text="Default expiry time for clickable FAT links in minutes. (Default: 60 minutes)",
                        verbose_name="Default FAT link expiry time",
                    ),
                ),
                (
                    "default_fatlink_reopen_grace_time",
                    models.PositiveIntegerField(
                        default=60,
                        help_text="Default time in minutes a FAT link can be re-opened after it is expired. (Default: 60 minutes)",
                        verbose_name="Default FAT link reopen grace time",
                    ),
                ),
                (
                    "default_fatlink_reopen_duration",
                    models.PositiveIntegerField(
                        default=60,
                        help_text="Default time in minutes a FAT link is re-opened for. (Default: 60 minutes)",
                        verbose_name="Default FAT link reopen duration",
                    ),
                ),
                (
                    "default_log_duration",
                    models.PositiveIntegerField(
                        default=60,
                        help_text="Default time in days a log entry is kept. (Default: 60 days)",
                        verbose_name="Default log duration",
                    ),
                ),
                (
                    "use_doctrines_from_fittings_module",
                    models.BooleanField(
                        db_index=True,
                        default=False,
                        help_text="Whether to use the doctrines from the Fittings modules in the doctrine dropdown. Note: The fittings module needs to be installed for this.",
                        verbose_name="Use doctrines from fittings module",
                    ),
                ),
            ],
            options={
                "verbose_name": "Setting",
                "verbose_name_plural": "Settings",
                "default_permissions": (),
            },
        ),
        migrations.AddField(
            model_name="fatlink",
            name="doctrine",
            field=models.CharField(
                blank=True,
                default="",
                help_text="The FAT link doctrine",
                max_length=254,
            ),
        ),
        migrations.AddField(
            model_name="fatlink",
            name="fleet_type",
            field=models.CharField(
                blank=True,
                default="",
                help_text="The FAT link fleet type, if it's set",
                max_length=254,
            ),
        ),
        migrations.AlterField(
            model_name="fatlink",
            name="link_type",
            field=models.ForeignKey(
                help_text="Deprecated setting, will be removed in a future version …",
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="+",
                to="afat.fleettype",
            ),
        ),
    ]
