# Generated by Django 4.2.21 on 2025-05-18 18:20

# Django
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("eveuniverse", "0010_alter_eveindustryactivityduration_eve_type_and_more"),
        ("afat", "0025_fat_alliance_eve_id_fat_corporation_eve_id"),
    ]

    operations = [
        migrations.CreateModel(
            name="FatsInTimeFilter",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="The filter name that is shown to the admin.",
                        max_length=500,
                    ),
                ),
                (
                    "description",
                    models.CharField(
                        help_text="The filter description that is shown to end users.",
                        max_length=500,
                    ),
                ),
                (
                    "days",
                    models.IntegerField(
                        default=30,
                        help_text="The number of days to look back for FATs.",
                    ),
                ),
                (
                    "fats_needed",
                    models.IntegerField(
                        default=10,
                        help_text="The number of FATs needed to pass the filter.",
                    ),
                ),
                (
                    "fleet_types",
                    models.ManyToManyField(
                        blank=True,
                        help_text="Any of the selected fleet types are needed to pass the filter.",
                        to="afat.fleettype",
                    ),
                ),
                (
                    "ship_classes",
                    models.ManyToManyField(
                        blank=True,
                        help_text="Any of the selected ship classes are needed to pass the filter.",
                        limit_choices_to={"eve_group__eve_category_id": 6},
                        to="eveuniverse.evetype",
                    ),
                ),
            ],
            options={
                "verbose_name": "Smart Filter: FATs in time period",
                "verbose_name_plural": "Smart Filter: FATs in time period",
            },
        ),
    ]
