"""
Test checks for installed modules we might use
"""

# Django
from django.test import override_settings

# Alliance Auth AFAT
from afat.app_settings import debug_enabled
from afat.tests import BaseTestCase


class TestDebugCheck(BaseTestCase):
    """
    Test if debug is enabled
    """

    @override_settings(DEBUG=True)
    def test_debug_enabled_with_debug_true(self) -> None:
        """
        Test debug_enabled with DEBUG = True

        :return:
        :rtype:
        """

        self.assertTrue(debug_enabled())

    @override_settings(DEBUG=False)
    def test_debug_enabled_with_debug_false(self) -> None:
        """
        Test debug_enabled with DEBUG = False

        :return:
        :rtype:
        """

        self.assertFalse(debug_enabled())
