# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AccountAuthenticationArgs', 'AccountAuthentication']

@pulumi.input_type
class AccountAuthenticationArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 auto_join_team_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 saml_certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 saml_digest_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 saml_entity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 saml_field_mapping: Optional[pulumi.Input['AccountAuthenticationSamlFieldMappingArgs']] = None,
                 saml_idp_login_allowed: Optional[pulumi.Input[_builtins.bool]] = None,
                 saml_idp_url: Optional[pulumi.Input[_builtins.str]] = None,
                 saml_signature_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 saml_variant: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AccountAuthentication resource.
        :param pulumi.Input[_builtins.str] account_id: The unique id of the account.
        :param pulumi.Input[_builtins.str] type: The account authentication type. The possible values are `internal` and `saml`.
        :param pulumi.Input[_builtins.str] auto_join_team_id: Team ID
        :param pulumi.Input[_builtins.bool] enabled: Status of account authentication method. The default value is `false`.
        :param pulumi.Input[_builtins.str] name: The name of the account authentication.
        :param pulumi.Input[_builtins.str] saml_certificate: SAML Certificate
        :param pulumi.Input[_builtins.str] saml_digest_algorithm: Digest algorithm. This is an advanced option that typically does not need to be set.
        :param pulumi.Input[_builtins.str] saml_entity_id: SAML Entity id
        :param pulumi.Input['AccountAuthenticationSamlFieldMappingArgs'] saml_field_mapping: Map IdP fields
        :param pulumi.Input[_builtins.bool] saml_idp_login_allowed: Set to 'true' to enable IdP initiated login
        :param pulumi.Input[_builtins.str] saml_idp_url: SAML Idp URL
        :param pulumi.Input[_builtins.str] saml_signature_algorithm: Signature algorithm. This is an advanced option that typically does not need to be set.
        :param pulumi.Input[_builtins.str] saml_variant: SAML server variant
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "type", type)
        if auto_join_team_id is not None:
            pulumi.set(__self__, "auto_join_team_id", auto_join_team_id)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if saml_certificate is not None:
            pulumi.set(__self__, "saml_certificate", saml_certificate)
        if saml_digest_algorithm is not None:
            pulumi.set(__self__, "saml_digest_algorithm", saml_digest_algorithm)
        if saml_entity_id is not None:
            pulumi.set(__self__, "saml_entity_id", saml_entity_id)
        if saml_field_mapping is not None:
            pulumi.set(__self__, "saml_field_mapping", saml_field_mapping)
        if saml_idp_login_allowed is not None:
            pulumi.set(__self__, "saml_idp_login_allowed", saml_idp_login_allowed)
        if saml_idp_url is not None:
            pulumi.set(__self__, "saml_idp_url", saml_idp_url)
        if saml_signature_algorithm is not None:
            pulumi.set(__self__, "saml_signature_algorithm", saml_signature_algorithm)
        if saml_variant is not None:
            pulumi.set(__self__, "saml_variant", saml_variant)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        """
        The unique id of the account.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The account authentication type. The possible values are `internal` and `saml`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="autoJoinTeamId")
    def auto_join_team_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Team ID
        """
        return pulumi.get(self, "auto_join_team_id")

    @auto_join_team_id.setter
    def auto_join_team_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_join_team_id", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Status of account authentication method. The default value is `false`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the account authentication.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="samlCertificate")
    def saml_certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SAML Certificate
        """
        return pulumi.get(self, "saml_certificate")

    @saml_certificate.setter
    def saml_certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "saml_certificate", value)

    @_builtins.property
    @pulumi.getter(name="samlDigestAlgorithm")
    def saml_digest_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Digest algorithm. This is an advanced option that typically does not need to be set.
        """
        return pulumi.get(self, "saml_digest_algorithm")

    @saml_digest_algorithm.setter
    def saml_digest_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "saml_digest_algorithm", value)

    @_builtins.property
    @pulumi.getter(name="samlEntityId")
    def saml_entity_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SAML Entity id
        """
        return pulumi.get(self, "saml_entity_id")

    @saml_entity_id.setter
    def saml_entity_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "saml_entity_id", value)

    @_builtins.property
    @pulumi.getter(name="samlFieldMapping")
    def saml_field_mapping(self) -> Optional[pulumi.Input['AccountAuthenticationSamlFieldMappingArgs']]:
        """
        Map IdP fields
        """
        return pulumi.get(self, "saml_field_mapping")

    @saml_field_mapping.setter
    def saml_field_mapping(self, value: Optional[pulumi.Input['AccountAuthenticationSamlFieldMappingArgs']]):
        pulumi.set(self, "saml_field_mapping", value)

    @_builtins.property
    @pulumi.getter(name="samlIdpLoginAllowed")
    def saml_idp_login_allowed(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to 'true' to enable IdP initiated login
        """
        return pulumi.get(self, "saml_idp_login_allowed")

    @saml_idp_login_allowed.setter
    def saml_idp_login_allowed(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "saml_idp_login_allowed", value)

    @_builtins.property
    @pulumi.getter(name="samlIdpUrl")
    def saml_idp_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SAML Idp URL
        """
        return pulumi.get(self, "saml_idp_url")

    @saml_idp_url.setter
    def saml_idp_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "saml_idp_url", value)

    @_builtins.property
    @pulumi.getter(name="samlSignatureAlgorithm")
    def saml_signature_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Signature algorithm. This is an advanced option that typically does not need to be set.
        """
        return pulumi.get(self, "saml_signature_algorithm")

    @saml_signature_algorithm.setter
    def saml_signature_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "saml_signature_algorithm", value)

    @_builtins.property
    @pulumi.getter(name="samlVariant")
    def saml_variant(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SAML server variant
        """
        return pulumi.get(self, "saml_variant")

    @saml_variant.setter
    def saml_variant(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "saml_variant", value)


@pulumi.input_type
class _AccountAuthenticationState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 authentication_id: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_join_team_id: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 saml_acs_url: Optional[pulumi.Input[_builtins.str]] = None,
                 saml_certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 saml_digest_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 saml_entity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 saml_field_mapping: Optional[pulumi.Input['AccountAuthenticationSamlFieldMappingArgs']] = None,
                 saml_idp_login_allowed: Optional[pulumi.Input[_builtins.bool]] = None,
                 saml_idp_url: Optional[pulumi.Input[_builtins.str]] = None,
                 saml_metadata_url: Optional[pulumi.Input[_builtins.str]] = None,
                 saml_signature_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 saml_variant: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AccountAuthentication resources.
        :param pulumi.Input[_builtins.str] account_id: The unique id of the account.
        :param pulumi.Input[_builtins.str] authentication_id: Account authentication id
        :param pulumi.Input[_builtins.str] auto_join_team_id: Team ID
        :param pulumi.Input[_builtins.str] create_time: Time of creation
        :param pulumi.Input[_builtins.bool] enabled: Status of account authentication method. The default value is `false`.
        :param pulumi.Input[_builtins.str] name: The name of the account authentication.
        :param pulumi.Input[_builtins.str] saml_acs_url: SAML Assertion Consumer Service URL
        :param pulumi.Input[_builtins.str] saml_certificate: SAML Certificate
        :param pulumi.Input[_builtins.str] saml_digest_algorithm: Digest algorithm. This is an advanced option that typically does not need to be set.
        :param pulumi.Input[_builtins.str] saml_entity_id: SAML Entity id
        :param pulumi.Input['AccountAuthenticationSamlFieldMappingArgs'] saml_field_mapping: Map IdP fields
        :param pulumi.Input[_builtins.bool] saml_idp_login_allowed: Set to 'true' to enable IdP initiated login
        :param pulumi.Input[_builtins.str] saml_idp_url: SAML Idp URL
        :param pulumi.Input[_builtins.str] saml_metadata_url: SAML Metadata URL
        :param pulumi.Input[_builtins.str] saml_signature_algorithm: Signature algorithm. This is an advanced option that typically does not need to be set.
        :param pulumi.Input[_builtins.str] saml_variant: SAML server variant
        :param pulumi.Input[_builtins.str] type: The account authentication type. The possible values are `internal` and `saml`.
        :param pulumi.Input[_builtins.str] update_time: Time of last update
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if authentication_id is not None:
            pulumi.set(__self__, "authentication_id", authentication_id)
        if auto_join_team_id is not None:
            pulumi.set(__self__, "auto_join_team_id", auto_join_team_id)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if saml_acs_url is not None:
            pulumi.set(__self__, "saml_acs_url", saml_acs_url)
        if saml_certificate is not None:
            pulumi.set(__self__, "saml_certificate", saml_certificate)
        if saml_digest_algorithm is not None:
            pulumi.set(__self__, "saml_digest_algorithm", saml_digest_algorithm)
        if saml_entity_id is not None:
            pulumi.set(__self__, "saml_entity_id", saml_entity_id)
        if saml_field_mapping is not None:
            pulumi.set(__self__, "saml_field_mapping", saml_field_mapping)
        if saml_idp_login_allowed is not None:
            pulumi.set(__self__, "saml_idp_login_allowed", saml_idp_login_allowed)
        if saml_idp_url is not None:
            pulumi.set(__self__, "saml_idp_url", saml_idp_url)
        if saml_metadata_url is not None:
            pulumi.set(__self__, "saml_metadata_url", saml_metadata_url)
        if saml_signature_algorithm is not None:
            pulumi.set(__self__, "saml_signature_algorithm", saml_signature_algorithm)
        if saml_variant is not None:
            pulumi.set(__self__, "saml_variant", saml_variant)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique id of the account.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="authenticationId")
    def authentication_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Account authentication id
        """
        return pulumi.get(self, "authentication_id")

    @authentication_id.setter
    def authentication_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authentication_id", value)

    @_builtins.property
    @pulumi.getter(name="autoJoinTeamId")
    def auto_join_team_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Team ID
        """
        return pulumi.get(self, "auto_join_team_id")

    @auto_join_team_id.setter
    def auto_join_team_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_join_team_id", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time of creation
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Status of account authentication method. The default value is `false`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the account authentication.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="samlAcsUrl")
    def saml_acs_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SAML Assertion Consumer Service URL
        """
        return pulumi.get(self, "saml_acs_url")

    @saml_acs_url.setter
    def saml_acs_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "saml_acs_url", value)

    @_builtins.property
    @pulumi.getter(name="samlCertificate")
    def saml_certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SAML Certificate
        """
        return pulumi.get(self, "saml_certificate")

    @saml_certificate.setter
    def saml_certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "saml_certificate", value)

    @_builtins.property
    @pulumi.getter(name="samlDigestAlgorithm")
    def saml_digest_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Digest algorithm. This is an advanced option that typically does not need to be set.
        """
        return pulumi.get(self, "saml_digest_algorithm")

    @saml_digest_algorithm.setter
    def saml_digest_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "saml_digest_algorithm", value)

    @_builtins.property
    @pulumi.getter(name="samlEntityId")
    def saml_entity_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SAML Entity id
        """
        return pulumi.get(self, "saml_entity_id")

    @saml_entity_id.setter
    def saml_entity_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "saml_entity_id", value)

    @_builtins.property
    @pulumi.getter(name="samlFieldMapping")
    def saml_field_mapping(self) -> Optional[pulumi.Input['AccountAuthenticationSamlFieldMappingArgs']]:
        """
        Map IdP fields
        """
        return pulumi.get(self, "saml_field_mapping")

    @saml_field_mapping.setter
    def saml_field_mapping(self, value: Optional[pulumi.Input['AccountAuthenticationSamlFieldMappingArgs']]):
        pulumi.set(self, "saml_field_mapping", value)

    @_builtins.property
    @pulumi.getter(name="samlIdpLoginAllowed")
    def saml_idp_login_allowed(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to 'true' to enable IdP initiated login
        """
        return pulumi.get(self, "saml_idp_login_allowed")

    @saml_idp_login_allowed.setter
    def saml_idp_login_allowed(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "saml_idp_login_allowed", value)

    @_builtins.property
    @pulumi.getter(name="samlIdpUrl")
    def saml_idp_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SAML Idp URL
        """
        return pulumi.get(self, "saml_idp_url")

    @saml_idp_url.setter
    def saml_idp_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "saml_idp_url", value)

    @_builtins.property
    @pulumi.getter(name="samlMetadataUrl")
    def saml_metadata_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SAML Metadata URL
        """
        return pulumi.get(self, "saml_metadata_url")

    @saml_metadata_url.setter
    def saml_metadata_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "saml_metadata_url", value)

    @_builtins.property
    @pulumi.getter(name="samlSignatureAlgorithm")
    def saml_signature_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Signature algorithm. This is an advanced option that typically does not need to be set.
        """
        return pulumi.get(self, "saml_signature_algorithm")

    @saml_signature_algorithm.setter
    def saml_signature_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "saml_signature_algorithm", value)

    @_builtins.property
    @pulumi.getter(name="samlVariant")
    def saml_variant(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SAML server variant
        """
        return pulumi.get(self, "saml_variant")

    @saml_variant.setter
    def saml_variant(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "saml_variant", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The account authentication type. The possible values are `internal` and `saml`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time of last update
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("aiven:index/accountAuthentication:AccountAuthentication")
class AccountAuthentication(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_join_team_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 saml_certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 saml_digest_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 saml_entity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 saml_field_mapping: Optional[pulumi.Input[Union['AccountAuthenticationSamlFieldMappingArgs', 'AccountAuthenticationSamlFieldMappingArgsDict']]] = None,
                 saml_idp_login_allowed: Optional[pulumi.Input[_builtins.bool]] = None,
                 saml_idp_url: Optional[pulumi.Input[_builtins.str]] = None,
                 saml_signature_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 saml_variant: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages an authentication method.

        > **This resource is deprecated**
        To set up an identity provider as an authentication method for your organization,
        [use the Aiven Console](https://aiven.io/docs/platform/howto/saml/add-identity-providers).
        It guides you through the steps and explains the settings.

        ## Import

        ```sh
        $ pulumi import aiven:index/accountAuthentication:AccountAuthentication foo ACCOUNT_ID/AUTHENTICATION_ID
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: The unique id of the account.
        :param pulumi.Input[_builtins.str] auto_join_team_id: Team ID
        :param pulumi.Input[_builtins.bool] enabled: Status of account authentication method. The default value is `false`.
        :param pulumi.Input[_builtins.str] name: The name of the account authentication.
        :param pulumi.Input[_builtins.str] saml_certificate: SAML Certificate
        :param pulumi.Input[_builtins.str] saml_digest_algorithm: Digest algorithm. This is an advanced option that typically does not need to be set.
        :param pulumi.Input[_builtins.str] saml_entity_id: SAML Entity id
        :param pulumi.Input[Union['AccountAuthenticationSamlFieldMappingArgs', 'AccountAuthenticationSamlFieldMappingArgsDict']] saml_field_mapping: Map IdP fields
        :param pulumi.Input[_builtins.bool] saml_idp_login_allowed: Set to 'true' to enable IdP initiated login
        :param pulumi.Input[_builtins.str] saml_idp_url: SAML Idp URL
        :param pulumi.Input[_builtins.str] saml_signature_algorithm: Signature algorithm. This is an advanced option that typically does not need to be set.
        :param pulumi.Input[_builtins.str] saml_variant: SAML server variant
        :param pulumi.Input[_builtins.str] type: The account authentication type. The possible values are `internal` and `saml`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccountAuthenticationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages an authentication method.

        > **This resource is deprecated**
        To set up an identity provider as an authentication method for your organization,
        [use the Aiven Console](https://aiven.io/docs/platform/howto/saml/add-identity-providers).
        It guides you through the steps and explains the settings.

        ## Import

        ```sh
        $ pulumi import aiven:index/accountAuthentication:AccountAuthentication foo ACCOUNT_ID/AUTHENTICATION_ID
        ```

        :param str resource_name: The name of the resource.
        :param AccountAuthenticationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccountAuthenticationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_join_team_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 saml_certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 saml_digest_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 saml_entity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 saml_field_mapping: Optional[pulumi.Input[Union['AccountAuthenticationSamlFieldMappingArgs', 'AccountAuthenticationSamlFieldMappingArgsDict']]] = None,
                 saml_idp_login_allowed: Optional[pulumi.Input[_builtins.bool]] = None,
                 saml_idp_url: Optional[pulumi.Input[_builtins.str]] = None,
                 saml_signature_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 saml_variant: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccountAuthenticationArgs.__new__(AccountAuthenticationArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["auto_join_team_id"] = auto_join_team_id
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["name"] = name
            __props__.__dict__["saml_certificate"] = saml_certificate
            __props__.__dict__["saml_digest_algorithm"] = saml_digest_algorithm
            __props__.__dict__["saml_entity_id"] = saml_entity_id
            __props__.__dict__["saml_field_mapping"] = saml_field_mapping
            __props__.__dict__["saml_idp_login_allowed"] = saml_idp_login_allowed
            __props__.__dict__["saml_idp_url"] = saml_idp_url
            __props__.__dict__["saml_signature_algorithm"] = saml_signature_algorithm
            __props__.__dict__["saml_variant"] = saml_variant
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["authentication_id"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["saml_acs_url"] = None
            __props__.__dict__["saml_metadata_url"] = None
            __props__.__dict__["update_time"] = None
        super(AccountAuthentication, __self__).__init__(
            'aiven:index/accountAuthentication:AccountAuthentication',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            authentication_id: Optional[pulumi.Input[_builtins.str]] = None,
            auto_join_team_id: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            saml_acs_url: Optional[pulumi.Input[_builtins.str]] = None,
            saml_certificate: Optional[pulumi.Input[_builtins.str]] = None,
            saml_digest_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
            saml_entity_id: Optional[pulumi.Input[_builtins.str]] = None,
            saml_field_mapping: Optional[pulumi.Input[Union['AccountAuthenticationSamlFieldMappingArgs', 'AccountAuthenticationSamlFieldMappingArgsDict']]] = None,
            saml_idp_login_allowed: Optional[pulumi.Input[_builtins.bool]] = None,
            saml_idp_url: Optional[pulumi.Input[_builtins.str]] = None,
            saml_metadata_url: Optional[pulumi.Input[_builtins.str]] = None,
            saml_signature_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
            saml_variant: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'AccountAuthentication':
        """
        Get an existing AccountAuthentication resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: The unique id of the account.
        :param pulumi.Input[_builtins.str] authentication_id: Account authentication id
        :param pulumi.Input[_builtins.str] auto_join_team_id: Team ID
        :param pulumi.Input[_builtins.str] create_time: Time of creation
        :param pulumi.Input[_builtins.bool] enabled: Status of account authentication method. The default value is `false`.
        :param pulumi.Input[_builtins.str] name: The name of the account authentication.
        :param pulumi.Input[_builtins.str] saml_acs_url: SAML Assertion Consumer Service URL
        :param pulumi.Input[_builtins.str] saml_certificate: SAML Certificate
        :param pulumi.Input[_builtins.str] saml_digest_algorithm: Digest algorithm. This is an advanced option that typically does not need to be set.
        :param pulumi.Input[_builtins.str] saml_entity_id: SAML Entity id
        :param pulumi.Input[Union['AccountAuthenticationSamlFieldMappingArgs', 'AccountAuthenticationSamlFieldMappingArgsDict']] saml_field_mapping: Map IdP fields
        :param pulumi.Input[_builtins.bool] saml_idp_login_allowed: Set to 'true' to enable IdP initiated login
        :param pulumi.Input[_builtins.str] saml_idp_url: SAML Idp URL
        :param pulumi.Input[_builtins.str] saml_metadata_url: SAML Metadata URL
        :param pulumi.Input[_builtins.str] saml_signature_algorithm: Signature algorithm. This is an advanced option that typically does not need to be set.
        :param pulumi.Input[_builtins.str] saml_variant: SAML server variant
        :param pulumi.Input[_builtins.str] type: The account authentication type. The possible values are `internal` and `saml`.
        :param pulumi.Input[_builtins.str] update_time: Time of last update
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccountAuthenticationState.__new__(_AccountAuthenticationState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["authentication_id"] = authentication_id
        __props__.__dict__["auto_join_team_id"] = auto_join_team_id
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["saml_acs_url"] = saml_acs_url
        __props__.__dict__["saml_certificate"] = saml_certificate
        __props__.__dict__["saml_digest_algorithm"] = saml_digest_algorithm
        __props__.__dict__["saml_entity_id"] = saml_entity_id
        __props__.__dict__["saml_field_mapping"] = saml_field_mapping
        __props__.__dict__["saml_idp_login_allowed"] = saml_idp_login_allowed
        __props__.__dict__["saml_idp_url"] = saml_idp_url
        __props__.__dict__["saml_metadata_url"] = saml_metadata_url
        __props__.__dict__["saml_signature_algorithm"] = saml_signature_algorithm
        __props__.__dict__["saml_variant"] = saml_variant
        __props__.__dict__["type"] = type
        __props__.__dict__["update_time"] = update_time
        return AccountAuthentication(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique id of the account.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="authenticationId")
    def authentication_id(self) -> pulumi.Output[_builtins.str]:
        """
        Account authentication id
        """
        return pulumi.get(self, "authentication_id")

    @_builtins.property
    @pulumi.getter(name="autoJoinTeamId")
    def auto_join_team_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Team ID
        """
        return pulumi.get(self, "auto_join_team_id")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Time of creation
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Status of account authentication method. The default value is `false`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the account authentication.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="samlAcsUrl")
    def saml_acs_url(self) -> pulumi.Output[_builtins.str]:
        """
        SAML Assertion Consumer Service URL
        """
        return pulumi.get(self, "saml_acs_url")

    @_builtins.property
    @pulumi.getter(name="samlCertificate")
    def saml_certificate(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        SAML Certificate
        """
        return pulumi.get(self, "saml_certificate")

    @_builtins.property
    @pulumi.getter(name="samlDigestAlgorithm")
    def saml_digest_algorithm(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Digest algorithm. This is an advanced option that typically does not need to be set.
        """
        return pulumi.get(self, "saml_digest_algorithm")

    @_builtins.property
    @pulumi.getter(name="samlEntityId")
    def saml_entity_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        SAML Entity id
        """
        return pulumi.get(self, "saml_entity_id")

    @_builtins.property
    @pulumi.getter(name="samlFieldMapping")
    def saml_field_mapping(self) -> pulumi.Output[Optional['outputs.AccountAuthenticationSamlFieldMapping']]:
        """
        Map IdP fields
        """
        return pulumi.get(self, "saml_field_mapping")

    @_builtins.property
    @pulumi.getter(name="samlIdpLoginAllowed")
    def saml_idp_login_allowed(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Set to 'true' to enable IdP initiated login
        """
        return pulumi.get(self, "saml_idp_login_allowed")

    @_builtins.property
    @pulumi.getter(name="samlIdpUrl")
    def saml_idp_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        SAML Idp URL
        """
        return pulumi.get(self, "saml_idp_url")

    @_builtins.property
    @pulumi.getter(name="samlMetadataUrl")
    def saml_metadata_url(self) -> pulumi.Output[_builtins.str]:
        """
        SAML Metadata URL
        """
        return pulumi.get(self, "saml_metadata_url")

    @_builtins.property
    @pulumi.getter(name="samlSignatureAlgorithm")
    def saml_signature_algorithm(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Signature algorithm. This is an advanced option that typically does not need to be set.
        """
        return pulumi.get(self, "saml_signature_algorithm")

    @_builtins.property
    @pulumi.getter(name="samlVariant")
    def saml_variant(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        SAML server variant
        """
        return pulumi.get(self, "saml_variant")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The account authentication type. The possible values are `internal` and `saml`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        Time of last update
        """
        return pulumi.get(self, "update_time")

