# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AzurePrivatelinkConnectionApprovalArgs', 'AzurePrivatelinkConnectionApproval']

@pulumi.input_type
class AzurePrivatelinkConnectionApprovalArgs:
    def __init__(__self__, *,
                 project: pulumi.Input[_builtins.str],
                 service_name: pulumi.Input[_builtins.str],
                 endpoint_ip_address: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AzurePrivatelinkConnectionApproval resource.
        :param pulumi.Input[_builtins.str] project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] endpoint_ip_address: IP address of Azure private endpoint.
        """
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "service_name", service_name)
        if endpoint_ip_address is not None:
            pulumi.set(__self__, "endpoint_ip_address", endpoint_ip_address)

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter(name="endpointIpAddress")
    def endpoint_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IP address of Azure private endpoint.
        """
        return pulumi.get(self, "endpoint_ip_address")

    @endpoint_ip_address.setter
    def endpoint_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint_ip_address", value)


@pulumi.input_type
class _AzurePrivatelinkConnectionApprovalState:
    def __init__(__self__, *,
                 endpoint_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 privatelink_connection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AzurePrivatelinkConnectionApproval resources.
        :param pulumi.Input[_builtins.str] endpoint_ip_address: IP address of Azure private endpoint.
        :param pulumi.Input[_builtins.str] privatelink_connection_id: The ID of the Private Link connection.
        :param pulumi.Input[_builtins.str] project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] state: The state of the Private Link connection.
        """
        if endpoint_ip_address is not None:
            pulumi.set(__self__, "endpoint_ip_address", endpoint_ip_address)
        if privatelink_connection_id is not None:
            pulumi.set(__self__, "privatelink_connection_id", privatelink_connection_id)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="endpointIpAddress")
    def endpoint_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IP address of Azure private endpoint.
        """
        return pulumi.get(self, "endpoint_ip_address")

    @endpoint_ip_address.setter
    def endpoint_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="privatelinkConnectionId")
    def privatelink_connection_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Private Link connection.
        """
        return pulumi.get(self, "privatelink_connection_id")

    @privatelink_connection_id.setter
    def privatelink_connection_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "privatelink_connection_id", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The state of the Private Link connection.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)


@pulumi.type_token("aiven:index/azurePrivatelinkConnectionApproval:AzurePrivatelinkConnectionApproval")
class AzurePrivatelinkConnectionApproval(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 endpoint_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Approves an Azure Private Link connection to an Aiven service with an associated endpoint IP.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven
        import pulumi_azurerm as azurerm

        static_ips = []
        for range in [{"value": i} for i in range(0, 2)]:
            static_ips.append(aiven.StaticIp(f"static_ips-{range['value']}",
                project=project_id,
                cloud_name=region))
        default = aiven.Pg("default",
            service_name="postgres",
            project=aiven_project_id,
            project_vpc_id=aiven_project_vpc_id,
            cloud_name=region,
            plan=plan,
            static_ips=[sip.static_ip_address_id for sip in static_ips],
            pg_user_config={
                "pg_version": "13",
                "static_ips": True,
                "privatelink_access": {
                    "pg": True,
                    "pgbouncer": True,
                },
            })
        privatelink = aiven.AzurePrivatelink("privatelink",
            project=aiven_project_id,
            service_name=default.name,
            user_subscription_ids=[azure_subscription_id])
        endpoint = azurerm.index.PrivateEndpoint("endpoint",
            name=postgres-endpoint,
            location=region,
            resource_group_name=azure_resource_group.name,
            subnet_id=azure_subnet_id,
            private_service_connection=[{
                name: default.name,
                privateConnectionResourceId: privatelink.azure_service_id,
                isManualConnection: True,
                requestMessage: default.name,
            }],
            opts = pulumi.ResourceOptions(depends_on=[privatelink]))
        approval = aiven.AzurePrivatelinkConnectionApproval("approval",
            project=aiven_project_id,
            service_name=default.service_name,
            endpoint_ip_address=endpoint["privateServiceConnection"][0]["privateIpAddress"])
        ```

        ## Import

        ```sh
        $ pulumi import aiven:index/azurePrivatelinkConnectionApproval:AzurePrivatelinkConnectionApproval approval PROJECT/SERVICE_NAME
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] endpoint_ip_address: IP address of Azure private endpoint.
        :param pulumi.Input[_builtins.str] project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AzurePrivatelinkConnectionApprovalArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Approves an Azure Private Link connection to an Aiven service with an associated endpoint IP.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven
        import pulumi_azurerm as azurerm

        static_ips = []
        for range in [{"value": i} for i in range(0, 2)]:
            static_ips.append(aiven.StaticIp(f"static_ips-{range['value']}",
                project=project_id,
                cloud_name=region))
        default = aiven.Pg("default",
            service_name="postgres",
            project=aiven_project_id,
            project_vpc_id=aiven_project_vpc_id,
            cloud_name=region,
            plan=plan,
            static_ips=[sip.static_ip_address_id for sip in static_ips],
            pg_user_config={
                "pg_version": "13",
                "static_ips": True,
                "privatelink_access": {
                    "pg": True,
                    "pgbouncer": True,
                },
            })
        privatelink = aiven.AzurePrivatelink("privatelink",
            project=aiven_project_id,
            service_name=default.name,
            user_subscription_ids=[azure_subscription_id])
        endpoint = azurerm.index.PrivateEndpoint("endpoint",
            name=postgres-endpoint,
            location=region,
            resource_group_name=azure_resource_group.name,
            subnet_id=azure_subnet_id,
            private_service_connection=[{
                name: default.name,
                privateConnectionResourceId: privatelink.azure_service_id,
                isManualConnection: True,
                requestMessage: default.name,
            }],
            opts = pulumi.ResourceOptions(depends_on=[privatelink]))
        approval = aiven.AzurePrivatelinkConnectionApproval("approval",
            project=aiven_project_id,
            service_name=default.service_name,
            endpoint_ip_address=endpoint["privateServiceConnection"][0]["privateIpAddress"])
        ```

        ## Import

        ```sh
        $ pulumi import aiven:index/azurePrivatelinkConnectionApproval:AzurePrivatelinkConnectionApproval approval PROJECT/SERVICE_NAME
        ```

        :param str resource_name: The name of the resource.
        :param AzurePrivatelinkConnectionApprovalArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AzurePrivatelinkConnectionApprovalArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 endpoint_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AzurePrivatelinkConnectionApprovalArgs.__new__(AzurePrivatelinkConnectionApprovalArgs)

            __props__.__dict__["endpoint_ip_address"] = endpoint_ip_address
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["privatelink_connection_id"] = None
            __props__.__dict__["state"] = None
        super(AzurePrivatelinkConnectionApproval, __self__).__init__(
            'aiven:index/azurePrivatelinkConnectionApproval:AzurePrivatelinkConnectionApproval',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            endpoint_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            privatelink_connection_id: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            service_name: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None) -> 'AzurePrivatelinkConnectionApproval':
        """
        Get an existing AzurePrivatelinkConnectionApproval resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] endpoint_ip_address: IP address of Azure private endpoint.
        :param pulumi.Input[_builtins.str] privatelink_connection_id: The ID of the Private Link connection.
        :param pulumi.Input[_builtins.str] project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] state: The state of the Private Link connection.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AzurePrivatelinkConnectionApprovalState.__new__(_AzurePrivatelinkConnectionApprovalState)

        __props__.__dict__["endpoint_ip_address"] = endpoint_ip_address
        __props__.__dict__["privatelink_connection_id"] = privatelink_connection_id
        __props__.__dict__["project"] = project
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["state"] = state
        return AzurePrivatelinkConnectionApproval(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="endpointIpAddress")
    def endpoint_ip_address(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        IP address of Azure private endpoint.
        """
        return pulumi.get(self, "endpoint_ip_address")

    @_builtins.property
    @pulumi.getter(name="privatelinkConnectionId")
    def privatelink_connection_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Private Link connection.
        """
        return pulumi.get(self, "privatelink_connection_id")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The state of the Private Link connection.
        """
        return pulumi.get(self, "state")

