# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetBillingGroupResult',
    'AwaitableGetBillingGroupResult',
    'get_billing_group',
    'get_billing_group_output',
]

@pulumi.output_type
class GetBillingGroupResult:
    """
    A collection of values returned by getBillingGroup.
    """
    def __init__(__self__, account_id=None, address_lines=None, billing_currency=None, billing_emails=None, billing_extra_text=None, billing_group_id=None, card_id=None, city=None, company=None, copy_from_billing_group=None, country_code=None, id=None, name=None, parent_id=None, state=None, vat_id=None, zip_code=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if address_lines and not isinstance(address_lines, list):
            raise TypeError("Expected argument 'address_lines' to be a list")
        pulumi.set(__self__, "address_lines", address_lines)
        if billing_currency and not isinstance(billing_currency, str):
            raise TypeError("Expected argument 'billing_currency' to be a str")
        pulumi.set(__self__, "billing_currency", billing_currency)
        if billing_emails and not isinstance(billing_emails, list):
            raise TypeError("Expected argument 'billing_emails' to be a list")
        pulumi.set(__self__, "billing_emails", billing_emails)
        if billing_extra_text and not isinstance(billing_extra_text, str):
            raise TypeError("Expected argument 'billing_extra_text' to be a str")
        pulumi.set(__self__, "billing_extra_text", billing_extra_text)
        if billing_group_id and not isinstance(billing_group_id, str):
            raise TypeError("Expected argument 'billing_group_id' to be a str")
        pulumi.set(__self__, "billing_group_id", billing_group_id)
        if card_id and not isinstance(card_id, str):
            raise TypeError("Expected argument 'card_id' to be a str")
        pulumi.set(__self__, "card_id", card_id)
        if city and not isinstance(city, str):
            raise TypeError("Expected argument 'city' to be a str")
        pulumi.set(__self__, "city", city)
        if company and not isinstance(company, str):
            raise TypeError("Expected argument 'company' to be a str")
        pulumi.set(__self__, "company", company)
        if copy_from_billing_group and not isinstance(copy_from_billing_group, str):
            raise TypeError("Expected argument 'copy_from_billing_group' to be a str")
        pulumi.set(__self__, "copy_from_billing_group", copy_from_billing_group)
        if country_code and not isinstance(country_code, str):
            raise TypeError("Expected argument 'country_code' to be a str")
        pulumi.set(__self__, "country_code", country_code)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if parent_id and not isinstance(parent_id, str):
            raise TypeError("Expected argument 'parent_id' to be a str")
        pulumi.set(__self__, "parent_id", parent_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if vat_id and not isinstance(vat_id, str):
            raise TypeError("Expected argument 'vat_id' to be a str")
        pulumi.set(__self__, "vat_id", vat_id)
        if zip_code and not isinstance(zip_code, str):
            raise TypeError("Expected argument 'zip_code' to be a str")
        pulumi.set(__self__, "zip_code", zip_code)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        Account ID.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="addressLines")
    def address_lines(self) -> Sequence[_builtins.str]:
        """
        Address lines 1 and 2. For example, street, PO box, or building.
        """
        return pulumi.get(self, "address_lines")

    @_builtins.property
    @pulumi.getter(name="billingCurrency")
    def billing_currency(self) -> _builtins.str:
        """
        Billing currency for the billing group. Supported currencies are: AUD, CAD, CHF, DKK, EUR, GBP, JPY, NOK, NZD, SEK, SGD, and USD.
        """
        return pulumi.get(self, "billing_currency")

    @_builtins.property
    @pulumi.getter(name="billingEmails")
    def billing_emails(self) -> Sequence[_builtins.str]:
        """
        Email address of billing contacts. Invoices and other payment notifications are emailed to all billing contacts.
        """
        return pulumi.get(self, "billing_emails")

    @_builtins.property
    @pulumi.getter(name="billingExtraText")
    def billing_extra_text(self) -> _builtins.str:
        """
        Additional information to include on your invoice (for example, a reference number).
        """
        return pulumi.get(self, "billing_extra_text")

    @_builtins.property
    @pulumi.getter(name="billingGroupId")
    def billing_group_id(self) -> _builtins.str:
        """
        The [ID of the billing group](https://aiven.io/docs/platform/reference/get-resource-IDs#get-a-billing-group-id). To set up proper dependencies please refer to this variable as a reference.
        """
        return pulumi.get(self, "billing_group_id")

    @_builtins.property
    @pulumi.getter(name="cardId")
    def card_id(self) -> _builtins.str:
        """
        Credit card ID.
        """
        return pulumi.get(self, "card_id")

    @_builtins.property
    @pulumi.getter
    def city(self) -> _builtins.str:
        """
        City, district, suburb, town, or village.
        """
        return pulumi.get(self, "city")

    @_builtins.property
    @pulumi.getter
    def company(self) -> _builtins.str:
        """
        Your company name.
        """
        return pulumi.get(self, "company")

    @_builtins.property
    @pulumi.getter(name="copyFromBillingGroup")
    def copy_from_billing_group(self) -> _builtins.str:
        """
        ID of the billing group to copy the company name, address, currency, billing contacts, and extra text from.
        """
        return pulumi.get(self, "copy_from_billing_group")

    @_builtins.property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> _builtins.str:
        """
        Two-letter country code.
        """
        return pulumi.get(self, "country_code")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the billing group.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> _builtins.str:
        """
        Link a billing group to an existing organization by using its ID. To set up proper dependencies please refer to this variable as a reference.
        """
        return pulumi.get(self, "parent_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        Address state.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="vatId")
    def vat_id(self) -> _builtins.str:
        """
        The VAT identification number for your company.
        """
        return pulumi.get(self, "vat_id")

    @_builtins.property
    @pulumi.getter(name="zipCode")
    def zip_code(self) -> _builtins.str:
        """
        Zip or postal code.
        """
        return pulumi.get(self, "zip_code")


class AwaitableGetBillingGroupResult(GetBillingGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBillingGroupResult(
            account_id=self.account_id,
            address_lines=self.address_lines,
            billing_currency=self.billing_currency,
            billing_emails=self.billing_emails,
            billing_extra_text=self.billing_extra_text,
            billing_group_id=self.billing_group_id,
            card_id=self.card_id,
            city=self.city,
            company=self.company,
            copy_from_billing_group=self.copy_from_billing_group,
            country_code=self.country_code,
            id=self.id,
            name=self.name,
            parent_id=self.parent_id,
            state=self.state,
            vat_id=self.vat_id,
            zip_code=self.zip_code)


def get_billing_group(billing_group_id: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBillingGroupResult:
    """
    Gets information about a billing group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    example_billing_group = aiven.get_billing_group(billing_group_id="1a2b3c4d-5e6f-7a8b-9c0d-1e2f3a4b5c6d")
    ```


    :param _builtins.str billing_group_id: The [ID of the billing group](https://aiven.io/docs/platform/reference/get-resource-IDs#get-a-billing-group-id). To set up proper dependencies please refer to this variable as a reference.
    """
    __args__ = dict()
    __args__['billingGroupId'] = billing_group_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aiven:index/getBillingGroup:getBillingGroup', __args__, opts=opts, typ=GetBillingGroupResult).value

    return AwaitableGetBillingGroupResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        address_lines=pulumi.get(__ret__, 'address_lines'),
        billing_currency=pulumi.get(__ret__, 'billing_currency'),
        billing_emails=pulumi.get(__ret__, 'billing_emails'),
        billing_extra_text=pulumi.get(__ret__, 'billing_extra_text'),
        billing_group_id=pulumi.get(__ret__, 'billing_group_id'),
        card_id=pulumi.get(__ret__, 'card_id'),
        city=pulumi.get(__ret__, 'city'),
        company=pulumi.get(__ret__, 'company'),
        copy_from_billing_group=pulumi.get(__ret__, 'copy_from_billing_group'),
        country_code=pulumi.get(__ret__, 'country_code'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        parent_id=pulumi.get(__ret__, 'parent_id'),
        state=pulumi.get(__ret__, 'state'),
        vat_id=pulumi.get(__ret__, 'vat_id'),
        zip_code=pulumi.get(__ret__, 'zip_code'))
def get_billing_group_output(billing_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBillingGroupResult]:
    """
    Gets information about a billing group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    example_billing_group = aiven.get_billing_group(billing_group_id="1a2b3c4d-5e6f-7a8b-9c0d-1e2f3a4b5c6d")
    ```


    :param _builtins.str billing_group_id: The [ID of the billing group](https://aiven.io/docs/platform/reference/get-resource-IDs#get-a-billing-group-id). To set up proper dependencies please refer to this variable as a reference.
    """
    __args__ = dict()
    __args__['billingGroupId'] = billing_group_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aiven:index/getBillingGroup:getBillingGroup', __args__, opts=opts, typ=GetBillingGroupResult)
    return __ret__.apply(lambda __response__: GetBillingGroupResult(
        account_id=pulumi.get(__response__, 'account_id'),
        address_lines=pulumi.get(__response__, 'address_lines'),
        billing_currency=pulumi.get(__response__, 'billing_currency'),
        billing_emails=pulumi.get(__response__, 'billing_emails'),
        billing_extra_text=pulumi.get(__response__, 'billing_extra_text'),
        billing_group_id=pulumi.get(__response__, 'billing_group_id'),
        card_id=pulumi.get(__response__, 'card_id'),
        city=pulumi.get(__response__, 'city'),
        company=pulumi.get(__response__, 'company'),
        copy_from_billing_group=pulumi.get(__response__, 'copy_from_billing_group'),
        country_code=pulumi.get(__response__, 'country_code'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        parent_id=pulumi.get(__response__, 'parent_id'),
        state=pulumi.get(__response__, 'state'),
        vat_id=pulumi.get(__response__, 'vat_id'),
        zip_code=pulumi.get(__response__, 'zip_code')))
