# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetClickhouseUserResult',
    'AwaitableGetClickhouseUserResult',
    'get_clickhouse_user',
    'get_clickhouse_user_output',
]

@pulumi.output_type
class GetClickhouseUserResult:
    """
    A collection of values returned by getClickhouseUser.
    """
    def __init__(__self__, id=None, password=None, project=None, required=None, service_name=None, username=None, uuid=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if password and not isinstance(password, str):
            raise TypeError("Expected argument 'password' to be a str")
        pulumi.set(__self__, "password", password)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if required and not isinstance(required, bool):
            raise TypeError("Expected argument 'required' to be a bool")
        pulumi.set(__self__, "required", required)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if username and not isinstance(username, str):
            raise TypeError("Expected argument 'username' to be a str")
        pulumi.set(__self__, "username", username)
        if uuid and not isinstance(uuid, str):
            raise TypeError("Expected argument 'uuid' to be a str")
        pulumi.set(__self__, "uuid", uuid)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.str:
        """
        The password of the ClickHouse user.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        """
        The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def required(self) -> _builtins.bool:
        """
        Indicates if a ClickHouse user is required.
        """
        return pulumi.get(self, "required")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> _builtins.str:
        """
        The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        The name of the ClickHouse user. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> _builtins.str:
        """
        UUID of the ClickHouse user.
        """
        return pulumi.get(self, "uuid")


class AwaitableGetClickhouseUserResult(GetClickhouseUserResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClickhouseUserResult(
            id=self.id,
            password=self.password,
            project=self.project,
            required=self.required,
            service_name=self.service_name,
            username=self.username,
            uuid=self.uuid)


def get_clickhouse_user(project: Optional[_builtins.str] = None,
                        service_name: Optional[_builtins.str] = None,
                        username: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClickhouseUserResult:
    """
    Gets information about a ClickHouse user.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    example_user = aiven.get_clickhouse_user(project=example_project["project"],
        service_name=example_clickhouse["serviceName"],
        username="analyst")
    ```


    :param _builtins.str project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    :param _builtins.str service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    :param _builtins.str username: The name of the ClickHouse user. Changing this property forces recreation of the resource.
    """
    __args__ = dict()
    __args__['project'] = project
    __args__['serviceName'] = service_name
    __args__['username'] = username
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aiven:index/getClickhouseUser:getClickhouseUser', __args__, opts=opts, typ=GetClickhouseUserResult).value

    return AwaitableGetClickhouseUserResult(
        id=pulumi.get(__ret__, 'id'),
        password=pulumi.get(__ret__, 'password'),
        project=pulumi.get(__ret__, 'project'),
        required=pulumi.get(__ret__, 'required'),
        service_name=pulumi.get(__ret__, 'service_name'),
        username=pulumi.get(__ret__, 'username'),
        uuid=pulumi.get(__ret__, 'uuid'))
def get_clickhouse_user_output(project: Optional[pulumi.Input[_builtins.str]] = None,
                               service_name: Optional[pulumi.Input[_builtins.str]] = None,
                               username: Optional[pulumi.Input[_builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetClickhouseUserResult]:
    """
    Gets information about a ClickHouse user.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    example_user = aiven.get_clickhouse_user(project=example_project["project"],
        service_name=example_clickhouse["serviceName"],
        username="analyst")
    ```


    :param _builtins.str project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    :param _builtins.str service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    :param _builtins.str username: The name of the ClickHouse user. Changing this property forces recreation of the resource.
    """
    __args__ = dict()
    __args__['project'] = project
    __args__['serviceName'] = service_name
    __args__['username'] = username
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aiven:index/getClickhouseUser:getClickhouseUser', __args__, opts=opts, typ=GetClickhouseUserResult)
    return __ret__.apply(lambda __response__: GetClickhouseUserResult(
        id=pulumi.get(__response__, 'id'),
        password=pulumi.get(__response__, 'password'),
        project=pulumi.get(__response__, 'project'),
        required=pulumi.get(__response__, 'required'),
        service_name=pulumi.get(__response__, 'service_name'),
        username=pulumi.get(__response__, 'username'),
        uuid=pulumi.get(__response__, 'uuid')))
