# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetKafkaConnectorResult',
    'AwaitableGetKafkaConnectorResult',
    'get_kafka_connector',
    'get_kafka_connector_output',
]

@pulumi.output_type
class GetKafkaConnectorResult:
    """
    A collection of values returned by getKafkaConnector.
    """
    def __init__(__self__, config=None, connector_name=None, id=None, plugin_author=None, plugin_class=None, plugin_doc_url=None, plugin_title=None, plugin_type=None, plugin_version=None, project=None, service_name=None, tasks=None):
        if config and not isinstance(config, dict):
            raise TypeError("Expected argument 'config' to be a dict")
        pulumi.set(__self__, "config", config)
        if connector_name and not isinstance(connector_name, str):
            raise TypeError("Expected argument 'connector_name' to be a str")
        pulumi.set(__self__, "connector_name", connector_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if plugin_author and not isinstance(plugin_author, str):
            raise TypeError("Expected argument 'plugin_author' to be a str")
        pulumi.set(__self__, "plugin_author", plugin_author)
        if plugin_class and not isinstance(plugin_class, str):
            raise TypeError("Expected argument 'plugin_class' to be a str")
        pulumi.set(__self__, "plugin_class", plugin_class)
        if plugin_doc_url and not isinstance(plugin_doc_url, str):
            raise TypeError("Expected argument 'plugin_doc_url' to be a str")
        pulumi.set(__self__, "plugin_doc_url", plugin_doc_url)
        if plugin_title and not isinstance(plugin_title, str):
            raise TypeError("Expected argument 'plugin_title' to be a str")
        pulumi.set(__self__, "plugin_title", plugin_title)
        if plugin_type and not isinstance(plugin_type, str):
            raise TypeError("Expected argument 'plugin_type' to be a str")
        pulumi.set(__self__, "plugin_type", plugin_type)
        if plugin_version and not isinstance(plugin_version, str):
            raise TypeError("Expected argument 'plugin_version' to be a str")
        pulumi.set(__self__, "plugin_version", plugin_version)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if tasks and not isinstance(tasks, list):
            raise TypeError("Expected argument 'tasks' to be a list")
        pulumi.set(__self__, "tasks", tasks)

    @_builtins.property
    @pulumi.getter
    def config(self) -> Mapping[str, _builtins.str]:
        """
        The Kafka connector configuration parameters.
        """
        return pulumi.get(self, "config")

    @_builtins.property
    @pulumi.getter(name="connectorName")
    def connector_name(self) -> _builtins.str:
        """
        The Kafka connector name. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "connector_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="pluginAuthor")
    def plugin_author(self) -> _builtins.str:
        """
        The Kafka connector author.
        """
        return pulumi.get(self, "plugin_author")

    @_builtins.property
    @pulumi.getter(name="pluginClass")
    def plugin_class(self) -> _builtins.str:
        """
        The Kafka connector Java class.
        """
        return pulumi.get(self, "plugin_class")

    @_builtins.property
    @pulumi.getter(name="pluginDocUrl")
    def plugin_doc_url(self) -> _builtins.str:
        """
        The Kafka connector documentation URL.
        """
        return pulumi.get(self, "plugin_doc_url")

    @_builtins.property
    @pulumi.getter(name="pluginTitle")
    def plugin_title(self) -> _builtins.str:
        """
        The Kafka connector title.
        """
        return pulumi.get(self, "plugin_title")

    @_builtins.property
    @pulumi.getter(name="pluginType")
    def plugin_type(self) -> _builtins.str:
        """
        The Kafka connector type.
        """
        return pulumi.get(self, "plugin_type")

    @_builtins.property
    @pulumi.getter(name="pluginVersion")
    def plugin_version(self) -> _builtins.str:
        """
        The version of the Kafka connector.
        """
        return pulumi.get(self, "plugin_version")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        """
        The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> _builtins.str:
        """
        The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter
    def tasks(self) -> Sequence['outputs.GetKafkaConnectorTaskResult']:
        """
        List of tasks of a connector.
        """
        return pulumi.get(self, "tasks")


class AwaitableGetKafkaConnectorResult(GetKafkaConnectorResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKafkaConnectorResult(
            config=self.config,
            connector_name=self.connector_name,
            id=self.id,
            plugin_author=self.plugin_author,
            plugin_class=self.plugin_class,
            plugin_doc_url=self.plugin_doc_url,
            plugin_title=self.plugin_title,
            plugin_type=self.plugin_type,
            plugin_version=self.plugin_version,
            project=self.project,
            service_name=self.service_name,
            tasks=self.tasks)


def get_kafka_connector(connector_name: Optional[_builtins.str] = None,
                        project: Optional[_builtins.str] = None,
                        service_name: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKafkaConnectorResult:
    """
    Gets information about an Aiven for Apache Kafka® connector.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    kafka_os_connector = aiven.get_kafka_connector(project=example_project["project"],
        service_name=example_kafka["serviceName"],
        connector_name="kafka-opensearch-connector")
    ```


    :param _builtins.str connector_name: The Kafka connector name. Changing this property forces recreation of the resource.
    :param _builtins.str project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    :param _builtins.str service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    """
    __args__ = dict()
    __args__['connectorName'] = connector_name
    __args__['project'] = project
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aiven:index/getKafkaConnector:getKafkaConnector', __args__, opts=opts, typ=GetKafkaConnectorResult).value

    return AwaitableGetKafkaConnectorResult(
        config=pulumi.get(__ret__, 'config'),
        connector_name=pulumi.get(__ret__, 'connector_name'),
        id=pulumi.get(__ret__, 'id'),
        plugin_author=pulumi.get(__ret__, 'plugin_author'),
        plugin_class=pulumi.get(__ret__, 'plugin_class'),
        plugin_doc_url=pulumi.get(__ret__, 'plugin_doc_url'),
        plugin_title=pulumi.get(__ret__, 'plugin_title'),
        plugin_type=pulumi.get(__ret__, 'plugin_type'),
        plugin_version=pulumi.get(__ret__, 'plugin_version'),
        project=pulumi.get(__ret__, 'project'),
        service_name=pulumi.get(__ret__, 'service_name'),
        tasks=pulumi.get(__ret__, 'tasks'))
def get_kafka_connector_output(connector_name: Optional[pulumi.Input[_builtins.str]] = None,
                               project: Optional[pulumi.Input[_builtins.str]] = None,
                               service_name: Optional[pulumi.Input[_builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetKafkaConnectorResult]:
    """
    Gets information about an Aiven for Apache Kafka® connector.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    kafka_os_connector = aiven.get_kafka_connector(project=example_project["project"],
        service_name=example_kafka["serviceName"],
        connector_name="kafka-opensearch-connector")
    ```


    :param _builtins.str connector_name: The Kafka connector name. Changing this property forces recreation of the resource.
    :param _builtins.str project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    :param _builtins.str service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    """
    __args__ = dict()
    __args__['connectorName'] = connector_name
    __args__['project'] = project
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aiven:index/getKafkaConnector:getKafkaConnector', __args__, opts=opts, typ=GetKafkaConnectorResult)
    return __ret__.apply(lambda __response__: GetKafkaConnectorResult(
        config=pulumi.get(__response__, 'config'),
        connector_name=pulumi.get(__response__, 'connector_name'),
        id=pulumi.get(__response__, 'id'),
        plugin_author=pulumi.get(__response__, 'plugin_author'),
        plugin_class=pulumi.get(__response__, 'plugin_class'),
        plugin_doc_url=pulumi.get(__response__, 'plugin_doc_url'),
        plugin_title=pulumi.get(__response__, 'plugin_title'),
        plugin_type=pulumi.get(__response__, 'plugin_type'),
        plugin_version=pulumi.get(__response__, 'plugin_version'),
        project=pulumi.get(__response__, 'project'),
        service_name=pulumi.get(__response__, 'service_name'),
        tasks=pulumi.get(__response__, 'tasks')))
