# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetKafkaSchemaRegistryAclResult',
    'AwaitableGetKafkaSchemaRegistryAclResult',
    'get_kafka_schema_registry_acl',
    'get_kafka_schema_registry_acl_output',
]

@pulumi.output_type
class GetKafkaSchemaRegistryAclResult:
    """
    A collection of values returned by getKafkaSchemaRegistryAcl.
    """
    def __init__(__self__, acl_id=None, id=None, permission=None, project=None, resource=None, service_name=None, username=None):
        if acl_id and not isinstance(acl_id, str):
            raise TypeError("Expected argument 'acl_id' to be a str")
        pulumi.set(__self__, "acl_id", acl_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if permission and not isinstance(permission, str):
            raise TypeError("Expected argument 'permission' to be a str")
        pulumi.set(__self__, "permission", permission)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if resource and not isinstance(resource, str):
            raise TypeError("Expected argument 'resource' to be a str")
        pulumi.set(__self__, "resource", resource)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if username and not isinstance(username, str):
            raise TypeError("Expected argument 'username' to be a str")
        pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter(name="aclId")
    def acl_id(self) -> _builtins.str:
        """
        Kafka Schema Registry ACL ID
        """
        return pulumi.get(self, "acl_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def permission(self) -> _builtins.str:
        """
        Kafka Schema Registry permission to grant. The possible values are `schema_registry_read` and `schema_registry_write`. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "permission")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        """
        The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def resource(self) -> _builtins.str:
        """
        Resource name pattern for the Schema Registry ACL entry. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "resource")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> _builtins.str:
        """
        The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        Username pattern for the ACL entry. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "username")


class AwaitableGetKafkaSchemaRegistryAclResult(GetKafkaSchemaRegistryAclResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKafkaSchemaRegistryAclResult(
            acl_id=self.acl_id,
            id=self.id,
            permission=self.permission,
            project=self.project,
            resource=self.resource,
            service_name=self.service_name,
            username=self.username)


def get_kafka_schema_registry_acl(permission: Optional[_builtins.str] = None,
                                  project: Optional[_builtins.str] = None,
                                  resource: Optional[_builtins.str] = None,
                                  service_name: Optional[_builtins.str] = None,
                                  username: Optional[_builtins.str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKafkaSchemaRegistryAclResult:
    """
    The Data Source Kafka Schema Registry ACL data source provides information about the existing Aiven Kafka Schema Registry ACL for a Kafka service.


    :param _builtins.str permission: Kafka Schema Registry permission to grant. The possible values are `schema_registry_read` and `schema_registry_write`. Changing this property forces recreation of the resource.
    :param _builtins.str project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    :param _builtins.str resource: Resource name pattern for the Schema Registry ACL entry. Changing this property forces recreation of the resource.
    :param _builtins.str service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    :param _builtins.str username: Username pattern for the ACL entry. Changing this property forces recreation of the resource.
    """
    __args__ = dict()
    __args__['permission'] = permission
    __args__['project'] = project
    __args__['resource'] = resource
    __args__['serviceName'] = service_name
    __args__['username'] = username
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aiven:index/getKafkaSchemaRegistryAcl:getKafkaSchemaRegistryAcl', __args__, opts=opts, typ=GetKafkaSchemaRegistryAclResult).value

    return AwaitableGetKafkaSchemaRegistryAclResult(
        acl_id=pulumi.get(__ret__, 'acl_id'),
        id=pulumi.get(__ret__, 'id'),
        permission=pulumi.get(__ret__, 'permission'),
        project=pulumi.get(__ret__, 'project'),
        resource=pulumi.get(__ret__, 'resource'),
        service_name=pulumi.get(__ret__, 'service_name'),
        username=pulumi.get(__ret__, 'username'))
def get_kafka_schema_registry_acl_output(permission: Optional[pulumi.Input[_builtins.str]] = None,
                                         project: Optional[pulumi.Input[_builtins.str]] = None,
                                         resource: Optional[pulumi.Input[_builtins.str]] = None,
                                         service_name: Optional[pulumi.Input[_builtins.str]] = None,
                                         username: Optional[pulumi.Input[_builtins.str]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetKafkaSchemaRegistryAclResult]:
    """
    The Data Source Kafka Schema Registry ACL data source provides information about the existing Aiven Kafka Schema Registry ACL for a Kafka service.


    :param _builtins.str permission: Kafka Schema Registry permission to grant. The possible values are `schema_registry_read` and `schema_registry_write`. Changing this property forces recreation of the resource.
    :param _builtins.str project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    :param _builtins.str resource: Resource name pattern for the Schema Registry ACL entry. Changing this property forces recreation of the resource.
    :param _builtins.str service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    :param _builtins.str username: Username pattern for the ACL entry. Changing this property forces recreation of the resource.
    """
    __args__ = dict()
    __args__['permission'] = permission
    __args__['project'] = project
    __args__['resource'] = resource
    __args__['serviceName'] = service_name
    __args__['username'] = username
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aiven:index/getKafkaSchemaRegistryAcl:getKafkaSchemaRegistryAcl', __args__, opts=opts, typ=GetKafkaSchemaRegistryAclResult)
    return __ret__.apply(lambda __response__: GetKafkaSchemaRegistryAclResult(
        acl_id=pulumi.get(__response__, 'acl_id'),
        id=pulumi.get(__response__, 'id'),
        permission=pulumi.get(__response__, 'permission'),
        project=pulumi.get(__response__, 'project'),
        resource=pulumi.get(__response__, 'resource'),
        service_name=pulumi.get(__response__, 'service_name'),
        username=pulumi.get(__response__, 'username')))
