# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetMirrorMakerReplicationFlowResult',
    'AwaitableGetMirrorMakerReplicationFlowResult',
    'get_mirror_maker_replication_flow',
    'get_mirror_maker_replication_flow_output',
]

@pulumi.output_type
class GetMirrorMakerReplicationFlowResult:
    """
    A collection of values returned by getMirrorMakerReplicationFlow.
    """
    def __init__(__self__, config_properties_excludes=None, emit_backward_heartbeats_enabled=None, emit_heartbeats_enabled=None, enable=None, exactly_once_delivery_enabled=None, id=None, offset_syncs_topic_location=None, project=None, replication_factor=None, replication_policy_class=None, service_name=None, source_cluster=None, sync_group_offsets_enabled=None, sync_group_offsets_interval_seconds=None, target_cluster=None, topics=None, topics_blacklists=None):
        if config_properties_excludes and not isinstance(config_properties_excludes, list):
            raise TypeError("Expected argument 'config_properties_excludes' to be a list")
        pulumi.set(__self__, "config_properties_excludes", config_properties_excludes)
        if emit_backward_heartbeats_enabled and not isinstance(emit_backward_heartbeats_enabled, bool):
            raise TypeError("Expected argument 'emit_backward_heartbeats_enabled' to be a bool")
        pulumi.set(__self__, "emit_backward_heartbeats_enabled", emit_backward_heartbeats_enabled)
        if emit_heartbeats_enabled and not isinstance(emit_heartbeats_enabled, bool):
            raise TypeError("Expected argument 'emit_heartbeats_enabled' to be a bool")
        pulumi.set(__self__, "emit_heartbeats_enabled", emit_heartbeats_enabled)
        if enable and not isinstance(enable, bool):
            raise TypeError("Expected argument 'enable' to be a bool")
        pulumi.set(__self__, "enable", enable)
        if exactly_once_delivery_enabled and not isinstance(exactly_once_delivery_enabled, bool):
            raise TypeError("Expected argument 'exactly_once_delivery_enabled' to be a bool")
        pulumi.set(__self__, "exactly_once_delivery_enabled", exactly_once_delivery_enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if offset_syncs_topic_location and not isinstance(offset_syncs_topic_location, str):
            raise TypeError("Expected argument 'offset_syncs_topic_location' to be a str")
        pulumi.set(__self__, "offset_syncs_topic_location", offset_syncs_topic_location)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if replication_factor and not isinstance(replication_factor, int):
            raise TypeError("Expected argument 'replication_factor' to be a int")
        pulumi.set(__self__, "replication_factor", replication_factor)
        if replication_policy_class and not isinstance(replication_policy_class, str):
            raise TypeError("Expected argument 'replication_policy_class' to be a str")
        pulumi.set(__self__, "replication_policy_class", replication_policy_class)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if source_cluster and not isinstance(source_cluster, str):
            raise TypeError("Expected argument 'source_cluster' to be a str")
        pulumi.set(__self__, "source_cluster", source_cluster)
        if sync_group_offsets_enabled and not isinstance(sync_group_offsets_enabled, bool):
            raise TypeError("Expected argument 'sync_group_offsets_enabled' to be a bool")
        pulumi.set(__self__, "sync_group_offsets_enabled", sync_group_offsets_enabled)
        if sync_group_offsets_interval_seconds and not isinstance(sync_group_offsets_interval_seconds, int):
            raise TypeError("Expected argument 'sync_group_offsets_interval_seconds' to be a int")
        pulumi.set(__self__, "sync_group_offsets_interval_seconds", sync_group_offsets_interval_seconds)
        if target_cluster and not isinstance(target_cluster, str):
            raise TypeError("Expected argument 'target_cluster' to be a str")
        pulumi.set(__self__, "target_cluster", target_cluster)
        if topics and not isinstance(topics, list):
            raise TypeError("Expected argument 'topics' to be a list")
        pulumi.set(__self__, "topics", topics)
        if topics_blacklists and not isinstance(topics_blacklists, list):
            raise TypeError("Expected argument 'topics_blacklists' to be a list")
        pulumi.set(__self__, "topics_blacklists", topics_blacklists)

    @_builtins.property
    @pulumi.getter(name="configPropertiesExcludes")
    def config_properties_excludes(self) -> Sequence[_builtins.str]:
        """
        List of topic configuration properties and regular expressions to not replicate. The properties that are not replicated by default are: `follower.replication.throttled.replicas`, `leader.replication.throttled.replicas`, `message.timestamp.difference.max.ms`, `message.timestamp.type`, `unclean.leader.election.enable`, and `min.insync.replicas`. Setting this overrides the defaults. For example, to enable replication for 'min.insync.replicas' and 'unclean.leader.election.enable' set this to: ["follower\\\\.replication\\\\.throttled\\\\.replicas", "leader\\\\.replication\\\\.throttled\\\\.replicas", "message\\\\.timestamp\\\\.difference\\\\.max\\\\.ms",  "message\\\\.timestamp\\\\.type"]
        """
        return pulumi.get(self, "config_properties_excludes")

    @_builtins.property
    @pulumi.getter(name="emitBackwardHeartbeatsEnabled")
    def emit_backward_heartbeats_enabled(self) -> _builtins.bool:
        """
        Enables emitting heartbeats to the direction opposite to the flow, i.e. to the source cluster. The default value is `false`.
        """
        return pulumi.get(self, "emit_backward_heartbeats_enabled")

    @_builtins.property
    @pulumi.getter(name="emitHeartbeatsEnabled")
    def emit_heartbeats_enabled(self) -> _builtins.bool:
        """
        Enables emitting heartbeats to the target cluster. The default value is `false`.
        """
        return pulumi.get(self, "emit_heartbeats_enabled")

    @_builtins.property
    @pulumi.getter
    def enable(self) -> _builtins.bool:
        """
        Enables replication flow for a service.
        """
        return pulumi.get(self, "enable")

    @_builtins.property
    @pulumi.getter(name="exactlyOnceDeliveryEnabled")
    def exactly_once_delivery_enabled(self) -> _builtins.bool:
        """
        Enables exactly-once message delivery. Set this to `enabled` for new replications. The default value is `false`.
        """
        return pulumi.get(self, "exactly_once_delivery_enabled")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="offsetSyncsTopicLocation")
    def offset_syncs_topic_location(self) -> _builtins.str:
        """
        Offset syncs topic location. The possible values are `source` and `target`.
        """
        return pulumi.get(self, "offset_syncs_topic_location")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        """
        The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="replicationFactor")
    def replication_factor(self) -> _builtins.int:
        """
        Replication factor, `>= 1`.
        """
        return pulumi.get(self, "replication_factor")

    @_builtins.property
    @pulumi.getter(name="replicationPolicyClass")
    def replication_policy_class(self) -> _builtins.str:
        """
        Replication policy class. The possible values are `org.apache.kafka.connect.mirror.DefaultReplicationPolicy` and `org.apache.kafka.connect.mirror.IdentityReplicationPolicy`. The default value is `org.apache.kafka.connect.mirror.DefaultReplicationPolicy`.
        """
        return pulumi.get(self, "replication_policy_class")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> _builtins.str:
        """
        The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter(name="sourceCluster")
    def source_cluster(self) -> _builtins.str:
        """
        Source cluster alias. Maximum length: `128`.
        """
        return pulumi.get(self, "source_cluster")

    @_builtins.property
    @pulumi.getter(name="syncGroupOffsetsEnabled")
    def sync_group_offsets_enabled(self) -> _builtins.bool:
        """
        Sync consumer group offsets. The default value is `false`.
        """
        return pulumi.get(self, "sync_group_offsets_enabled")

    @_builtins.property
    @pulumi.getter(name="syncGroupOffsetsIntervalSeconds")
    def sync_group_offsets_interval_seconds(self) -> _builtins.int:
        """
        Frequency of consumer group offset sync. The default value is `1`.
        """
        return pulumi.get(self, "sync_group_offsets_interval_seconds")

    @_builtins.property
    @pulumi.getter(name="targetCluster")
    def target_cluster(self) -> _builtins.str:
        """
        Target cluster alias. Maximum length: `128`.
        """
        return pulumi.get(self, "target_cluster")

    @_builtins.property
    @pulumi.getter
    def topics(self) -> Sequence[_builtins.str]:
        """
        The topics to include in the replica defined by a [list of regular expressions in Java format](https://aiven.io/docs/products/kafka/kafka-mirrormaker/concepts/replication-flow-topics-regex).
        """
        return pulumi.get(self, "topics")

    @_builtins.property
    @pulumi.getter(name="topicsBlacklists")
    def topics_blacklists(self) -> Sequence[_builtins.str]:
        """
        The topics to exclude from the replica defined by a [list of regular expressions in Java format](https://aiven.io/docs/products/kafka/kafka-mirrormaker/concepts/replication-flow-topics-regex).
        """
        return pulumi.get(self, "topics_blacklists")


class AwaitableGetMirrorMakerReplicationFlowResult(GetMirrorMakerReplicationFlowResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMirrorMakerReplicationFlowResult(
            config_properties_excludes=self.config_properties_excludes,
            emit_backward_heartbeats_enabled=self.emit_backward_heartbeats_enabled,
            emit_heartbeats_enabled=self.emit_heartbeats_enabled,
            enable=self.enable,
            exactly_once_delivery_enabled=self.exactly_once_delivery_enabled,
            id=self.id,
            offset_syncs_topic_location=self.offset_syncs_topic_location,
            project=self.project,
            replication_factor=self.replication_factor,
            replication_policy_class=self.replication_policy_class,
            service_name=self.service_name,
            source_cluster=self.source_cluster,
            sync_group_offsets_enabled=self.sync_group_offsets_enabled,
            sync_group_offsets_interval_seconds=self.sync_group_offsets_interval_seconds,
            target_cluster=self.target_cluster,
            topics=self.topics,
            topics_blacklists=self.topics_blacklists)


def get_mirror_maker_replication_flow(project: Optional[_builtins.str] = None,
                                      service_name: Optional[_builtins.str] = None,
                                      source_cluster: Optional[_builtins.str] = None,
                                      target_cluster: Optional[_builtins.str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMirrorMakerReplicationFlowResult:
    """
    Gets information about an [Aiven for Apache Kafka® MirrorMaker 2](https://aiven.io/docs/products/kafka/kafka-mirrormaker) replication flow.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    example_replication_flow = aiven.get_mirror_maker_replication_flow(project=example_project["project"],
        service_name=example_kafka["serviceName"],
        source_cluster=source["serviceName"],
        target_cluster=target["serviceName"])
    ```


    :param _builtins.str project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    :param _builtins.str service_name: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    :param _builtins.str source_cluster: Source cluster alias. Maximum length: `128`.
    :param _builtins.str target_cluster: Target cluster alias. Maximum length: `128`.
    """
    __args__ = dict()
    __args__['project'] = project
    __args__['serviceName'] = service_name
    __args__['sourceCluster'] = source_cluster
    __args__['targetCluster'] = target_cluster
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aiven:index/getMirrorMakerReplicationFlow:getMirrorMakerReplicationFlow', __args__, opts=opts, typ=GetMirrorMakerReplicationFlowResult).value

    return AwaitableGetMirrorMakerReplicationFlowResult(
        config_properties_excludes=pulumi.get(__ret__, 'config_properties_excludes'),
        emit_backward_heartbeats_enabled=pulumi.get(__ret__, 'emit_backward_heartbeats_enabled'),
        emit_heartbeats_enabled=pulumi.get(__ret__, 'emit_heartbeats_enabled'),
        enable=pulumi.get(__ret__, 'enable'),
        exactly_once_delivery_enabled=pulumi.get(__ret__, 'exactly_once_delivery_enabled'),
        id=pulumi.get(__ret__, 'id'),
        offset_syncs_topic_location=pulumi.get(__ret__, 'offset_syncs_topic_location'),
        project=pulumi.get(__ret__, 'project'),
        replication_factor=pulumi.get(__ret__, 'replication_factor'),
        replication_policy_class=pulumi.get(__ret__, 'replication_policy_class'),
        service_name=pulumi.get(__ret__, 'service_name'),
        source_cluster=pulumi.get(__ret__, 'source_cluster'),
        sync_group_offsets_enabled=pulumi.get(__ret__, 'sync_group_offsets_enabled'),
        sync_group_offsets_interval_seconds=pulumi.get(__ret__, 'sync_group_offsets_interval_seconds'),
        target_cluster=pulumi.get(__ret__, 'target_cluster'),
        topics=pulumi.get(__ret__, 'topics'),
        topics_blacklists=pulumi.get(__ret__, 'topics_blacklists'))
def get_mirror_maker_replication_flow_output(project: Optional[pulumi.Input[_builtins.str]] = None,
                                             service_name: Optional[pulumi.Input[_builtins.str]] = None,
                                             source_cluster: Optional[pulumi.Input[_builtins.str]] = None,
                                             target_cluster: Optional[pulumi.Input[_builtins.str]] = None,
                                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMirrorMakerReplicationFlowResult]:
    """
    Gets information about an [Aiven for Apache Kafka® MirrorMaker 2](https://aiven.io/docs/products/kafka/kafka-mirrormaker) replication flow.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    example_replication_flow = aiven.get_mirror_maker_replication_flow(project=example_project["project"],
        service_name=example_kafka["serviceName"],
        source_cluster=source["serviceName"],
        target_cluster=target["serviceName"])
    ```


    :param _builtins.str project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    :param _builtins.str service_name: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    :param _builtins.str source_cluster: Source cluster alias. Maximum length: `128`.
    :param _builtins.str target_cluster: Target cluster alias. Maximum length: `128`.
    """
    __args__ = dict()
    __args__['project'] = project
    __args__['serviceName'] = service_name
    __args__['sourceCluster'] = source_cluster
    __args__['targetCluster'] = target_cluster
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aiven:index/getMirrorMakerReplicationFlow:getMirrorMakerReplicationFlow', __args__, opts=opts, typ=GetMirrorMakerReplicationFlowResult)
    return __ret__.apply(lambda __response__: GetMirrorMakerReplicationFlowResult(
        config_properties_excludes=pulumi.get(__response__, 'config_properties_excludes'),
        emit_backward_heartbeats_enabled=pulumi.get(__response__, 'emit_backward_heartbeats_enabled'),
        emit_heartbeats_enabled=pulumi.get(__response__, 'emit_heartbeats_enabled'),
        enable=pulumi.get(__response__, 'enable'),
        exactly_once_delivery_enabled=pulumi.get(__response__, 'exactly_once_delivery_enabled'),
        id=pulumi.get(__response__, 'id'),
        offset_syncs_topic_location=pulumi.get(__response__, 'offset_syncs_topic_location'),
        project=pulumi.get(__response__, 'project'),
        replication_factor=pulumi.get(__response__, 'replication_factor'),
        replication_policy_class=pulumi.get(__response__, 'replication_policy_class'),
        service_name=pulumi.get(__response__, 'service_name'),
        source_cluster=pulumi.get(__response__, 'source_cluster'),
        sync_group_offsets_enabled=pulumi.get(__response__, 'sync_group_offsets_enabled'),
        sync_group_offsets_interval_seconds=pulumi.get(__response__, 'sync_group_offsets_interval_seconds'),
        target_cluster=pulumi.get(__response__, 'target_cluster'),
        topics=pulumi.get(__response__, 'topics'),
        topics_blacklists=pulumi.get(__response__, 'topics_blacklists')))
