# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetOpensearchSecurityPluginConfigResult',
    'AwaitableGetOpensearchSecurityPluginConfigResult',
    'get_opensearch_security_plugin_config',
    'get_opensearch_security_plugin_config_output',
]

@pulumi.output_type
class GetOpensearchSecurityPluginConfigResult:
    """
    A collection of values returned by getOpensearchSecurityPluginConfig.
    """
    def __init__(__self__, admin_enabled=None, admin_password=None, available=None, enabled=None, id=None, project=None, service_name=None):
        if admin_enabled and not isinstance(admin_enabled, bool):
            raise TypeError("Expected argument 'admin_enabled' to be a bool")
        pulumi.set(__self__, "admin_enabled", admin_enabled)
        if admin_password and not isinstance(admin_password, str):
            raise TypeError("Expected argument 'admin_password' to be a str")
        pulumi.set(__self__, "admin_password", admin_password)
        if available and not isinstance(available, bool):
            raise TypeError("Expected argument 'available' to be a bool")
        pulumi.set(__self__, "available", available)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)

    @_builtins.property
    @pulumi.getter(name="adminEnabled")
    def admin_enabled(self) -> _builtins.bool:
        """
        Whether the os-sec-admin user is enabled. This indicates whether OpenSearch Security management is enabled. This is always true when the os-sec-admin password was set at least once.
        """
        return pulumi.get(self, "admin_enabled")

    @_builtins.property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> _builtins.str:
        """
        The password for the os-sec-admin user.
        """
        return pulumi.get(self, "admin_password")

    @_builtins.property
    @pulumi.getter
    def available(self) -> _builtins.bool:
        """
        Whether the security plugin is available. This is always true for recently created services.
        """
        return pulumi.get(self, "available")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Whether the security plugin is enabled. This is always true for recently created services.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        """
        The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> _builtins.str:
        """
        The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")


class AwaitableGetOpensearchSecurityPluginConfigResult(GetOpensearchSecurityPluginConfigResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOpensearchSecurityPluginConfigResult(
            admin_enabled=self.admin_enabled,
            admin_password=self.admin_password,
            available=self.available,
            enabled=self.enabled,
            id=self.id,
            project=self.project,
            service_name=self.service_name)


def get_opensearch_security_plugin_config(project: Optional[_builtins.str] = None,
                                          service_name: Optional[_builtins.str] = None,
                                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOpensearchSecurityPluginConfigResult:
    """
    Gets information about OpenSearch Security configuration for an Aiven for OpenSearch® service.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    os_sec_config = aiven.get_opensearch_security_plugin_config(project=example_project["project"],
        service_name=example_opensearch["serviceName"])
    ```


    :param _builtins.str project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    :param _builtins.str service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    """
    __args__ = dict()
    __args__['project'] = project
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aiven:index/getOpensearchSecurityPluginConfig:getOpensearchSecurityPluginConfig', __args__, opts=opts, typ=GetOpensearchSecurityPluginConfigResult).value

    return AwaitableGetOpensearchSecurityPluginConfigResult(
        admin_enabled=pulumi.get(__ret__, 'admin_enabled'),
        admin_password=pulumi.get(__ret__, 'admin_password'),
        available=pulumi.get(__ret__, 'available'),
        enabled=pulumi.get(__ret__, 'enabled'),
        id=pulumi.get(__ret__, 'id'),
        project=pulumi.get(__ret__, 'project'),
        service_name=pulumi.get(__ret__, 'service_name'))
def get_opensearch_security_plugin_config_output(project: Optional[pulumi.Input[_builtins.str]] = None,
                                                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOpensearchSecurityPluginConfigResult]:
    """
    Gets information about OpenSearch Security configuration for an Aiven for OpenSearch® service.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    os_sec_config = aiven.get_opensearch_security_plugin_config(project=example_project["project"],
        service_name=example_opensearch["serviceName"])
    ```


    :param _builtins.str project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    :param _builtins.str service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    """
    __args__ = dict()
    __args__['project'] = project
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aiven:index/getOpensearchSecurityPluginConfig:getOpensearchSecurityPluginConfig', __args__, opts=opts, typ=GetOpensearchSecurityPluginConfigResult)
    return __ret__.apply(lambda __response__: GetOpensearchSecurityPluginConfigResult(
        admin_enabled=pulumi.get(__response__, 'admin_enabled'),
        admin_password=pulumi.get(__response__, 'admin_password'),
        available=pulumi.get(__response__, 'available'),
        enabled=pulumi.get(__response__, 'enabled'),
        id=pulumi.get(__response__, 'id'),
        project=pulumi.get(__response__, 'project'),
        service_name=pulumi.get(__response__, 'service_name')))
