# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OrganizationArgs', 'Organization']

@pulumi.input_type
class OrganizationArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['OrganizationTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a Organization resource.
        :param pulumi.Input[_builtins.str] name: Name of the organization. Maximum length: `128`.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the organization. Maximum length: `128`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['OrganizationTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['OrganizationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _OrganizationState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['OrganizationTimeoutsArgs']] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Organization resources.
        :param pulumi.Input[_builtins.str] create_time: Timestamp in ISO 8601 format, always in UTC.
        :param pulumi.Input[_builtins.str] name: Name of the organization. Maximum length: `128`.
        :param pulumi.Input[_builtins.str] tenant_id: Tenant identifier.
        :param pulumi.Input[_builtins.str] update_time: Timestamp in ISO 8601 format, always in UTC.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tenant_id is not None:
            warnings.warn("""This field is deprecated and will be removed in the next major release.""", DeprecationWarning)
            pulumi.log.warn("""tenant_id is deprecated: This field is deprecated and will be removed in the next major release.""")
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp in ISO 8601 format, always in UTC.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the organization. Maximum length: `128`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    @_utilities.deprecated("""This field is deprecated and will be removed in the next major release.""")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Tenant identifier.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['OrganizationTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['OrganizationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp in ISO 8601 format, always in UTC.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("aiven:index/organization:Organization")
class Organization(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['OrganizationTimeoutsArgs', 'OrganizationTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Creates and manages an [organization](https://aiven.io/docs/platform/concepts/orgs-units-projects).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        main = aiven.Organization("main", name="Example organization")
        ```

        ## Import

        ```sh
        $ pulumi import aiven:index/organization:Organization main ORGANIZATION_ID # (e.g. a1234567890 or org123456)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: Name of the organization. Maximum length: `128`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[OrganizationArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages an [organization](https://aiven.io/docs/platform/concepts/orgs-units-projects).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        main = aiven.Organization("main", name="Example organization")
        ```

        ## Import

        ```sh
        $ pulumi import aiven:index/organization:Organization main ORGANIZATION_ID # (e.g. a1234567890 or org123456)
        ```

        :param str resource_name: The name of the resource.
        :param OrganizationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OrganizationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['OrganizationTimeoutsArgs', 'OrganizationTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OrganizationArgs.__new__(OrganizationArgs)

            __props__.__dict__["name"] = name
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["create_time"] = None
            __props__.__dict__["tenant_id"] = None
            __props__.__dict__["update_time"] = None
        super(Organization, __self__).__init__(
            'aiven:index/organization:Organization',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
            timeouts: Optional[pulumi.Input[Union['OrganizationTimeoutsArgs', 'OrganizationTimeoutsArgsDict']]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'Organization':
        """
        Get an existing Organization resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: Timestamp in ISO 8601 format, always in UTC.
        :param pulumi.Input[_builtins.str] name: Name of the organization. Maximum length: `128`.
        :param pulumi.Input[_builtins.str] tenant_id: Tenant identifier.
        :param pulumi.Input[_builtins.str] update_time: Timestamp in ISO 8601 format, always in UTC.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OrganizationState.__new__(_OrganizationState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["name"] = name
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["update_time"] = update_time
        return Organization(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp in ISO 8601 format, always in UTC.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the organization. Maximum length: `128`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    @_utilities.deprecated("""This field is deprecated and will be removed in the next major release.""")
    def tenant_id(self) -> pulumi.Output[_builtins.str]:
        """
        Tenant identifier.
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.OrganizationTimeouts']]:
        return pulumi.get(self, "timeouts")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp in ISO 8601 format, always in UTC.
        """
        return pulumi.get(self, "update_time")

