# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['OrganizationApplicationUserArgs', 'OrganizationApplicationUser']

@pulumi.input_type
class OrganizationApplicationUserArgs:
    def __init__(__self__, *,
                 organization_id: pulumi.Input[_builtins.str],
                 is_super_admin: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a OrganizationApplicationUser resource.
        :param pulumi.Input[_builtins.str] organization_id: The ID of the organization the application user belongs to.
        :param pulumi.Input[_builtins.bool] is_super_admin: Makes the application user a super admin. The super admin role has completely unrestricted access to all organization resources and settings. This role should be limited to as few users as possible. For daily administrative tasks, assign users the organization admin role instead using the `OrganizationPermission` resource.
        :param pulumi.Input[_builtins.str] name: Name of the application user.
        """
        pulumi.set(__self__, "organization_id", organization_id)
        if is_super_admin is not None:
            warnings.warn("""This field is no longer accepted by the API. For administrative tasks, assign application users the organization admin role instead using the OrganizationPermission resource.""", DeprecationWarning)
            pulumi.log.warn("""is_super_admin is deprecated: This field is no longer accepted by the API. For administrative tasks, assign application users the organization admin role instead using the OrganizationPermission resource.""")
        if is_super_admin is not None:
            pulumi.set(__self__, "is_super_admin", is_super_admin)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the organization the application user belongs to.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter(name="isSuperAdmin")
    @_utilities.deprecated("""This field is no longer accepted by the API. For administrative tasks, assign application users the organization admin role instead using the OrganizationPermission resource.""")
    def is_super_admin(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Makes the application user a super admin. The super admin role has completely unrestricted access to all organization resources and settings. This role should be limited to as few users as possible. For daily administrative tasks, assign users the organization admin role instead using the `OrganizationPermission` resource.
        """
        return pulumi.get(self, "is_super_admin")

    @is_super_admin.setter
    def is_super_admin(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_super_admin", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the application user.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _OrganizationApplicationUserState:
    def __init__(__self__, *,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 is_super_admin: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering OrganizationApplicationUser resources.
        :param pulumi.Input[_builtins.str] email: An email address automatically generated by Aiven to help identify the application user. No notifications are sent to this email.
        :param pulumi.Input[_builtins.bool] is_super_admin: Makes the application user a super admin. The super admin role has completely unrestricted access to all organization resources and settings. This role should be limited to as few users as possible. For daily administrative tasks, assign users the organization admin role instead using the `OrganizationPermission` resource.
        :param pulumi.Input[_builtins.str] name: Name of the application user.
        :param pulumi.Input[_builtins.str] organization_id: The ID of the organization the application user belongs to.
        :param pulumi.Input[_builtins.str] user_id: The ID of the application user.
        """
        if email is not None:
            pulumi.set(__self__, "email", email)
        if is_super_admin is not None:
            warnings.warn("""This field is no longer accepted by the API. For administrative tasks, assign application users the organization admin role instead using the OrganizationPermission resource.""", DeprecationWarning)
            pulumi.log.warn("""is_super_admin is deprecated: This field is no longer accepted by the API. For administrative tasks, assign application users the organization admin role instead using the OrganizationPermission resource.""")
        if is_super_admin is not None:
            pulumi.set(__self__, "is_super_admin", is_super_admin)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An email address automatically generated by Aiven to help identify the application user. No notifications are sent to this email.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter(name="isSuperAdmin")
    @_utilities.deprecated("""This field is no longer accepted by the API. For administrative tasks, assign application users the organization admin role instead using the OrganizationPermission resource.""")
    def is_super_admin(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Makes the application user a super admin. The super admin role has completely unrestricted access to all organization resources and settings. This role should be limited to as few users as possible. For daily administrative tasks, assign users the organization admin role instead using the `OrganizationPermission` resource.
        """
        return pulumi.get(self, "is_super_admin")

    @is_super_admin.setter
    def is_super_admin(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_super_admin", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the application user.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the organization the application user belongs to.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the application user.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_id", value)


@pulumi.type_token("aiven:index/organizationApplicationUser:OrganizationApplicationUser")
class OrganizationApplicationUser(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 is_super_admin: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages an organization application user. [Application users](https://aiven.io/docs/platform/concepts/application-users) can be used for
        programmatic access to the platform using a token created with the `OrganizationApplicationUserToken` resource.

        You give application users access to your organization, projects, and services using the `OrganizationPermission` resource. You can also add application users to
        groups using the `OrganizationUserGroupMember` resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        tf_user = aiven.OrganizationApplicationUser("tf_user",
            organization_id=main["id"],
            name="app-terraform")
        ```

        ## Import

        ```sh
        $ pulumi import aiven:index/organizationApplicationUser:OrganizationApplicationUser example ORGANIZATION_ID/USER_ID
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] is_super_admin: Makes the application user a super admin. The super admin role has completely unrestricted access to all organization resources and settings. This role should be limited to as few users as possible. For daily administrative tasks, assign users the organization admin role instead using the `OrganizationPermission` resource.
        :param pulumi.Input[_builtins.str] name: Name of the application user.
        :param pulumi.Input[_builtins.str] organization_id: The ID of the organization the application user belongs to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OrganizationApplicationUserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages an organization application user. [Application users](https://aiven.io/docs/platform/concepts/application-users) can be used for
        programmatic access to the platform using a token created with the `OrganizationApplicationUserToken` resource.

        You give application users access to your organization, projects, and services using the `OrganizationPermission` resource. You can also add application users to
        groups using the `OrganizationUserGroupMember` resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        tf_user = aiven.OrganizationApplicationUser("tf_user",
            organization_id=main["id"],
            name="app-terraform")
        ```

        ## Import

        ```sh
        $ pulumi import aiven:index/organizationApplicationUser:OrganizationApplicationUser example ORGANIZATION_ID/USER_ID
        ```

        :param str resource_name: The name of the resource.
        :param OrganizationApplicationUserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OrganizationApplicationUserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 is_super_admin: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OrganizationApplicationUserArgs.__new__(OrganizationApplicationUserArgs)

            __props__.__dict__["is_super_admin"] = is_super_admin
            __props__.__dict__["name"] = name
            if organization_id is None and not opts.urn:
                raise TypeError("Missing required property 'organization_id'")
            __props__.__dict__["organization_id"] = organization_id
            __props__.__dict__["email"] = None
            __props__.__dict__["user_id"] = None
        super(OrganizationApplicationUser, __self__).__init__(
            'aiven:index/organizationApplicationUser:OrganizationApplicationUser',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            email: Optional[pulumi.Input[_builtins.str]] = None,
            is_super_admin: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            organization_id: Optional[pulumi.Input[_builtins.str]] = None,
            user_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'OrganizationApplicationUser':
        """
        Get an existing OrganizationApplicationUser resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] email: An email address automatically generated by Aiven to help identify the application user. No notifications are sent to this email.
        :param pulumi.Input[_builtins.bool] is_super_admin: Makes the application user a super admin. The super admin role has completely unrestricted access to all organization resources and settings. This role should be limited to as few users as possible. For daily administrative tasks, assign users the organization admin role instead using the `OrganizationPermission` resource.
        :param pulumi.Input[_builtins.str] name: Name of the application user.
        :param pulumi.Input[_builtins.str] organization_id: The ID of the organization the application user belongs to.
        :param pulumi.Input[_builtins.str] user_id: The ID of the application user.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OrganizationApplicationUserState.__new__(_OrganizationApplicationUserState)

        __props__.__dict__["email"] = email
        __props__.__dict__["is_super_admin"] = is_super_admin
        __props__.__dict__["name"] = name
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["user_id"] = user_id
        return OrganizationApplicationUser(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def email(self) -> pulumi.Output[_builtins.str]:
        """
        An email address automatically generated by Aiven to help identify the application user. No notifications are sent to this email.
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter(name="isSuperAdmin")
    @_utilities.deprecated("""This field is no longer accepted by the API. For administrative tasks, assign application users the organization admin role instead using the OrganizationPermission resource.""")
    def is_super_admin(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Makes the application user a super admin. The super admin role has completely unrestricted access to all organization resources and settings. This role should be limited to as few users as possible. For daily administrative tasks, assign users the organization admin role instead using the `OrganizationPermission` resource.
        """
        return pulumi.get(self, "is_super_admin")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the application user.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the organization the application user belongs to.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the application user.
        """
        return pulumi.get(self, "user_id")

