# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OrganizationProjectArgs', 'OrganizationProject']

@pulumi.input_type
class OrganizationProjectArgs:
    def __init__(__self__, *,
                 billing_group_id: pulumi.Input[_builtins.str],
                 organization_id: pulumi.Input[_builtins.str],
                 parent_id: pulumi.Input[_builtins.str],
                 project_id: pulumi.Input[_builtins.str],
                 base_port: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['OrganizationProjectTagArgs']]]] = None,
                 technical_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['OrganizationProjectTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a OrganizationProject resource.
        :param pulumi.Input[_builtins.str] billing_group_id: Billing group ID to assign to the project. It's required when moving projects between organizations.
        :param pulumi.Input[_builtins.str] organization_id: ID of an organization. Maximum length: `36`.
        :param pulumi.Input[_builtins.str] parent_id: Link a project to an [organization or organizational unit](https://aiven.io/docs/platform/concepts/orgs-units-projects) by using its ID. To set up proper dependencies please refer to this variable as a reference.
        :param pulumi.Input[_builtins.str] project_id: The name of the project. Names must be globally unique among all Aiven customers. Names must begin with a letter (a-z), and consist of letters, numbers, and dashes. It's recommended to use a random string or your organization name as a prefix or suffix. Changing this property forces recreation of the resource. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.int] base_port: Valid port number (1-65535) to use as a base for service port allocation.
        :param pulumi.Input[Sequence[pulumi.Input['OrganizationProjectTagArgs']]] tags: Tags are key-value pairs that allow you to categorize projects.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] technical_emails: The email addresses for [project contacts](https://aiven.io/docs/platform/howto/technical-emails), who will receive important alerts and updates about this project and its services. You can also set email contacts at the service level. It's good practice to keep these up-to-date to be aware of any potential issues with your project.
        """
        pulumi.set(__self__, "billing_group_id", billing_group_id)
        pulumi.set(__self__, "organization_id", organization_id)
        pulumi.set(__self__, "parent_id", parent_id)
        pulumi.set(__self__, "project_id", project_id)
        if base_port is not None:
            pulumi.set(__self__, "base_port", base_port)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if technical_emails is not None:
            pulumi.set(__self__, "technical_emails", technical_emails)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="billingGroupId")
    def billing_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        Billing group ID to assign to the project. It's required when moving projects between organizations.
        """
        return pulumi.get(self, "billing_group_id")

    @billing_group_id.setter
    def billing_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "billing_group_id", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of an organization. Maximum length: `36`.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> pulumi.Input[_builtins.str]:
        """
        Link a project to an [organization or organizational unit](https://aiven.io/docs/platform/concepts/orgs-units-projects) by using its ID. To set up proper dependencies please refer to this variable as a reference.
        """
        return pulumi.get(self, "parent_id")

    @parent_id.setter
    def parent_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "parent_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the project. Names must be globally unique among all Aiven customers. Names must begin with a letter (a-z), and consist of letters, numbers, and dashes. It's recommended to use a random string or your organization name as a prefix or suffix. Changing this property forces recreation of the resource. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="basePort")
    def base_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Valid port number (1-65535) to use as a base for service port allocation.
        """
        return pulumi.get(self, "base_port")

    @base_port.setter
    def base_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "base_port", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OrganizationProjectTagArgs']]]]:
        """
        Tags are key-value pairs that allow you to categorize projects.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OrganizationProjectTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="technicalEmails")
    def technical_emails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The email addresses for [project contacts](https://aiven.io/docs/platform/howto/technical-emails), who will receive important alerts and updates about this project and its services. You can also set email contacts at the service level. It's good practice to keep these up-to-date to be aware of any potential issues with your project.
        """
        return pulumi.get(self, "technical_emails")

    @technical_emails.setter
    def technical_emails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "technical_emails", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['OrganizationProjectTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['OrganizationProjectTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _OrganizationProjectState:
    def __init__(__self__, *,
                 base_port: Optional[pulumi.Input[_builtins.int]] = None,
                 billing_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['OrganizationProjectTagArgs']]]] = None,
                 technical_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['OrganizationProjectTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering OrganizationProject resources.
        :param pulumi.Input[_builtins.int] base_port: Valid port number (1-65535) to use as a base for service port allocation.
        :param pulumi.Input[_builtins.str] billing_group_id: Billing group ID to assign to the project. It's required when moving projects between organizations.
        :param pulumi.Input[_builtins.str] ca_cert: PEM encoded certificate.
        :param pulumi.Input[_builtins.str] organization_id: ID of an organization. Maximum length: `36`.
        :param pulumi.Input[_builtins.str] parent_id: Link a project to an [organization or organizational unit](https://aiven.io/docs/platform/concepts/orgs-units-projects) by using its ID. To set up proper dependencies please refer to this variable as a reference.
        :param pulumi.Input[_builtins.str] project_id: The name of the project. Names must be globally unique among all Aiven customers. Names must begin with a letter (a-z), and consist of letters, numbers, and dashes. It's recommended to use a random string or your organization name as a prefix or suffix. Changing this property forces recreation of the resource. Changing this property forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input['OrganizationProjectTagArgs']]] tags: Tags are key-value pairs that allow you to categorize projects.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] technical_emails: The email addresses for [project contacts](https://aiven.io/docs/platform/howto/technical-emails), who will receive important alerts and updates about this project and its services. You can also set email contacts at the service level. It's good practice to keep these up-to-date to be aware of any potential issues with your project.
        """
        if base_port is not None:
            pulumi.set(__self__, "base_port", base_port)
        if billing_group_id is not None:
            pulumi.set(__self__, "billing_group_id", billing_group_id)
        if ca_cert is not None:
            pulumi.set(__self__, "ca_cert", ca_cert)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if parent_id is not None:
            pulumi.set(__self__, "parent_id", parent_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if technical_emails is not None:
            pulumi.set(__self__, "technical_emails", technical_emails)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="basePort")
    def base_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Valid port number (1-65535) to use as a base for service port allocation.
        """
        return pulumi.get(self, "base_port")

    @base_port.setter
    def base_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "base_port", value)

    @_builtins.property
    @pulumi.getter(name="billingGroupId")
    def billing_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Billing group ID to assign to the project. It's required when moving projects between organizations.
        """
        return pulumi.get(self, "billing_group_id")

    @billing_group_id.setter
    def billing_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "billing_group_id", value)

    @_builtins.property
    @pulumi.getter(name="caCert")
    def ca_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        PEM encoded certificate.
        """
        return pulumi.get(self, "ca_cert")

    @ca_cert.setter
    def ca_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ca_cert", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of an organization. Maximum length: `36`.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Link a project to an [organization or organizational unit](https://aiven.io/docs/platform/concepts/orgs-units-projects) by using its ID. To set up proper dependencies please refer to this variable as a reference.
        """
        return pulumi.get(self, "parent_id")

    @parent_id.setter
    def parent_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the project. Names must be globally unique among all Aiven customers. Names must begin with a letter (a-z), and consist of letters, numbers, and dashes. It's recommended to use a random string or your organization name as a prefix or suffix. Changing this property forces recreation of the resource. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OrganizationProjectTagArgs']]]]:
        """
        Tags are key-value pairs that allow you to categorize projects.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OrganizationProjectTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="technicalEmails")
    def technical_emails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The email addresses for [project contacts](https://aiven.io/docs/platform/howto/technical-emails), who will receive important alerts and updates about this project and its services. You can also set email contacts at the service level. It's good practice to keep these up-to-date to be aware of any potential issues with your project.
        """
        return pulumi.get(self, "technical_emails")

    @technical_emails.setter
    def technical_emails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "technical_emails", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['OrganizationProjectTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['OrganizationProjectTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.type_token("aiven:index/organizationProject:OrganizationProject")
class OrganizationProject(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 base_port: Optional[pulumi.Input[_builtins.int]] = None,
                 billing_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OrganizationProjectTagArgs', 'OrganizationProjectTagArgsDict']]]]] = None,
                 technical_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['OrganizationProjectTimeoutsArgs', 'OrganizationProjectTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Creates and manages an [Aiven project](https://aiven.io/docs/platform/concepts/orgs-units-projects#projects).

        **This resource is in the beta stage and may change without notice.** Set
        the `PROVIDER_AIVEN_ENABLE_BETA` environment variable to use the resource.

        ## Import

        ```sh
        $ pulumi import aiven:index/organizationProject:OrganizationProject example_project ORGANIZATION_ID/PROJECT_ID
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] base_port: Valid port number (1-65535) to use as a base for service port allocation.
        :param pulumi.Input[_builtins.str] billing_group_id: Billing group ID to assign to the project. It's required when moving projects between organizations.
        :param pulumi.Input[_builtins.str] organization_id: ID of an organization. Maximum length: `36`.
        :param pulumi.Input[_builtins.str] parent_id: Link a project to an [organization or organizational unit](https://aiven.io/docs/platform/concepts/orgs-units-projects) by using its ID. To set up proper dependencies please refer to this variable as a reference.
        :param pulumi.Input[_builtins.str] project_id: The name of the project. Names must be globally unique among all Aiven customers. Names must begin with a letter (a-z), and consist of letters, numbers, and dashes. It's recommended to use a random string or your organization name as a prefix or suffix. Changing this property forces recreation of the resource. Changing this property forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OrganizationProjectTagArgs', 'OrganizationProjectTagArgsDict']]]] tags: Tags are key-value pairs that allow you to categorize projects.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] technical_emails: The email addresses for [project contacts](https://aiven.io/docs/platform/howto/technical-emails), who will receive important alerts and updates about this project and its services. You can also set email contacts at the service level. It's good practice to keep these up-to-date to be aware of any potential issues with your project.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OrganizationProjectArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages an [Aiven project](https://aiven.io/docs/platform/concepts/orgs-units-projects#projects).

        **This resource is in the beta stage and may change without notice.** Set
        the `PROVIDER_AIVEN_ENABLE_BETA` environment variable to use the resource.

        ## Import

        ```sh
        $ pulumi import aiven:index/organizationProject:OrganizationProject example_project ORGANIZATION_ID/PROJECT_ID
        ```

        :param str resource_name: The name of the resource.
        :param OrganizationProjectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OrganizationProjectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 base_port: Optional[pulumi.Input[_builtins.int]] = None,
                 billing_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OrganizationProjectTagArgs', 'OrganizationProjectTagArgsDict']]]]] = None,
                 technical_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['OrganizationProjectTimeoutsArgs', 'OrganizationProjectTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OrganizationProjectArgs.__new__(OrganizationProjectArgs)

            __props__.__dict__["base_port"] = base_port
            if billing_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'billing_group_id'")
            __props__.__dict__["billing_group_id"] = billing_group_id
            if organization_id is None and not opts.urn:
                raise TypeError("Missing required property 'organization_id'")
            __props__.__dict__["organization_id"] = organization_id
            if parent_id is None and not opts.urn:
                raise TypeError("Missing required property 'parent_id'")
            __props__.__dict__["parent_id"] = parent_id
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["technical_emails"] = technical_emails
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["ca_cert"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["caCert"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(OrganizationProject, __self__).__init__(
            'aiven:index/organizationProject:OrganizationProject',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            base_port: Optional[pulumi.Input[_builtins.int]] = None,
            billing_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
            organization_id: Optional[pulumi.Input[_builtins.str]] = None,
            parent_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OrganizationProjectTagArgs', 'OrganizationProjectTagArgsDict']]]]] = None,
            technical_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            timeouts: Optional[pulumi.Input[Union['OrganizationProjectTimeoutsArgs', 'OrganizationProjectTimeoutsArgsDict']]] = None) -> 'OrganizationProject':
        """
        Get an existing OrganizationProject resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] base_port: Valid port number (1-65535) to use as a base for service port allocation.
        :param pulumi.Input[_builtins.str] billing_group_id: Billing group ID to assign to the project. It's required when moving projects between organizations.
        :param pulumi.Input[_builtins.str] ca_cert: PEM encoded certificate.
        :param pulumi.Input[_builtins.str] organization_id: ID of an organization. Maximum length: `36`.
        :param pulumi.Input[_builtins.str] parent_id: Link a project to an [organization or organizational unit](https://aiven.io/docs/platform/concepts/orgs-units-projects) by using its ID. To set up proper dependencies please refer to this variable as a reference.
        :param pulumi.Input[_builtins.str] project_id: The name of the project. Names must be globally unique among all Aiven customers. Names must begin with a letter (a-z), and consist of letters, numbers, and dashes. It's recommended to use a random string or your organization name as a prefix or suffix. Changing this property forces recreation of the resource. Changing this property forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OrganizationProjectTagArgs', 'OrganizationProjectTagArgsDict']]]] tags: Tags are key-value pairs that allow you to categorize projects.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] technical_emails: The email addresses for [project contacts](https://aiven.io/docs/platform/howto/technical-emails), who will receive important alerts and updates about this project and its services. You can also set email contacts at the service level. It's good practice to keep these up-to-date to be aware of any potential issues with your project.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OrganizationProjectState.__new__(_OrganizationProjectState)

        __props__.__dict__["base_port"] = base_port
        __props__.__dict__["billing_group_id"] = billing_group_id
        __props__.__dict__["ca_cert"] = ca_cert
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["parent_id"] = parent_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["technical_emails"] = technical_emails
        __props__.__dict__["timeouts"] = timeouts
        return OrganizationProject(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="basePort")
    def base_port(self) -> pulumi.Output[_builtins.int]:
        """
        Valid port number (1-65535) to use as a base for service port allocation.
        """
        return pulumi.get(self, "base_port")

    @_builtins.property
    @pulumi.getter(name="billingGroupId")
    def billing_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        Billing group ID to assign to the project. It's required when moving projects between organizations.
        """
        return pulumi.get(self, "billing_group_id")

    @_builtins.property
    @pulumi.getter(name="caCert")
    def ca_cert(self) -> pulumi.Output[_builtins.str]:
        """
        PEM encoded certificate.
        """
        return pulumi.get(self, "ca_cert")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of an organization. Maximum length: `36`.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> pulumi.Output[_builtins.str]:
        """
        Link a project to an [organization or organizational unit](https://aiven.io/docs/platform/concepts/orgs-units-projects) by using its ID. To set up proper dependencies please refer to this variable as a reference.
        """
        return pulumi.get(self, "parent_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the project. Names must be globally unique among all Aiven customers. Names must begin with a letter (a-z), and consist of letters, numbers, and dashes. It's recommended to use a random string or your organization name as a prefix or suffix. Changing this property forces recreation of the resource. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.OrganizationProjectTag']]]:
        """
        Tags are key-value pairs that allow you to categorize projects.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="technicalEmails")
    def technical_emails(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The email addresses for [project contacts](https://aiven.io/docs/platform/howto/technical-emails), who will receive important alerts and updates about this project and its services. You can also set email contacts at the service level. It's good practice to keep these up-to-date to be aware of any potential issues with your project.
        """
        return pulumi.get(self, "technical_emails")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.OrganizationProjectTimeouts']]:
        return pulumi.get(self, "timeouts")

