"""Representation of coordinates in different systems."""

__all__: list[str] = []


import unxt as u

_2pid = u.Angle(360, "deg")


def converter_azimuth_to_range(
    phi: u.AbstractQuantity,
    /,
) -> u.AbstractQuantity:
    """Wrap a polar angle to the range [0, 2pi).

    It's safe to do this conversion since this is a phase cut, unlike `theta`,
    which is only on half the sphere.

    Examples
    --------
    >>> import unxt as u
    >>> x = u.Quantity(370, "deg")
    >>> converter_azimuth_to_range(x)
    Quantity(Array(10, dtype=int32, ...), unit='deg')

    """
    # TODO: have an integer-preserving version of this
    return phi % _2pid
