"""2-dimensional representations."""
# pylint: disable=duplicate-code

__all__ = [
    # Base
    "AbstractPos2D",
    "AbstractVel2D",
    "AbstractAcc2D",
    # TwoSphere
    "TwoSpherePos",
    "TwoSphereVel",
    "TwoSphereAcc",
    # Polar
    "PolarPos",
    "PolarVel",
    "PolarAcc",
    # Cartesian
    "CartesianPos2D",
    "CartesianVel2D",
    "CartesianAcc2D",
]

from .base import AbstractAcc2D, AbstractPos2D, AbstractVel2D
from .cartesian import CartesianAcc2D, CartesianPos2D, CartesianVel2D
from .polar import PolarAcc, PolarPos, PolarVel
from .spherical import TwoSphereAcc, TwoSpherePos, TwoSphereVel

# isort: split
from . import (
    register_primitives,  # noqa: F401
    register_vectorapi,  # noqa: F401
)
